/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.palette;

import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.netbeans.modules.compapp.casaeditor.api.CasaPaletteItemID;
import org.netbeans.modules.compapp.casaeditor.api.CasaPalettePlugin;
import org.netbeans.modules.compapp.casaeditor.api.InternalProjectTypePalettePlugin;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.palette.CasaBasePlugin;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPaletteCategoryChildren;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPaletteRootNode;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaPalette {
    public static final String CATEGORY_ID_WSDL_BINDINGS = NbBundle.getMessage(CasaPalette.class, (String)"WSDLBindings");
    public static final String CATEGORY_ID_SERVICE_UNITS = NbBundle.getMessage(CasaPalette.class, (String)"ServiceUnits");
    public static final String CATEGORY_ID_END_POINTS = NbBundle.getMessage(CasaPalette.class, (String)"EndPoints");
    public static final CasaPaletteItemID ITEM_ID_CONSUME = new CasaPaletteItemID(CasaBasePlugin.getInstance(), CATEGORY_ID_END_POINTS, NbBundle.getMessage(CasaPalette.class, (String)"Palette_Consume_Title"), CasaFactory.getCasaCustomizer().getBOOLEAN_CLASSIC_ENDPOINT_PIN_STYLE() != false ? "org/netbeans/modules/compapp/casaeditor/palette/resources/consumesPaletteClassic.png" : "org/netbeans/modules/compapp/casaeditor/palette/resources/consumesPalette.png");
    public static final CasaPaletteItemID ITEM_ID_PROVIDE = new CasaPaletteItemID(CasaBasePlugin.getInstance(), CATEGORY_ID_END_POINTS, NbBundle.getMessage(CasaPalette.class, (String)"Palette_Provide_Title"), CasaFactory.getCasaCustomizer().getBOOLEAN_CLASSIC_ENDPOINT_PIN_STYLE() != false ? "org/netbeans/modules/compapp/casaeditor/palette/resources/providesPaletteClassic.png" : "org/netbeans/modules/compapp/casaeditor/palette/resources/providesPalette.png");
    public static final CasaPaletteItemID ITEM_ID_INTERNAL_SU = new CasaPaletteItemID(CasaBasePlugin.getInstance(), CATEGORY_ID_SERVICE_UNITS, NbBundle.getMessage(CasaPalette.class, (String)"Palette_IntSU_Title"), "org/netbeans/modules/compapp/casaeditor/palette/resources/intsu.png");
    public static final CasaPaletteItemID ITEM_ID_EXTERNAL_SU = new CasaPaletteItemID(CasaBasePlugin.getInstance(), CATEGORY_ID_SERVICE_UNITS, NbBundle.getMessage(CasaPalette.class, (String)"Palette_ExtSU_Title"), "org/netbeans/modules/compapp/casaeditor/palette/resources/extsu.png");
    public static final DataFlavor CasaPaletteDataFlavor = new DataFlavor((Class)CasaPaletteItemID.class, "CasaPaletteData"){};
    private static String CASA_PALETTE_ROOT = "CasaPalette";
    private static PaletteController palette = null;
    private static CasaPaletteRootNode paletteRoot;

    private CasaPalette() {
    }

    public static PaletteController getPalette(Lookup lookup) {
        if (null == palette) {
            paletteRoot = new CasaPaletteRootNode((Children)new CasaPaletteCategoryChildren(lookup), lookup);
            paletteRoot.setName(CASA_PALETTE_ROOT);
            palette = PaletteFactory.createPalette((Node)paletteRoot, (PaletteActions)new MyPaletteActions());
            CasaPalette.disableCreateCategoryAction((Node)palette.getRoot().lookup(Node.class));
        }
        return palette;
    }

    public static Collection<? extends CasaPalettePlugin> getPlugins() {
        ArrayList<CasaPalettePlugin> arrayList = new ArrayList<CasaPalettePlugin>();
        arrayList.add(CasaBasePlugin.getInstance());
        Collection collection = Lookup.getDefault().lookupAll(InternalProjectTypePlugin.class);
        for (InternalProjectTypePlugin internalProjectTypePlugin : collection) {
            if (internalProjectTypePlugin.getCategoryName() == null) continue;
            InternalProjectTypePalettePlugin internalProjectTypePalettePlugin = new InternalProjectTypePalettePlugin(internalProjectTypePlugin);
            arrayList.add(internalProjectTypePalettePlugin);
        }
        return arrayList;
    }

    private static void disableCreateCategoryAction(Node node) {
        ResourceBundle resourceBundle = NbBundle.getBundle(node.getClass());
        if (resourceBundle != null) {
            String string = null;
            try {
                string = resourceBundle.getString("CTL_CreateCategory");
            }
            catch (MissingResourceException missingResourceException) {
                ErrorManager.getDefault().notify((Throwable)missingResourceException);
                return;
            }
            if (string != null) {
                CasaPalette.disableActionByName(node, string);
                for (Node node2 : node.getChildren().getNodes()) {
                    CasaPalette.disableActionByName(node2, string);
                }
            }
        }
    }

    private static void disableActionByName(Node node, String string) {
        for (Action action : node.getActions(true)) {
            String string2;
            if (action == null || (string2 = (String)action.getValue("Name")) == null || string2.length() <= 0 || !string2.equals(string)) continue;
            action.setEnabled(false);
        }
    }

    private static class MyPaletteActions
    extends PaletteActions {
        private MyPaletteActions() {
        }

        public Action[] getImportActions() {
            return new Action[0];
        }

        public Action[] getCustomPaletteActions() {
            return new Action[0];
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            return new Action[0];
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            return new Action[0];
        }

        public Action getPreferredAction(Lookup lookup) {
            return null;
        }
    }
}

