/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.netbeans.modules.compapp.casaeditor.api.CasaPaletteItemID;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPalette;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public class CasaPaletteItemNode
extends AbstractNode {
    private CasaPaletteItemID mPaletteItem;
    private boolean mbDefaultBigIcons = false;
    private static Image ms32BigImage = null;
    private String mIconFileName;

    public CasaPaletteItemNode(CasaPaletteItemID casaPaletteItemID, Lookup lookup, boolean bl) {
        super(Children.LEAF, lookup);
        this.mPaletteItem = casaPaletteItemID;
        this.setName(casaPaletteItemID.getDisplayName());
        this.setDisplayName(casaPaletteItemID.getDisplayName());
        this.mbDefaultBigIcons = bl;
        this.mIconFileName = casaPaletteItemID.getIconFileBase();
        this.setIconBaseWithExtension(this.mIconFileName);
    }

    public CasaPaletteItemNode(CasaPaletteItemID casaPaletteItemID, Lookup lookup) {
        this(casaPaletteItemID, lookup, false);
    }

    public CasaPaletteItemID getCasaPaletteItem() {
        return this.mPaletteItem;
    }

    public Transferable drag() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.drag());
        exTransferable.put(new ExTransferable.Single(CasaPalette.CasaPaletteDataFlavor){

            protected Object getData() throws IOException, UnsupportedFlavorException {
                return CasaPaletteItemNode.this.mPaletteItem;
            }
        });
        return exTransferable;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Image getIcon(int n) {
        if (this.mbDefaultBigIcons && (n == 2 || n == 4)) {
            URL uRL;
            String string = this.mIconFileName.replaceFirst("16\\.", "\\.");
            if (!(string = string.replaceFirst("\\.", "32\\.")).startsWith("/")) {
                string = "/" + string;
            }
            if ((uRL = this.mPaletteItem.getClass().getResource(string)) == null) {
                if (ms32BigImage == null) {
                    ImageIcon imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/compapp/casaeditor/palette/resources/bc32.png"));
                    ms32BigImage = imageIcon.getImage();
                }
                return ms32BigImage;
            }
        }
        return super.getIcon(n);
    }
}

