/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties;

import java.beans.PropertyEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class IntegerEditor
extends PropertyEditorSupport {
    public static final String EMPTY = "";
    private int minInclusive;
    private int maxInclusive;

    public IntegerEditor() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerEditor(int n, int n2) {
        this.minInclusive = n;
        this.maxInclusive = n2;
    }

    public String getAsText() {
        Object object = super.getValue();
        return object == null ? EMPTY : super.getAsText();
    }

    public void setAsText(String string) {
        if (string.trim().equals(EMPTY)) {
            this.setValue(EMPTY);
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < this.minInclusive) {
                String string2 = NbBundle.getMessage(this.getClass(), (String)"MSG_OUT_OF_LOWER_BOUND_INTEGER", (Object)n, (Object)this.minInclusive);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else if (n > this.maxInclusive) {
                String string3 = NbBundle.getMessage(this.getClass(), (String)"MSG_OUT_OF_UPPER_BOUND_INTEGER", (Object)n, (Object)this.maxInclusive);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                this.setValue(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = NbBundle.getMessage(this.getClass(), (String)"MSG_INVALID_INTEGER", (Object)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string4, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public boolean isPaintable() {
        return false;
    }

    protected String getPaintableString() {
        String string = (String)this.getValue();
        return string == null ? NbBundle.getMessage(IntegerEditor.class, (String)"LBL_Null") : string;
    }
}

