/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortTypeEditorPanel
extends JPanel {
    private List<PortType> mPortTypes;
    private PortType mPortType;
    Map<PortType, QName> mapPTtoQName = new HashMap<PortType, QName>();
    private JTextField LocalNameLabel;
    private JTextField NameSpaceLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox mPortTypesComboBox;

    public PortTypeEditorPanel(List<PortType> list, PortType portType, boolean bl) {
        this.initComponents();
        this.initialize(list, portType, bl);
    }

    private void initialize(List<PortType> list, PortType portType, boolean bl) {
        QName qName;
        this.LocalNameLabel.setEditable(false);
        this.NameSpaceLabel.setEditable(false);
        this.mPortTypes = list;
        this.mPortType = portType;
        for (PortType portType2 : list) {
            if (portType2 == null) continue;
            qName = CasaWrapperModel.isDummyPortType(portType2) ? new QName("", "") : new QName(portType2.getModel().getDefinitions().getTargetNamespace(), portType2.getName());
            this.mPortTypesComboBox.addItem(qName);
            this.mapPTtoQName.put(portType2, qName);
        }
        qName = new QName("", "");
        if (portType != null) {
            qName = this.mapPTtoQName.get(portType);
            this.mPortTypesComboBox.setSelectedItem(qName);
        }
        this.updateLables(qName);
        this.mPortTypesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QName qName = (QName)PortTypeEditorPanel.this.mPortTypesComboBox.getSelectedItem();
                PortTypeEditorPanel.this.mPortTypesComboBox.setToolTipText(qName.toString());
                PortTypeEditorPanel.this.updateLables(qName);
            }
        });
        this.mPortTypesComboBox.setEnabled(bl);
    }

    private void updateLables(QName qName) {
        String string = "";
        string = qName.getLocalPart().length() > 0 ? qName.getLocalPart() : NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel_None");
        this.LocalNameLabel.setText(string);
        this.LocalNameLabel.setToolTipText(string);
        string = "";
        string = qName.getNamespaceURI().length() > 0 ? qName.getNamespaceURI() : NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel_None");
        this.NameSpaceLabel.setText(string);
        this.NameSpaceLabel.setToolTipText(string);
    }

    public Object getValue() {
        return this.mPortTypes.get(this.mPortTypesComboBox.getSelectedIndex());
    }

    public void setValue(Object object) {
        if (object != null) {
            this.mPortTypesComboBox.setSelectedItem(this.mapPTtoQName.get(object));
        } else {
            this.mPortTypesComboBox.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.mPortTypesComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.LocalNameLabel = new JTextField();
        this.NameSpaceLabel = new JTextField();
        this.jLabel1.setLabelFor(this.mPortTypesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel.jLabel1.text_1"));
        this.jLabel2.setLabelFor(this.LocalNameLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel.jLabel2.text"));
        this.jLabel3.setLabelFor(this.NameSpaceLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel.jLabel3.text"));
        this.LocalNameLabel.setText(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel.LocalNameLabel.text"));
        this.LocalNameLabel.setFocusable(false);
        this.NameSpaceLabel.setText(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"PortTypeEditorPanel.NameSpaceLabel.text"));
        this.NameSpaceLabel.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.LocalNameLabel, -1, 422, Short.MAX_VALUE).add((Component)this.NameSpaceLabel, -1, 422, Short.MAX_VALUE).add(1, (Component)this.mPortTypesComboBox, 0, 422, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.mPortTypesComboBox, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.LocalNameLabel, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.NameSpaceLabel, -2, -1, -2)).addContainerGap(82, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ACSN_InterfaceName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ASCD_InterfaceName"));
        this.mPortTypesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ACSN_InterfaceNames"));
        this.mPortTypesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ACSD_InterfaceNameCombo"));
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ASCN_LocalName"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ASCD_LocalName"));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ASCN_NameSpace"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PortTypeEditorPanel.class, (String)"ASCD_NameSpace"));
    }
}

