/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties.extension;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaExtensibilityElement;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.properties.NamespaceEditor;
import org.netbeans.modules.compapp.casaeditor.properties.spi.ExtensionProperty;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameExtensionProperty
extends ExtensionProperty<QName> {
    public QNameExtensionProperty(CasaNode casaNode, CasaComponent casaComponent, CasaExtensibilityElement casaExtensibilityElement, CasaExtensibilityElement casaExtensibilityElement2, String string, String string2, String string3, String string4) {
        super(casaNode, casaComponent, casaExtensibilityElement, casaExtensibilityElement2, string, QName.class, string2, string3, string4);
    }

    @Override
    public QName getValue() {
        CasaExtensibilityElement casaExtensibilityElement = (CasaExtensibilityElement)this.getComponent();
        return QNameExtensionProperty.getAttributeNSName(casaExtensibilityElement.getPeer(), this.getName());
    }

    @Override
    public void setValue(QName qName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String string = null;
        String string2 = QNameExtensionProperty.getNamespacePrefix(this.extensionPointComponent.getPeer(), qName.getNamespaceURI());
        String string3 = null;
        if (string2 != null) {
            string = string2 + ":" + qName.getLocalPart();
        } else {
            string3 = qName.getPrefix();
            string = string3 + ":" + qName.getLocalPart();
        }
        CasaExtensibilityElement casaExtensibilityElement = (CasaExtensibilityElement)this.getComponent();
        if (this.firstEE.getParent() == null) {
            casaExtensibilityElement.setAttribute(this.getName(), string);
            if (string3 != null) {
                casaExtensibilityElement.setAttribute("xmlns:" + string3, qName.getNamespaceURI());
            }
            this.getModel().addExtensibilityElement(this.extensionPointComponent, this.firstEE);
        } else {
            if (string3 != null) {
                this.getModel().setExtensibilityElementAttribute(casaExtensibilityElement, "xmlns:" + string3, qName.getNamespaceURI());
            }
            this.getModel().setExtensibilityElementAttribute(casaExtensibilityElement, this.getName(), string);
        }
    }

    private static QName getAttributeNSName(Element element, String string) {
        String string2 = element.getAttribute(string);
        return QNameExtensionProperty.getNSName(element, string2);
    }

    private static QName getNSName(Element element, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            return new QName(QNameExtensionProperty.getNamespaceURI(element, string3), string2);
        }
        return new QName(string);
    }

    private static String getNamespaceURI(Node node, String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        string = string.trim();
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                String string2 = ((Attr)node2).getName();
                if (string2 == null || !string2.trim().equals("xmlns:" + string)) continue;
                return ((Attr)node2).getValue();
            }
            Node node3 = node.getParentNode();
            if (node3 != null) {
                return QNameExtensionProperty.getNamespaceURI(node3, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String getNamespacePrefix(Node node, String string) {
        if (string == null || string.trim().length() < 1) {
            return null;
        }
        string = string.trim();
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                String string2 = ((Attr)node2).getName();
                if (string2 == null || !string2.startsWith("xmlns:") || !((Attr)node2).getValue().equals(string)) continue;
                return string2.substring(6);
            }
            Node node3 = node.getParentNode();
            if (node3 != null) {
                return QNameExtensionProperty.getNamespacePrefix(node3, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return new NamespaceEditor(this.getModel(), this.getValue(), this.getDisplayName(), this.canWrite());
    }
}

