/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsConfigurationHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.BasicModuleConfWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DescriptorsWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.JavaMELibsWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomComponentWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String UTF_8 = "UTF-8";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String DATA = "data";
    private static final String PROJECT_XML = "nbproject/project.xml";
    private static final String BUILD_IMPL_XML = "nbproject/build-impl.xml";
    private static final String BUILD_XML = "build.xml";
    public static final String WIZARD_PANEL_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String LBL_WIZARD_STEPS_COUNT = "LBL_WizardStepsCount";
    public static final String CONTENT_DATA = "WizardPanel_contentData";
    public static final String SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    public static final String STEP_BASIC_PARAMS = "LBL_BasicProjectParamsStep";
    public static final String LBL_LIBRARIES = "LBL_LibrariesDescStep";
    public static final String LBL_COMPONENT_DESC = "LBL_ComponentsDescStep";
    public static final String FINAL_STEP = "LBL_FinalStep";
    public static final String PROJECT_DIR = "projDir";
    public static final String PROJECT_NAME = "projName";
    public static final String SET_AS_MAIN = "setAsMain";
    public static final String LAYER_PATH = "layer";
    public static final String BUNDLE_PATH = "bundle";
    public static final String CODE_BASE_NAME = "codeBaseName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String LIBRARIES = "libraries";
    public static final String LIB_DISPLAY_NAMES = "libDisplayNames";
    public static final String LIB_NAMES = "libNames";
    public static final String CUSTOM_COMPONENTS = "customComponents";
    private static final String CODE_NAME_PARAM = "_CODE_NAME_";
    private static final String BUNDLE_PATH_PARAM = "_BUNDLE_PATH_";
    private static final String PROJECT_NAME_PARAM = "_PROJECT_NAME_";
    public static final String BUNDLE_PROPERTIES = "Bundle.properties";
    public static final String LAYER_XML = "layer.xml";
    private static final String SRC = "src/";
    private static final String BUNDLE_NAME = "src/Bundle.properties";
    private static final String LAYER_NAME = "src/layer.xml";
    private static final String MANIFEST = "manifest.mf";
    private static final String LAYER = "OpenIDE-Module-Layer: ";
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor myWizard;

    private CustomComponentWizardIterator() {
    }

    public static CustomComponentWizardIterator createIterator() {
        return new CustomComponentWizardIterator();
    }

    WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new CustomComponentWizardPanel(), new BasicModuleConfWizardPanel(), new JavaMELibsWizardPanel(), new DescriptorsWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(CustomComponentWizardIterator.class, (String)STEP_BASIC_PARAMS), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)FINAL_STEP), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_LIBRARIES), NbBundle.getMessage(CustomComponentWizardIterator.class, (String)LBL_COMPONENT_DESC)};
    }

    public Set instantiate() throws IOException {
        File file;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file2 = FileUtil.normalizeFile((File)((File)this.myWizard.getProperty(PROJECT_DIR)));
        file2.mkdirs();
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.myWizard);
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        CustomComponentWizardIterator.unZipFile(fileObject.getInputStream(), fileObject2, this.myWizard);
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add(file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        ProjectManager.getDefault().clearNonProjectCache();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        assert (project != null) : "crated project is null";
        JavaMELibsConfigurationHelper.configureJavaMELibs(project, this.myWizard);
        CustomComponentWizardIterator.configureComponents(project, this.myWizard);
        return linkedHashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.myWizard = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty(SELECTED_INDEX, new Integer(i));
            jComponent.putClientProperty(CONTENT_DATA, stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty(PROJECT_DIR, null);
        wizardDescriptor.putProperty(PROJECT_NAME, null);
        wizardDescriptor.putProperty(LIBRARIES, null);
        wizardDescriptor.putProperty(LIB_NAMES, null);
        wizardDescriptor.putProperty(LIB_DISPLAY_NAMES, null);
        wizardDescriptor.putProperty(CUSTOM_COMPONENTS, null);
        wizardDescriptor = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getBundle(CustomComponentWizardIterator.class).getString(LBL_WIZARD_STEPS_COUNT), new Integer(this.index + 1) + "", new Integer(this.panels.length) + "");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private static Set<FileObject> configureComponents(Project project, WizardDescriptor wizardDescriptor) throws IOException {
        List list = (List)wizardDescriptor.getProperty(CUSTOM_COMPONENTS);
        if (list == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (Map map : list) {
            CustomComponentHelper.RealInstantiationHelper realInstantiationHelper = new CustomComponentHelper.RealInstantiationHelper(project, map);
            linkedHashSet.addAll(((CustomComponentHelper)realInstantiationHelper).instantiate());
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream inputStream, FileObject fileObject, WizardDescriptor wizardDescriptor) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = null;
                if (PROJECT_XML.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    CustomComponentWizardIterator.filterProjectXML(fileObject2, zipInputStream, (String)wizardDescriptor.getProperty(CODE_BASE_NAME));
                    continue;
                }
                if (MANIFEST.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    CustomComponentWizardIterator.filterManifest(fileObject2, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (LAYER_NAME.equals(zipEntry.getName())) {
                    CustomComponentWizardIterator.copyLayer(fileObject, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (BUNDLE_NAME.equals(zipEntry.getName())) {
                    CustomComponentWizardIterator.filterBundle(fileObject, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (BUILD_XML.equals(zipEntry.getName()) || BUILD_IMPL_XML.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    CustomComponentWizardIterator.filterBuild(fileObject2, zipInputStream, (String)wizardDescriptor.getProperty(CODE_BASE_NAME));
                    continue;
                }
                fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                BaseHelper.copyByteAfterByte(zipInputStream, fileObject2);
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterBuild(FileObject fileObject, ZipInputStream zipInputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string2 = byteArrayOutputStream.toString(UTF_8);
        string2 = string2.replace(CODE_NAME_PARAM, string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(UTF_8));
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterBundle(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString(UTF_8);
        string = string.replace(PROJECT_NAME_PARAM, (String)wizardDescriptor.getProperty(DISPLAY_NAME));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(UTF_8));
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)(SRC + (String)wizardDescriptor.getProperty(BUNDLE_PATH)));
        OutputStream outputStream = fileObject2.getOutputStream();
        try {
            FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    private static void copyLayer(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        String string = (String)wizardDescriptor.getProperty(LAYER_PATH);
        if (string == null || string.length() == 0) {
            return;
        }
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)(SRC + string));
        BaseHelper.copyByteAfterByte(zipInputStream, fileObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterManifest(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString(UTF_8);
        string = string.replace(CODE_NAME_PARAM, (String)wizardDescriptor.getProperty(CODE_BASE_NAME));
        string = string.replace(BUNDLE_PATH_PARAM, (String)wizardDescriptor.getProperty(BUNDLE_PATH));
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = (String)wizardDescriptor.getProperty(LAYER_PATH);
        if (string2 != null) {
            stringBuilder.append(LAYER);
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes(UTF_8));
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            FileUtil.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterProjectXML(FileObject fileObject, ZipInputStream zipInputStream, String string) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
            Document document = XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), (boolean)false, (boolean)false, null, null);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName(CODE_NAME_BASE);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    if (element.getParentNode() == null || !DATA.equals(element.getParentNode().getNodeName())) continue;
                    NodeList nodeList2 = element.getChildNodes();
                    if (nodeList2.getLength() <= 0) break;
                    nodeList2.item(0).setNodeValue(string);
                    break;
                }
            }
            OutputStream outputStream = fileObject.getOutputStream();
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)UTF_8);
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            BaseHelper.copyByteAfterByte(zipInputStream, fileObject);
        }
    }
}

