/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileIndex
implements FileIndex,
SelfPersistent {
    private static final int DEFAULT_INDEX_CAPACITY = 53711;
    private final Map<Key, ChunkInfoBase> map = new ConcurrentHashMap<Key, ChunkInfoBase>(53711);

    public SimpleFileIndex() {
    }

    public SimpleFileIndex(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.map.put(KeyFactory.getDefaultFactory().readKey(dataInput), new ChunkInfoBase(dataInput));
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int remove(Key key) {
        ChunkInfo chunkInfo = this.map.remove(key);
        return chunkInfo == null ? 0 : chunkInfo.getSize();
    }

    @Override
    public Collection<Key> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<Key> getKeySetIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int put(Key key, long l, int n) {
        ChunkInfo chunkInfo = this.map.put(key, new ChunkInfoBase(l, n));
        return chunkInfo == null ? 0 : chunkInfo.getSize();
    }

    @Override
    public ChunkInfo get(Key key) {
        ChunkInfo chunkInfo = this.map.get(key);
        return chunkInfo;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.size());
        Set<Map.Entry<Key, ChunkInfoBase>> set = this.map.entrySet();
        for (Map.Entry<Key, ChunkInfoBase> entry : set) {
            KeyFactory.getDefaultFactory().writeKey(entry.getKey(), dataOutput);
            entry.getValue().write(dataOutput);
        }
    }

    private static final class ChunkInfoBase
    implements ChunkInfo,
    Comparable,
    SelfPersistent {
        private long offset;
        private int size;

        public ChunkInfoBase(long l, int n) {
            this.offset = l;
            this.size = n;
        }

        public ChunkInfoBase(DataInput dataInput) throws IOException {
            this.offset = dataInput.readLong();
            this.size = dataInput.readInt();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ChunkInfo [");
            stringBuilder.append("offset=");
            stringBuilder.append(this.getOffset());
            stringBuilder.append(" size=");
            stringBuilder.append(this.getSize());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public int compareTo(Object object) {
            if (object instanceof ChunkInfo) {
                return this.getOffset() < ((ChunkInfo)object).getOffset() ? -1 : 1;
            }
            return 1;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public void setOffset(long l) {
            this.offset = l;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeLong(this.offset);
            dataOutput.writeInt(this.size);
        }
    }
}

