/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.modules.cnd.repository.api.RepositoryTranslation;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.IntToStringCache;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTranslatorImpl
implements RepositoryTranslation {
    private static UnitsCache unitNamesCache = new UnitsCache();
    private static boolean loaded = false;
    private static final int DEFAULT_VERSION_OF_PERSISTENCE_MECHANIZM = 0;
    private static int version = 0;
    private static final String MASTER_INDEX_FILE_NAME = System.getProperty("netbeans.user") + File.separator + "var" + File.separator + "cache" + File.separator + "cnd-projects-index";
    private static final String PROJECT_INDEX_FILE_NAME = "project-index";

    public int getFileIdByName(int n, String string) {
        assert (string != null);
        IntToStringCache intToStringCache = RepositoryTranslatorImpl.getUnitFileNames(n);
        return intToStringCache.getId(string);
    }

    public String getFileNameById(int n, int n2) {
        IntToStringCache intToStringCache = RepositoryTranslatorImpl.getUnitFileNames(n);
        String string = intToStringCache.getValueById(n2);
        return string;
    }

    public String getFileNameByIdSafe(int n, int n2) {
        IntToStringCache intToStringCache = RepositoryTranslatorImpl.getUnitFileNames(n);
        String string = intToStringCache.containsId(n2) ? intToStringCache.getValueById(n2) : "?";
        return string;
    }

    public int getUnitId(String string) {
        if (!unitNamesCache.containsValue(string)) {
            StorageAllocator.getInstance().deleteUnitFiles(string, false);
        }
        return unitNamesCache.getId(string);
    }

    public String getUnitName(int n) {
        return unitNamesCache.getValueById(n);
    }

    private static IntToStringCache getUnitFileNames(int n) {
        return unitNamesCache.getFileNames(n);
    }

    private static void readMasterIndex(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        unitNamesCache = new UnitsCache(dataInput);
    }

    private static void writeUnitsCache(DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        unitNamesCache.write(dataOutput);
    }

    private static boolean readUnitFilesCache(String string, DataInput dataInput, Set<String> set) throws IOException {
        assert (string != null);
        assert (dataInput != null);
        IntToStringCache intToStringCache = new IntToStringCache(dataInput);
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            RepositoryTranslatorImpl.trace("Read unit files cache for %s ts=%d\n", string, intToStringCache.getTimestamp());
        }
        if (intToStringCache.getVersion() == version && UnitsCache.validateReqUnits(string, set)) {
            unitNamesCache.insertUnitFileCache(string, intToStringCache);
            return true;
        }
        intToStringCache = new IntToStringCache();
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            RepositoryTranslatorImpl.trace("Req. units validation failed for %s. Setting ts=%d\n", string, intToStringCache.getTimestamp());
        }
        unitNamesCache.insertUnitFileCache(string, intToStringCache);
        return false;
    }

    private static void writeUnitFilesCache(String string, DataOutput dataOutput) throws IOException {
        assert (string != null);
        assert (dataOutput != null);
        int n = unitNamesCache.getId(string);
        IntToStringCache intToStringCache = unitNamesCache.getFileNames(n);
        intToStringCache.write(dataOutput);
    }

    public static void closeUnit(String string, Set<String> set) {
        if (set != null) {
            UnitsCache.updateReqUnitInfo(string, set);
        }
        RepositoryTranslatorImpl.storeUnitIndex(string);
        unitNamesCache.removeFileNames(string);
    }

    public static void shutdown() {
        RepositoryTranslatorImpl.storeMasterIndex();
    }

    public static void loadUnitIndex(String string) {
        RepositoryTranslatorImpl.loadUnitIndex(string, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadUnitIndex(String string, Set<String> set) {
        if (UnitsCache.isUnitIndexLoaded(string)) {
            return;
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterInputStream filterInputStream = null;
        String string2 = RepositoryTranslatorImpl.getUnitIndexName(string);
        boolean bl = false;
        try {
            if (new File(string2).exists()) {
                fileInputStream = new FileInputStream(string2);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                filterInputStream = new DataInputStream(bufferedInputStream);
                bl = RepositoryTranslatorImpl.readUnitFilesCache(string, (DataInput)((Object)filterInputStream), set);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                    new File(string2).delete();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (!bl) {
            StorageAllocator.getInstance().deleteUnitFiles(string, false);
            RepositoryTranslatorImpl.unitNamesCache.cleanUnitData(string);
        }
    }

    private static String getUnitIndexName(String string) {
        return StorageAllocator.getInstance().getUnitStorageName(string) + PROJECT_INDEX_FILE_NAME;
    }

    public static void removeUnit(String string) {
        File file = new File(RepositoryTranslatorImpl.getUnitIndexName(string));
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeUnitIndex(String string) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        String string2 = RepositoryTranslatorImpl.getUnitIndexName(string);
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(string2, false);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            RepositoryTranslatorImpl.writeUnitFilesCache(string, (DataOutput)((Object)filterOutputStream));
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                throwable.printStackTrace();
            }
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            StorageAllocator.getInstance().deleteUnitFiles(string, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMasterIndex() {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            fileInputStream = new FileInputStream(MASTER_INDEX_FILE_NAME);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            RepositoryTranslatorImpl.readMasterIndex((DataInput)((Object)filterInputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeMasterIndex() {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(MASTER_INDEX_FILE_NAME, false);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            RepositoryTranslatorImpl.writeUnitsCache((DataOutput)((Object)filterOutputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                fileNotFoundException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                throwable.printStackTrace();
            }
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(int n) {
        version = n;
        if (!loaded) {
            UnitsCache unitsCache = unitNamesCache;
            synchronized (unitsCache) {
                if (!loaded) {
                    loaded = true;
                    RepositoryTranslatorImpl.loadMasterIndex();
                }
            }
        }
    }

    public static int getVersion() {
        return version;
    }

    private static void trace(String string, Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = System.currentTimeMillis();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i + 1] = objectArray[i];
        }
        System.err.printf("RepositoryTranslator [%d] " + string, objectArray2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnitsCache
    extends IntToStringCache {
        private static ArrayList<IntToStringCache> fileNamesCaches = new ArrayList();
        private static Map<String, Long> unit2timestamp = new ConcurrentHashMap<String, Long>();
        private static Map<String, Collection<RequiredUnit>> unit2requnint = new ConcurrentHashMap<String, Collection<RequiredUnit>>();

        static void updateReqUnitInfo(String string, Set<String> set) {
            for (int i = 0; i < unitNamesCache.cache.size(); ++i) {
                String string2 = (String)unitNamesCache.cache.get(i);
                long l = fileNamesCaches.get(i).getTimestamp();
                unit2timestamp.put(string2, l);
            }
            CopyOnWriteArraySet<RequiredUnit> copyOnWriteArraySet = new CopyOnWriteArraySet<RequiredUnit>();
            if (set != null) {
                for (String string3 : set) {
                    long l = unit2timestamp.get(string3);
                    RequiredUnit requiredUnit = new RequiredUnit(string3, l);
                    copyOnWriteArraySet.add(requiredUnit);
                }
            }
            unit2requnint.put(string, copyOnWriteArraySet);
        }

        private static boolean validateReqUnits(String string, Set<String> set) {
            if (set.contains(string)) {
                return true;
            }
            set.add(string);
            boolean bl = true;
            Collection<RequiredUnit> collection = unit2requnint.get(string);
            for (RequiredUnit requiredUnit : collection) {
                Long l;
                if (!UnitsCache.isUnitIndexLoaded(requiredUnit.getName())) {
                    RepositoryTranslatorImpl.loadUnitIndex(requiredUnit.getName(), set);
                }
                if ((l = unit2timestamp.get(requiredUnit.getName())) != null) {
                    long l2 = l;
                    if (l2 == requiredUnit.getTimestamp()) continue;
                    if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                        RepositoryTranslatorImpl.trace("Req. unit validation FAILED for %s: ts(unit2timestamp)=%d, ts(unit2requnint)=%s \n", new Object[]{string, l2, requiredUnit.getTimestamp()});
                    }
                    bl = false;
                    break;
                }
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("Req. unit validation FAILED for %s: ts=NULL\n", new Object[]{string});
                }
                bl = false;
                break;
            }
            return bl;
        }

        private static void writeRequiredUnits(String string, DataOutput dataOutput) throws IOException {
            assert (string != null);
            assert (dataOutput != null);
            Collection<RequiredUnit> collection = unit2requnint.get(string);
            assert (collection != null);
            int n = collection.size();
            dataOutput.writeInt(n);
            for (RequiredUnit requiredUnit : collection) {
                requiredUnit.write(dataOutput);
                if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
                RepositoryTranslatorImpl.trace("\t\treq.unit %s ts=%d\n", new Object[]{requiredUnit.getName(), requiredUnit.getTimestamp()});
            }
        }

        private static Collection<RequiredUnit> readRequiredUnits(DataInput dataInput) throws IOException {
            assert (dataInput != null);
            CopyOnWriteArraySet<RequiredUnit> copyOnWriteArraySet = new CopyOnWriteArraySet<RequiredUnit>();
            int n = dataInput.readInt();
            for (int i = 0; i < n; ++i) {
                RequiredUnit requiredUnit = new RequiredUnit(dataInput);
                copyOnWriteArraySet.add(requiredUnit);
                if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
                RepositoryTranslatorImpl.trace("\t\tRead req. unit %s ts=%d\n", new Object[]{requiredUnit.getName(), requiredUnit.getTimestamp()});
            }
            return copyOnWriteArraySet;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            assert (this.cache != null);
            assert (dataOutput != null);
            dataOutput.writeInt(this.version);
            dataOutput.writeLong(this.timestamp);
            int n = this.cache.size();
            dataOutput.writeInt(n);
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                RepositoryTranslatorImpl.trace("Storing master index; size=%d\n", new Object[]{n});
            }
            for (int i = 0; i < n; ++i) {
                String string = (String)this.cache.get(i);
                dataOutput.writeUTF(string);
                dataOutput.writeLong(unit2timestamp.get(string));
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("\tUnit %s ts=%d\n", new Object[]{string, UnitsCache.unit2timestamp.get(string)});
                }
                UnitsCache.writeRequiredUnits(string, dataOutput);
            }
        }

        private static boolean isUnitIndexLoaded(String string) {
            if (!unitNamesCache.cache.contains(string)) {
                return false;
            }
            int n = unitNamesCache.cache.indexOf(string);
            return fileNamesCaches.get(n).size() != 0;
        }

        public UnitsCache() {
        }

        public UnitsCache(DataInput dataInput) throws IOException {
            assert (dataInput != null);
            assert (this.cache != null);
            this.cache.clear();
            fileNamesCaches.clear();
            dataInput.readInt();
            dataInput.readLong();
            int n = dataInput.readInt();
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                RepositoryTranslatorImpl.trace("Reading master index (%d) elements\n", new Object[]{n});
            }
            for (int i = 0; i < n; ++i) {
                String string = ((Object)FilePathCache.getString((CharSequence)dataInput.readUTF())).toString();
                this.cache.add(string);
                long l = dataInput.readLong();
                unit2timestamp.put(string, l);
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    RepositoryTranslatorImpl.trace("\tRead %s ts=%d\n", new Object[]{string, l});
                }
                unit2requnint.put(string, UnitsCache.readRequiredUnits(dataInput));
                fileNamesCaches.add(new IntToStringCache(l));
            }
        }

        public void insertUnitFileCache(String string, IntToStringCache intToStringCache) {
            int n = this.cache.indexOf(string);
            if (n == -1) {
                n = super.makeId(string);
            }
            fileNamesCaches.set(n, intToStringCache);
            unit2timestamp.put(string, intToStringCache.getTimestamp());
            unit2requnint.put(string, new CopyOnWriteArraySet());
        }

        public IntToStringCache removeFileNames(String string) {
            IntToStringCache intToStringCache = null;
            int n = this.cache.indexOf(string);
            if (n != -1) {
                intToStringCache = fileNamesCaches.get(n);
                long l = intToStringCache.getTimestamp();
                unit2timestamp.put(string, l);
                fileNamesCaches.set(n, new IntToStringCache(l));
            }
            return intToStringCache;
        }

        @Override
        protected int makeId(String string) {
            int n = this.cache.indexOf(null);
            IntToStringCache intToStringCache = new IntToStringCache();
            if (n == -1) {
                n = super.makeId(string);
                fileNamesCaches.add(intToStringCache);
            } else {
                this.cache.set(n, string);
                fileNamesCaches.set(n, intToStringCache);
            }
            assert (fileNamesCaches.size() == this.cache.size());
            unit2requnint.put(string, new CopyOnWriteArraySet());
            unit2timestamp.put(string, intToStringCache.getTimestamp());
            return n;
        }

        public IntToStringCache getFileNames(int n) {
            return fileNamesCaches.get(n);
        }

        private void cleanUnitData(String string) {
            IntToStringCache intToStringCache = new IntToStringCache();
            unit2requnint.put(string, new CopyOnWriteArraySet());
            unit2timestamp.put(string, intToStringCache.getTimestamp());
        }
    }

    private static class RequiredUnit {
        private String unitName;
        private long timestamp;

        public RequiredUnit(String string, long l) {
            this.unitName = string;
            this.timestamp = l;
        }

        public RequiredUnit(DataInput dataInput) throws IOException {
            this.unitName = dataInput.readUTF();
            this.timestamp = dataInput.readLong();
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeUTF(this.unitName);
            dataOutput.writeLong(this.timestamp);
        }

        public String getName() {
            return this.unitName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

