/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashMap<K> {
    public static final long NO_VALUE = Long.MIN_VALUE;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final Object NULL_KEY = new Object();
    private static final boolean useNewHash = false;
    private transient Set<Entry<K>> entrySet = null;
    volatile transient Set<K> keySet = null;

    public LongHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public LongHashMap(int n) {
        this(n, 0.75f);
    }

    public LongHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static <T> T maskNull(T t) {
        return (T)(t == null ? NULL_KEY : t);
    }

    static <T> T unmaskNull(T t) {
        return t == NULL_KEY ? null : (T)t;
    }

    private static int oldHash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static int newHash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int hash(int n) {
        return useNewHash ? LongHashMap.newHash(n) : LongHashMap.oldHash(n);
    }

    static int hash(Object object) {
        return LongHashMap.hash(object.hashCode());
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        int n = LongHashMap.hash(object.hashCode());
        Entry<K> entry = this.table[LongHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return Long.MIN_VALUE;
    }

    private long getForNullKey() {
        int n = LongHashMap.hash(NULL_KEY.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry = this.table[n2];
        while (entry != null) {
            if (entry.key == NULL_KEY) {
                return entry.value;
            }
            entry = entry.next;
        }
        return Long.MIN_VALUE;
    }

    public boolean containsKey(Object object) {
        Object object2 = LongHashMap.maskNull(object);
        int n = LongHashMap.hash(object2.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && LongHashMap.eq(object2, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Entry<K> getEntry(Object object) {
        Object object2 = LongHashMap.maskNull(object);
        int n = LongHashMap.hash(object2.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry = this.table[n2];
        while (!(entry == null || entry.hash == n && LongHashMap.eq(object2, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    public long put(K k, long l) {
        if (k == null) {
            return this.putForNullKey(l);
        }
        int n = LongHashMap.hash(k.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k.equals(k2))) {
                long l2 = entry.value;
                entry.value = l;
                entry.recordAccess(this);
                return l2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, l, n2);
        return Long.MIN_VALUE;
    }

    private long putForNullKey(long l) {
        int n = LongHashMap.hash(NULL_KEY.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry = this.table[n2];
        while (entry != null) {
            if (entry.key == NULL_KEY) {
                long l2 = entry.value;
                entry.value = l;
                entry.recordAccess(this);
                return l2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, NULL_KEY, l, n2);
        return Long.MIN_VALUE;
    }

    void resize(int n) {
        Entry<K>[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry<K>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<K> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = LongHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    public long remove(Object object) {
        Entry<K> entry = this.removeEntryForKey(object);
        return entry == null ? Long.MIN_VALUE : entry.value;
    }

    Entry<K> removeEntryForKey(Object object) {
        Entry<K> entry;
        Object object2 = LongHashMap.maskNull(object);
        int n = LongHashMap.hash(object2.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && LongHashMap.eq(object2, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry<K> removeMapping(Object object) {
        Entry<K> entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Entry entry2 = (Entry)object;
        Object k = LongHashMap.maskNull(entry2.getKey());
        int n = LongHashMap.hash(k.hashCode());
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<K> entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    public void clear() {
        ++this.modCount;
        Entry<K>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K> entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K> entry = entryArray[i];
            while (entry != null) {
                if (entry.value == Long.MIN_VALUE) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    void addEntry(int n, K k, long l, int n2) {
        Entry<K> entry = this.table[n2];
        this.table[n2] = new Entry<K>(n, k, l, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, K k, long l, int n2) {
        Entry<K> entry = this.table[n2];
        this.table[n2] = new Entry<K>(n, k, l, entry);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Entry<K>> newEntryIterator() {
        return new EntryIterator();
    }

    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    public Set<Entry<K>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return LongHashMap.this.newEntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Entry entry2 = LongHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return LongHashMap.this.removeMapping(object) != null;
        }

        public int size() {
            return LongHashMap.this.size;
        }

        public void clear() {
            LongHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return LongHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return LongHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return LongHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return LongHashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            LongHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Entry<K>> {
        private EntryIterator() {
        }

        @Override
        public Entry<K> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K> next;
        int expectedModCount;
        int index;
        Entry<K> current;

        HashIterator() {
            this.expectedModCount = LongHashMap.this.modCount;
            Entry<K>[] entryArray = LongHashMap.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (LongHashMap.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<K> nextEntry() {
            if (LongHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry<K>[] entryArray = LongHashMap.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (LongHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            LongHashMap.this.removeEntryForKey(k);
            this.expectedModCount = LongHashMap.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K> {
        final K key;
        long value;
        final int hash;
        Entry<K> next;

        Entry(int n, K k, long l, Entry<K> entry) {
            this.value = l;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        public K getKey() {
            return LongHashMap.unmaskNull(this.key);
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long l) {
            long l2 = this.value;
            this.value = l;
            return l2;
        }

        public boolean equals(Object object) {
            Object v;
            Long l;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((l = Long.valueOf(this.getValue())) == (v = entry.getValue()) || l != null && ((Object)l).equals(v));
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(LongHashMap<K> longHashMap) {
        }

        void recordRemoval(LongHashMap<K> longHashMap) {
        }
    }
}

