/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.SelectModeWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SelectModePanel
extends JPanel {
    private boolean first = true;
    private boolean lastApplicable;
    private SelectModeWizard wizard;
    private JRadioButton advancedMode;
    private ButtonGroup buttonGroup1;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel modeLabel;
    private JRadioButton simpleMode;

    public SelectModePanel(SelectModeWizard selectModeWizard) {
        this.wizard = selectModeWizard;
        this.initComponents();
        this.addListeners();
    }

    private void addListeners() {
        this.simpleMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectModePanel.this.updateInstruction();
            }
        });
        this.advancedMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectModePanel.this.updateInstruction();
            }
        });
        this.updateInstruction();
    }

    private void updateInstruction() {
        if (this.simpleMode.isSelected()) {
            this.instructionsTextArea.setText(this.getString("SelectModeSimpleInstructionText"));
        } else {
            this.instructionsTextArea.setText(this.getString("SelectModeAdvancedInstructionText"));
        }
        this.wizard.stateChanged(null);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.simpleMode = new JRadioButton();
        this.advancedMode = new JRadioButton();
        this.modeLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.simpleMode);
        Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("SimpleModeButtonText"));
        this.simpleMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.simpleMode, gridBagConstraints);
        this.buttonGroup1.add(this.advancedMode);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedMode, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("AdvancedModeButtonText"));
        this.advancedMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.advancedMode, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("SelectModeLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modeLabel, gridBagConstraints);
    }

    void read(DiscoveryDescriptor discoveryDescriptor) {
        this.lastApplicable = this.isApplicable(discoveryDescriptor);
        if (this.lastApplicable) {
            this.advancedMode.setEnabled(true);
            this.simpleMode.setEnabled(true);
            if (this.first) {
                this.simpleMode.setSelected(true);
            }
        } else {
            this.advancedMode.setEnabled(true);
            this.simpleMode.setEnabled(true);
            this.advancedMode.setSelected(true);
        }
        this.first = false;
        this.updateInstruction();
    }

    private boolean isApplicable(DiscoveryDescriptor discoveryDescriptor) {
        return new DiscoveryExtension().isApplicable(discoveryDescriptor);
    }

    void store(DiscoveryDescriptor discoveryDescriptor) {
        discoveryDescriptor.setSimpleMode(this.simpleMode.isSelected());
    }

    boolean valid(DiscoveryDescriptor discoveryDescriptor) {
        if (this.simpleMode.isSelected() && !this.lastApplicable) {
            String string = discoveryDescriptor.getBuildResult();
            if (string == null || string.length() == 0) {
                discoveryDescriptor.setMessage(this.getString("SimpleMode.Error.NoOutputResult"));
                return false;
            }
            File file = new File(string);
            if (!file.exists()) {
                discoveryDescriptor.setMessage(this.getString("SimpleMode.Error.OutputResultNotExist"));
                return false;
            }
            discoveryDescriptor.setMessage(this.getString("SimpleMode.Error.NoDebugOutputResult"));
            return false;
        }
        return true;
    }

    private String getString(String string) {
        return NbBundle.getBundle(SelectModePanel.class).getString(string);
    }
}

