/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.discovery.wizard.AdditionalLibrariesListPanel;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SimpleConfigurationPanel
extends JPanel {
    private SimpleConfigurationWizard wizard;
    private JButton additionalLibrariesButton;
    private JComboBox configurationComboBox;
    private JLabel configurationLabel;
    private JPanel discoveryPanel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel librariesLabel;
    private JTextField librariesTextField;

    public SimpleConfigurationPanel(SimpleConfigurationWizard simpleConfigurationWizard) {
        this.wizard = simpleConfigurationWizard;
        this.initComponents();
        this.configurationComboBox.addItem(new ConfigutationItem("project", this.getString("CONFIGURATION_LEVEL_project")));
        this.configurationComboBox.addItem(new ConfigutationItem("folder", this.getString("CONFIGURATION_LEVEL_folder")));
        this.configurationComboBox.addItem(new ConfigutationItem("file", this.getString("CONFIGURATION_LEVEL_file")));
        this.configurationComboBox.setSelectedIndex(2);
        this.addListeners();
    }

    private void addListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleConfigurationPanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleConfigurationPanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleConfigurationPanel.this.update(documentEvent);
            }
        };
        this.librariesTextField.getDocument().addDocumentListener(documentListener);
    }

    private void update(DocumentEvent documentEvent) {
        this.wizard.stateChanged(null);
    }

    private void initComponents() {
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.discoveryPanel = new JPanel();
        this.configurationComboBox = new JComboBox();
        this.configurationLabel = new JLabel();
        this.librariesLabel = new JLabel();
        this.librariesTextField = new JTextField();
        this.additionalLibrariesButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.discoveryPanel.setLayout(new GridBagLayout());
        this.configurationComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SimpleConfigurationPanel.this.configurationComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.configurationComboBox, gridBagConstraints);
        this.configurationLabel.setLabelFor(this.configurationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ConfigurationLevelLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.configurationLabel, gridBagConstraints);
        this.librariesLabel.setLabelFor(this.librariesTextField);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("AdditionalLibrariesLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.librariesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.librariesTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.additionalLibrariesButton, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("LIBRARY_BROWSE_BUTTON_TXT"));
        this.additionalLibrariesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleConfigurationPanel.this.additionalLibrariesButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.additionalLibrariesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.discoveryPanel, gridBagConstraints);
    }

    private void configurationComboBoxItemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof ConfigutationItem) {
            ConfigutationItem configutationItem = (ConfigutationItem)object;
            this.instructionsTextArea.setText(this.getString("SimpleInstructionText_" + configutationItem.getID()));
        }
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.librariesTextField.getText(), ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        AdditionalLibrariesListPanel additionalLibrariesListPanel = new AdditionalLibrariesListPanel(arrayList.toArray());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)AdditionalLibrariesListPanel.wrapPanel(additionalLibrariesListPanel), this.getString("ADDITIONAL_LIBRARIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = additionalLibrariesListPanel.getListData();
            String string = "";
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    string = string + ";";
                }
                string = string + vector.elementAt(i);
            }
            this.librariesTextField.setText(string);
        }
    }

    private String getString(String string) {
        return NbBundle.getBundle(SimpleConfigurationPanel.class).getString(string);
    }

    void read(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getProviderID();
        if ("dwarf-executable".equals(string)) {
            this.additionalLibrariesButton.setVisible(true);
            this.librariesLabel.setVisible(true);
            this.librariesTextField.setVisible(true);
        } else if ("make-log".equals(string)) {
            this.additionalLibrariesButton.setVisible(false);
            this.librariesLabel.setVisible(false);
            this.librariesTextField.setVisible(false);
        } else if ("dwarf-folder".equals(string)) {
            this.additionalLibrariesButton.setVisible(false);
            this.librariesLabel.setVisible(false);
            this.librariesTextField.setVisible(false);
        }
    }

    void store(DiscoveryDescriptor discoveryDescriptor) {
        ConfigutationItem configutationItem = (ConfigutationItem)this.configurationComboBox.getSelectedItem();
        discoveryDescriptor.setLevel(configutationItem.getID());
        discoveryDescriptor.setAditionalLibraries(this.librariesTextField.getText());
    }

    boolean valid() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.librariesTextField.getText());
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            File file = new File(string);
            if (file.exists() && file.isFile()) continue;
            return false;
        }
        return true;
    }

    private static class ConfigutationItem {
        private String ID;
        private String name;

        private ConfigutationItem(String string, String string2) {
            this.ID = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getID() {
            return this.ID;
        }
    }
}

