/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.FunctionRootNode;
import org.netbeans.modules.cnd.callgraph.impl.LoadingNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallChildren
extends Children.Keys<Call> {
    private Call call;
    private Function function;
    private CallGraphState model;
    private Node parent;
    private boolean isInited = false;
    private boolean isCalls;

    public CallChildren(Call call, CallGraphState callGraphState, boolean bl) {
        this.call = call;
        this.model = callGraphState;
        this.isCalls = bl;
    }

    public CallChildren(Function function, CallGraphState callGraphState, boolean bl) {
        this.function = function;
        this.model = callGraphState;
        this.isCalls = bl;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new Call[0]);
        }
    }

    void setParent(Node node) {
        this.parent = node;
    }

    private synchronized void resetKeys() {
        List<Call> list = this.isCalls ? (this.call != null ? this.model.getModel().getCallees(this.call.getCallee()) : this.model.getModel().getCallees(this.function)) : (this.call != null ? this.model.getModel().getCallers(this.call.getCaller()) : this.model.getModel().getCallers(this.function));
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            this.setKeys(list);
            return;
        }
        this.setKeys(new Call[0]);
    }

    protected Node[] createNodes(Call call) {
        if (call instanceof LoadingNode) {
            return new Node[]{(Node)call};
        }
        CallNode callNode = new CallNode(call, this.model, this.isCalls);
        return new Node[]{callNode};
    }

    boolean isRecusion() {
        Function function = this.isCalls ? (this.call != null ? this.call.getCallee() : this.function) : (this.call != null ? this.call.getCaller() : this.function);
        for (Node node = this.parent; node != null; node = node.getParentNode()) {
            if (node instanceof CallNode) {
                Function function2 = this.isCalls ? ((CallNode)node).getCall().getCaller() : ((CallNode)node).getCall().getCallee();
                if (!function.equals(function2)) continue;
                return true;
            }
            if (!(node instanceof FunctionRootNode)) continue;
            return function.equals(((FunctionRootNode)node).getFunction());
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        if (this.isRecusion()) {
            this.setKeys(new Call[0]);
        } else {
            this.setKeys(new Call[]{new LoadingNode()});
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CallChildren.this.resetKeys();
                }
            });
        }
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }
}

