/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphUI;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphPanel;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CallGraphTopComponent
extends TopComponent {
    private static CallGraphTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/callgraph/resources/call_graph.png";
    private static final String PREFERRED_ID = "CallGraphTopComponent";
    private JPopupMenu pop;
    private PopupListener listener;
    private CloseListener closeL;
    private JButton jButton1;

    private CallGraphTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CallGraphTopComponent.class, (String)"CTL_CallGraphTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CallGraphTopComponent.class, (String)"HINT_CallGraphTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.listener = new PopupListener();
        this.closeL = new CloseListener();
    }

    public void setModel(CallModel callModel, CallGraphUI callGraphUI) {
        CallGraphPanel callGraphPanel = callGraphUI != null ? new CallGraphPanel(callGraphUI.showGraph()) : new CallGraphPanel(false);
        callGraphPanel.setName(callModel.getName());
        callGraphPanel.setToolTipText(callGraphPanel.getName() + " - " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_CallGraphTopComponent"));
        this.addTabPanel(callGraphPanel);
        callGraphPanel.setModel(callModel);
        callGraphPanel.requestFocusInWindow();
    }

    void addPanel(JPanel jPanel) {
        this.setName(jPanel.getToolTipText());
        this.removeAll();
        this.add(jPanel, "Center");
        this.validate();
    }

    void addTabPanel(JPanel jPanel) {
        if (this.getComponentCount() == 0) {
            this.add(jPanel, "Center");
        } else {
            Component component = this.getComponent(0);
            if (component instanceof JTabbedPane) {
                ((JTabbedPane)component).addTab(jPanel.getName() + "  ", null, jPanel, jPanel.getToolTipText());
                ((JTabbedPane)component).setSelectedComponent(jPanel);
                component.validate();
            } else if (component instanceof JButton) {
                this.setName(jPanel.getToolTipText());
                this.remove(component);
                this.add(jPanel, "Center");
            } else {
                this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_CallGraphTopComponent"));
                this.remove(component);
                JTabbedPane jTabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
                jTabbedPane.addMouseListener((MouseListener)((Object)this.listener));
                jTabbedPane.addPropertyChangeListener(this.closeL);
                this.add(jTabbedPane, "Center");
                jTabbedPane.addTab(component.getName() + "  ", null, component, ((JPanel)component).getToolTipText());
                jTabbedPane.addTab(jPanel.getName() + "  ", null, jPanel, jPanel.getToolTipText());
                jTabbedPane.setSelectedComponent(jPanel);
                jTabbedPane.validate();
            }
        }
        this.validate();
        this.requestActive();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(CallGraphTopComponent.class, (String)"NO_VIEW_AVAILABLE"));
        this.jButton1.setEnabled(false);
        this.jButton1.setFocusable(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized CallGraphTopComponent getDefault() {
        if (instance == null) {
            instance = new CallGraphTopComponent();
        }
        return instance;
    }

    public static synchronized CallGraphTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(CallGraphTopComponent.class.getName()).warning("Cannot find CallGraphTopComponent component. It will not be located properly in the window system.");
            return CallGraphTopComponent.getDefault();
        }
        if (topComponent instanceof CallGraphTopComponent) {
            return (CallGraphTopComponent)topComponent;
        }
        Logger.getLogger(CallGraphTopComponent.class.getName()).warning("There seem to be multiple components with the 'CallGraphTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CallGraphTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            Component[] componentArray = jTabbedPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removePanel((CallGraphPanel)componentArray[i]);
            }
        } else if (component instanceof CallGraphPanel) {
            this.removePanel((CallGraphPanel)component);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void removePanel(JPanel jPanel) {
        Component component;
        Component component2 = component = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            if (jPanel == null) {
                jPanel = (JPanel)jTabbedPane.getSelectedComponent();
            }
            jTabbedPane.remove(jPanel);
            if (jTabbedPane.getComponentCount() == 1) {
                Component component3 = jTabbedPane.getComponent(0);
                jTabbedPane.removeMouseListener((MouseListener)((Object)this.listener));
                jTabbedPane.removePropertyChangeListener(this.closeL);
                this.remove(jTabbedPane);
                this.add(component3, "Center");
                this.setName(((JPanel)component3).getToolTipText());
            }
        } else if (component instanceof CallGraphPanel) {
            this.remove(component);
            this.add(this.jButton1, "Center");
            this.setName(NbBundle.getMessage(CallGraphTopComponent.class, (String)"CTL_CallGraphTopComponent"));
            this.close();
        } else {
            this.close();
        }
        this.validate();
    }

    private void closeAllButCurrent() {
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            Component component2 = jTabbedPane.getSelectedComponent();
            Component[] componentArray = jTabbedPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == component2) continue;
                this.removePanel((CallGraphPanel)componentArray[i]);
            }
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(CallGraphTopComponent.class, (String)"LBL_CloseAllButCurrent"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphTopComponent.this.closeAllButCurrent();
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(CallGraphTopComponent.class, (String)"LBL_CloseAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphTopComponent.this.close();
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(CallGraphTopComponent.class, (String)"LBL_CloseWindow"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphTopComponent.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            CallGraphTopComponent.this.pop.show((Component)((Object)CallGraphTopComponent.this), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("close".equals(propertyChangeEvent.getPropertyName())) {
                CallGraphTopComponent.this.removePanel((JPanel)propertyChangeEvent.getNewValue());
            }
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CallGraphTopComponent.getDefault();
        }
    }
}

