/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.visual.widget.Scene;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ExportAction
extends AbstractAction {
    private static final String EXTENSION = "png";
    private Scene scene;
    private JComponent parent;

    public ExportAction(Scene scene, JComponent jComponent) {
        this.scene = scene;
        this.parent = jComponent;
        this.putValue("Name", this.getString("Export"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    private void print() {
        BufferedImage bufferedImage = new BufferedImage(this.scene.getBounds().width, this.scene.getBounds().height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.scene.paint(graphics2D);
        graphics2D.dispose();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getString("ExportGraph"));
        jFileChooser.setDialogType(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new MyFileFilter());
        if (jFileChooser.showSaveDialog(this.parent) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.getName().toLowerCase().endsWith(".png")) {
            file = new File(file.getParentFile(), file.getName() + "." + EXTENSION);
        }
        if (file.exists()) {
            String string = this.getString("FileExistsMessage");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)MessageFormat.format(string, file.getAbsolutePath()), this.getString("FileExists"), true, 0, DialogDescriptor.NO_OPTION, null);
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() != DialogDescriptor.YES_OPTION) {
                return;
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, EXTENSION, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getString(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    private static class MyFileFilter
    extends FileFilter {
        private MyFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".png");
        }

        public String getDescription() {
            return NbBundle.getMessage(ExportAction.class, (String)"PNG");
        }
    }
}

