/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.awt.Color;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class Utils {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.web.project");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.web.project");
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String JSP_PACKAGE_NAME = "org.apache.jsp";
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String SPECIFICATION_J2SE = "j2se";

    public static String createDefaultContext(String string) {
        return "/" + PropertyUtils.getUsablePropertyName((String)string);
    }

    public static void updateProperties(AntProjectHelper antProjectHelper, String string, EditableProperties editableProperties) {
        EditableProperties editableProperties2 = antProjectHelper.getProperties(string);
        editableProperties2.putAll((Map)editableProperties);
        antProjectHelper.putProperties(string, editableProperties2);
    }

    public static boolean isParentOrEqual(File file, File file2) {
        if (file != null || file2 != null) {
            file = FileUtil.normalizeFile((File)file);
            for (file2 = FileUtil.normalizeFile((File)file2); file2 != null; file2 = file2.getParentFile()) {
                if (!file2.equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static JavaPlatform findJ2seJavaPlatform(String string) {
        return Utils.findJavaPlatform(string, SPECIFICATION_J2SE);
    }

    public static JavaPlatform findJavaPlatform(String string) {
        return Utils.findJavaPlatform(string, null);
    }

    public static String getDefaultDebugClassPath() {
        return "${build.classes.dir}:${javac.classpath}";
    }

    public static String correctDebugClassPath(String string) {
        if (string == null || string.length() == 0) {
            return Utils.getDefaultDebugClassPath();
        }
        if (!string.contains("${build.ear.")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (String string2 : PropertyUtils.tokenizePath((String)string)) {
            if ("${build.ear.web.dir}".equals(string2) || "${build.ear.classes.dir}".equals(string2)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static JavaPlatform findJavaPlatform(String string, String string2) {
        if (string != null) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                JavaPlatform javaPlatform = javaPlatformArray[i];
                String string3 = (String)javaPlatform.getProperties().get(PLATFORM_ANT_NAME);
                if (string3 == null || !string3.equals(string) || string2 != null && !string2.equalsIgnoreCase(javaPlatform.getSpecification().getName())) continue;
                return javaPlatform;
            }
        }
        return null;
    }

    static String getGeneratedJavaResource(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n > 0 ? Utils.makeJavaPackage(string.substring(0, n)) : "";
        string2 = string2.length() == 0 ? JSP_PACKAGE_NAME : "org.apache.jsp." + string2;
        String string3 = Utils.makeJavaIdentifier(string.substring(n + 1));
        return string2.replace('.', '/') + "/" + string3 + ".java";
    }

    private static final String makeJavaPackage(String string) {
        String[] stringArray = Utils.split(string, "/");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(Utils.makeJavaIdentifier(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private static final String[] split(String string, String string2) {
        String[] stringArray;
        Vector<Object> vector = new Vector<Object>();
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n >= 0) {
            if (n > n2) {
                stringArray = string.substring(n2, n);
                vector.add(stringArray);
            }
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        if (n2 < string.length()) {
            vector.add(string.substring(n2));
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static final String makeJavaIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuffer.append('_');
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '_') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '.') {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(Utils.mangleChar(c));
        }
        if (Utils.isJavaKeyword(stringBuffer.toString())) {
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    private static final String mangleChar(char c) {
        char[] cArray = new char[]{'_', Character.forDigit(c >> 12 & 0xF, 16), Character.forDigit(c >> 8 & 0xF, 16), Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
        return new String(cArray);
    }

    private static boolean isJavaKeyword(String string) {
        return Arrays.binarySearch(JAVA_KEYWORDS, string) >= 0;
    }

    public static Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        return color == null ? new Color(89, 79, 191) : color;
    }

    public static String toClasspathString(File[] fileArray) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static void logUI(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        Parameters.notNull((CharSequence)"bundle", (Object)resourceBundle);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(resourceBundle);
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class clazz, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }
}

