/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.websvc.api.webservices.StubDescriptor;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebProjectWebServicesSupport
implements WebServicesSupportImpl {
    private WebProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private ClassPath projectSourcesClassPath;
    private static final String[] WSCOMPILE_SEI_SERVICE_FEATURES = new String[]{"documentliteral", "rpcliteral", "noencodedtypes", "nomultirefs", "serializeinterfaces", "strict", "useonewayoperations", "donotoverride"};
    private static final List allSeiServiceFeatures = Arrays.asList(WSCOMPILE_SEI_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_KEY_SEI_SERVICE_FEATURES = new String[]{"documentliteral", "rpcliteral", "strict", "useonewayoperations", "donotoverride"};
    private static final List importantSeiServiceFeatures = Arrays.asList(WSCOMPILE_KEY_SEI_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_WSDL_SERVICE_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
    private static final List allWsdlServiceFeatures = Arrays.asList(WSCOMPILE_WSDL_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_KEY_WSDL_SERVICE_FEATURES = new String[]{"wsi", "strict", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "novalidation", "searchschema", "explicitcontext"};
    private static final List importantWsdlServiceFeatures = Arrays.asList(WSCOMPILE_KEY_WSDL_SERVICE_FEATURES);
    private static final JAXRPCStubDescriptor seiServiceStub = new JAXRPCStubDescriptor("sei_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_SEIServiceStub"), new String[]{"documentliteral", "strict", "useonewayoperations"});
    private static final JAXRPCStubDescriptor wsdlServiceStub = new JAXRPCStubDescriptor("wsdl_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_WSDLServiceStub"), new String[]{"wsi", "strict"});

    public WebProjectWebServicesSupport(WebProject webProject, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        this.project = webProject;
        this.helper = antProjectHelper;
        this.referenceHelper = referenceHelper;
    }

    public void addServiceImpl(String string, FileObject fileObject, boolean bl) {
        this.addServiceImpl(string, fileObject, bl, null);
    }

    public void addServiceImpl(String string, FileObject fileObject, boolean bl, String[] stringArray) {
        Object object;
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        String string2 = this.getPackageName(fileObject);
        editableProperties.put(string + ".config.name", string2 + (string2.equals("") ? "" : "/") + fileObject.getNameExt());
        editableProperties.put(string + ".mapping", string + "-mapping.xml");
        String string3 = "wscompile.service." + string + ".features";
        this.getWebservicesDD();
        JAXRPCStubDescriptor jAXRPCStubDescriptor = null;
        jAXRPCStubDescriptor = bl ? (stringArray != null ? new JAXRPCStubDescriptor("wsdl_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_WSDLServiceStub"), stringArray) : wsdlServiceStub) : seiServiceStub;
        String string4 = jAXRPCStubDescriptor.getDefaultFeaturesAsArgument();
        editableProperties.put(string3, string4);
        this.helper.putProperties("nbproject/project.properties", editableProperties);
        Element element = this.helper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("web-services");
        Element element2 = null;
        if (nodeList.getLength() == 0) {
            element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-services");
            object = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-clients");
            if (object.getLength() <= 0) {
                object = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                assert (object.getLength() == 1) : "Invalid project.xml file.";
            }
            element.insertBefore(element2, object.item(0));
        } else {
            element2 = (Element)nodeList.item(0);
        }
        object = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service");
        element2.appendChild((Node)object);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
        object.appendChild(element3);
        element3.appendChild(document.createTextNode(string));
        if (bl) {
            Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl");
            object.appendChild(element4);
        }
        this.helper.putPrimaryConfigurationData(element, true);
        this.updateWsCompileProperties(string);
        try {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private WebApp getWebApp() {
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject != null) {
                return DDProvider.getDefault().getDDRoot(fileObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
        }
        return null;
    }

    public void addServiceEntriesToDD(String string, String string2, String string3) {
        String string4 = "WSServlet_" + string;
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            Servlet servlet = null;
            try {
                servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{string4, string3}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                ServletMapping servletMapping = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{string4, "/" + string}, "ServletName");
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                throw new RuntimeException(classNotFoundException.getMessage());
            }
            catch (NameAlreadyUsedException nameAlreadyUsedException) {
                nameAlreadyUsedException.printStackTrace();
                throw new RuntimeException(nameAlreadyUsedException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException.getMessage());
            }
        }
    }

    public FileObject getWebservicesDD() {
        FileObject fileObject = this.getWebInf();
        if (fileObject == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("webservices", "xml");
    }

    public FileObject getWsDDFolder() {
        return this.getWebInf();
    }

    public String getArchiveDDFolderName() {
        return "WEB-INF";
    }

    public String getImplementationBean(String string) {
        WebApp webApp = this.getWebApp();
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            if (!servletArray[i].getServletName().equals(string)) continue;
            return servletArray[i].getServletClass();
        }
        return null;
    }

    public boolean isFromWSDL(String string) {
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-services");
        Element element2 = null;
        Element element3 = null;
        if (nodeList.getLength() == 1) {
            element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                NodeList nodeList3;
                Node node;
                NodeList nodeList4;
                Element element4 = (Element)nodeList2.item(i);
                NodeList nodeList5 = element4.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
                if (nodeList5.getLength() != 1 || (nodeList4 = (element3 = (Element)nodeList5.item(0)).getChildNodes()).getLength() != 1 || (node = nodeList4.item(0)).getNodeType() != 3 || !string.equals(node.getNodeValue()) || (nodeList3 = element4.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl")).getLength() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public void removeProjectEntries(String string) {
        Element element;
        String string2;
        boolean bl = false;
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        String string3 = string + ".config.name";
        String string4 = string + ".mapping";
        if (editableProperties.getProperty(string3) != null) {
            editableProperties.remove((Object)string3);
            bl = true;
        }
        if (editableProperties.getProperty(string4) != null) {
            editableProperties.remove((Object)string4);
            bl = true;
        }
        if (editableProperties.getProperty(string2 = "wscompile.service." + string + ".features") != null) {
            editableProperties.remove((Object)string2);
            bl = true;
        }
        if (bl) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
        }
        Element element2 = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-services");
        Element element3 = null;
        Element element4 = null;
        if (nodeList.getLength() == 1) {
            element3 = (Element)nodeList.item(0);
            NodeList nodeList2 = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node;
                NodeList nodeList3;
                element = (Element)nodeList2.item(i);
                NodeList nodeList4 = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
                if (nodeList4.getLength() != 1 || (nodeList3 = (element4 = (Element)nodeList4.item(0)).getChildNodes()).getLength() != 1 || (node = nodeList3.item(0)).getNodeType() != 3 || !string.equals(node.getNodeValue())) continue;
                element3.removeChild(element);
                NodeList nodeList5 = element3.getChildNodes();
                if (nodeList5.getLength() == 0) {
                    element2.removeChild(element3);
                }
                bl = true;
                break;
            }
        }
        if (bl) {
            this.helper.putPrimaryConfigurationData(element2, true);
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                String string5 = NbBundle.getMessage(this.getClass(), (String)"MSG_ErrorSavingOnWSRemove") + string + "'\r\n" + iOException.getMessage();
                element = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)element);
            }
        }
    }

    public void removeServiceEntry(String string) {
        ServletMapping servletMapping;
        WebApp webApp = this.getWebApp();
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            Servlet servlet = servletArray[i];
            if (!servlet.getServletName().equals(string)) continue;
            webApp.removeServlet(servlet);
            break;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            servletMapping = servletMappingArray[i];
            if (!servletMapping.getServletName().equals(string)) continue;
            webApp.removeServletMapping(servletMapping);
        }
        try {
            webApp.write(this.getDeploymentDescriptor());
        }
        catch (IOException iOException) {
            servletMapping = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_Unable_WRITE_WS_DD"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)servletMapping);
        }
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public String generateImplementationBean(String string, FileObject fileObject, Project project, String string2) throws IOException {
        return null;
    }

    public void addServiceImplLinkEntry(ServiceImplBean serviceImplBean, String string) {
        serviceImplBean.setServletLink("WSServlet_" + string);
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    public List getServices() {
        ArrayList<WsCompileEditorSupport.ServiceSettings> arrayList = new ArrayList<WsCompileEditorSupport.ServiceSettings>();
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("web-services");
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                WsCompileEditorSupport.ServiceSettings serviceSettings;
                Node node;
                Element element3 = (Element)nodeList2.item(i);
                NodeList nodeList3 = element3.getChildNodes();
                if (nodeList3.getLength() != 1 || (node = nodeList3.item(0)).getNodeType() != 3) continue;
                String string = node.getNodeValue();
                String string2 = editableProperties.getProperty("wscompile.service." + string + ".features");
                StubDescriptor stubDescriptor = this.getServiceStubDescriptor(element3.getParentNode());
                if (seiServiceStub == stubDescriptor) {
                    if (string2 == null) {
                        string2 = seiServiceStub.getDefaultFeaturesAsArgument();
                    }
                    serviceSettings = new WsCompileEditorSupport.ServiceSettings(string, stubDescriptor, string2, allSeiServiceFeatures, importantSeiServiceFeatures);
                } else {
                    if (string2 == null) {
                        string2 = wsdlServiceStub.getDefaultFeaturesAsArgument();
                    }
                    serviceSettings = new WsCompileEditorSupport.ServiceSettings(string, stubDescriptor, string2, allWsdlServiceFeatures, importantWsdlServiceFeatures);
                }
                arrayList.add(serviceSettings);
            }
        }
        return arrayList;
    }

    private StubDescriptor getServiceStubDescriptor(Node node) {
        JAXRPCStubDescriptor jAXRPCStubDescriptor = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl");
            jAXRPCStubDescriptor = nodeList.getLength() == 1 ? wsdlServiceStub : seiServiceStub;
        }
        return jAXRPCStubDescriptor;
    }

    private String getPackageName(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        String string = null;
        for (int i = 0; i < sourceGroupArray.length && string == null; ++i) {
            string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject2);
            if (string == null) continue;
            string = sourceGroupArray[i].getName() + "/" + string;
        }
        return string + "";
    }

    public void addInfrastructure(String string, FileObject fileObject) {
    }

    public FileObject getDeploymentDescriptor() {
        FileObject fileObject = this.getWebInf();
        if (fileObject == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("web.xml");
    }

    public FileObject getWebInf() {
        return this.getFileObject("webinf.dir");
    }

    public FileObject getDocumentBase() {
        return this.getFileObject("web.docbase.dir");
    }

    private FileObject getFileObject(String string) {
        String string2 = this.helper.getStandardPropertyEvaluator().getProperty(string);
        if (string2 != null) {
            return this.helper.resolveFileObject(string2);
        }
        return null;
    }

    private boolean updateWsCompileProperties(String string) {
        EditableProperties editableProperties;
        boolean bl = false;
        EditableProperties editableProperties2 = PropertyUtils.getGlobalProperties();
        if (editableProperties2.getProperty("wscompile.tools.classpath") == null) {
            editableProperties2.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)editableProperties2);
            }
            catch (IOException iOException) {
                editableProperties = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_ErrorSavingGlobalProperties", (Object)string, (Object)iOException.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)editableProperties);
            }
            bl = true;
        }
        boolean bl2 = false;
        editableProperties = this.helper.getProperties("nbproject/project.properties");
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl3 = false;
        String string2 = editableProperties.getProperty("wscompile.classpath");
        if (string2 != null) {
            String[] stringArray = PropertyUtils.tokenizePath((String)string2);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        for (int i = 0; i < WebServicesConstants.WSCOMPILE_JARS.length; ++i) {
            if (hashSet.contains(WebServicesConstants.WSCOMPILE_JARS[i])) continue;
            hashSet.add(WebServicesConstants.WSCOMPILE_JARS[i]);
            bl3 = true;
        }
        if (bl3) {
            StringBuffer stringBuffer = new StringBuffer(256);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(':');
            }
            editableProperties.put("wscompile.classpath", stringBuffer.toString());
            bl2 = true;
        }
        if (editableProperties.getProperty("wscompile.tools.classpath") == null) {
            editableProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            bl2 = true;
        }
        if (bl2) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
        }
        return bl || bl2;
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        FileObject fileObject = null;
        FileObject fileObject2 = this.getWebInf();
        if (fileObject2 != null) {
            fileObject = fileObject2.getFileObject("wsdl");
            if (fileObject == null && bl) {
                fileObject = fileObject2.createFolder("wsdl");
            }
        } else if (bl) {
            Logger.getLogger("global").log(Level.INFO, NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfNotFoundForWsdlFolder"));
        }
        return fileObject;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!projectArray[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getClassPath() {
        WebProjectWebServicesSupport webProjectWebServicesSupport = this;
        synchronized (webProjectWebServicesSupport) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPathProviderImpl.getProjectSourcesClassPath("classpath/source"), classPathProviderImpl.getJ2eePlatformClassPath()});
            }
            return this.projectSourcesClassPath;
        }
    }

    private static class JAXRPCStubDescriptor
    extends StubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCStubDescriptor(String string, String string2, String[] stringArray) {
            super(string, string2);
            this.defaultFeatures = stringArray;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer stringBuffer = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.defaultFeatures[i]);
            }
            return stringBuffer.toString();
        }
    }
}

