/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.j2ee.common.project.ui.J2eePlatformUiSupport;
import org.netbeans.modules.j2ee.common.project.ui.MessageUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final WebProjectProperties uiProperties;
    private final String oldServerInstanceId;
    private JLabel errorLabel;
    private JCheckBox jCheckBoxDeployOnSave;
    private JCheckBox jCheckBoxDisplayBrowser;
    private JComboBox jComboBoxServer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelContextPath;
    private JLabel jLabelContextPathDesc;
    private JLabel jLabelJ2EE;
    private JLabel jLabelRelativeURL;
    private JLabel jLabelServer;
    private JLabel jLabelURLExample;
    private JSeparator jSeparator1;
    private JTextField jTextFieldContextPath;
    private JTextField jTextFieldJ2EE;
    private JTextField jTextFieldJ2EE_Display;
    private JTextField jTextFieldRelativeURL;
    private JTextField vmOptions;

    public CustomizerRun(WebProjectProperties webProjectProperties) {
        this.initComponents();
        this.uiProperties = webProjectProperties;
        this.oldServerInstanceId = webProjectProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null ? J2eePlatformUiSupport.getServerInstanceID((Object)webProjectProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem()) : null;
        webProjectProperties.JAVAC_CLASSPATH_MODEL.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CustomizerRun.this.setMessages();
            }
        });
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_A11YDesc"));
        ProjectWebModule projectWebModule = (ProjectWebModule)webProjectProperties.getProject().getLookup().lookup(ProjectWebModule.class);
        this.jTextFieldContextPath.setEnabled(projectWebModule.getDeploymentDescriptor() != null);
        this.jTextFieldJ2EE.setDocument(webProjectProperties.J2EE_PLATFORM_MODEL);
        this.jTextFieldJ2EE.setVisible(false);
        this.jTextFieldContextPath.setDocument(webProjectProperties.CONTEXT_PATH_MODEL);
        this.jTextFieldRelativeURL.setDocument(webProjectProperties.LAUNCH_URL_RELATIVE_MODEL);
        this.vmOptions.setDocument(webProjectProperties.RUNMAIN_JVM_MODEL);
        webProjectProperties.DISPLAY_BROWSER_MODEL.setMnemonic(this.jCheckBoxDisplayBrowser.getMnemonic());
        this.jCheckBoxDisplayBrowser.setModel(webProjectProperties.DISPLAY_BROWSER_MODEL);
        this.jCheckBoxDeployOnSave.setModel(webProjectProperties.DEPLOY_ON_SAVE_MODEL);
        this.jComboBoxServer.setModel(webProjectProperties.J2EE_SERVER_INSTANCE_MODEL);
        String string = this.jTextFieldJ2EE.getText().trim();
        if (string.equalsIgnoreCase("1.3")) {
            this.jTextFieldJ2EE_Display.setText(NbBundle.getMessage(CustomizerRun.class, (String)"J2EESpecLevel_13"));
        } else if (string.equalsIgnoreCase("1.4")) {
            this.jTextFieldJ2EE_Display.setText(NbBundle.getMessage(CustomizerRun.class, (String)"J2EESpecLevel_14"));
        } else if (string.equalsIgnoreCase("1.5")) {
            this.jTextFieldJ2EE_Display.setText(NbBundle.getMessage(CustomizerRun.class, (String)"JavaEESpecLevel_50"));
        }
        this.setDeployOnSaveState();
    }

    private void initComponents() {
        this.jLabelServer = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.jLabelJ2EE = new JLabel();
        this.jTextFieldJ2EE = new JTextField();
        this.jTextFieldJ2EE_Display = new JTextField();
        this.jLabelContextPath = new JLabel();
        this.jTextFieldContextPath = new JTextField();
        this.jCheckBoxDisplayBrowser = new JCheckBox();
        this.jLabelContextPathDesc = new JLabel();
        this.jLabelRelativeURL = new JLabel();
        this.jTextFieldRelativeURL = new JTextField();
        this.jLabelURLExample = new JLabel();
        this.errorLabel = new JLabel();
        this.jCheckBoxDeployOnSave = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.vmOptions = new JTextField();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelServer.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle").getString("LBL_CustomizeRun_Server_LabelMnemonic").charAt(0));
        this.jLabelServer.setLabelFor(this.jComboBoxServer);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServer, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Server_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelServer, gridBagConstraints);
        this.jComboBoxServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jComboBoxServerActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jComboBoxServer, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle");
        this.jComboBoxServer.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CustomizeRun_Server_A11YDesc"));
        this.jLabelJ2EE.setLabelFor(this.jTextFieldJ2EE);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJ2EE, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_J2EE_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelJ2EE, gridBagConstraints);
        this.jLabelJ2EE.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACSD_CustomizerRun_jLabelJ2EE"));
        this.jTextFieldJ2EE.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jTextFieldJ2EE, gridBagConstraints);
        this.jTextFieldJ2EE_Display.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jTextFieldJ2EE_Display, gridBagConstraints);
        this.jLabelContextPath.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle").getString("LBL_CustomizeRun_ContextPath_LabelMnemonic").charAt(0));
        this.jLabelContextPath.setLabelFor(this.jTextFieldContextPath);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ContextPath_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabelContextPath, gridBagConstraints);
        this.jTextFieldContextPath.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CustomizerRun.this.jTextFieldContextPathKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 11, 0);
        this.add((Component)this.jTextFieldContextPath, gridBagConstraints);
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CustomizeRun_ContextPath_A11YDesc"));
        this.jCheckBoxDisplayBrowser.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisplayBrowser, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DisplayBrowser_JCheckBox"));
        this.jCheckBoxDisplayBrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jCheckBoxDisplayBrowserActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jCheckBoxDisplayBrowser, gridBagConstraints);
        this.jCheckBoxDisplayBrowser.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CustomizeRun_DisplayBrowser_A11YDesc"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPathDesc, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ContextPathDesc_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jLabelContextPathDesc, gridBagConstraints);
        this.jLabelRelativeURL.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle").getString("LBL_CustomizeRun_RelativeURL_LabelMnemonic").charAt(0));
        this.jLabelRelativeURL.setLabelFor(this.jTextFieldRelativeURL);
        Mnemonics.setLocalizedText((JLabel)this.jLabelRelativeURL, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_RelativeURL_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jLabelRelativeURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 5, 0);
        this.add((Component)this.jTextFieldRelativeURL, gridBagConstraints);
        this.jTextFieldRelativeURL.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_CustomizeRun_RelativeURL_A11YDesc"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelURLExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_RelativeURLExample"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 11, 0);
        this.add((Component)this.jLabelURLExample, gridBagConstraints);
        this.jLabelURLExample.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_RelativeURLExample_A11YDesc"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.errorLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDeployOnSave, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DeployOnSave_JCheckBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jCheckBoxDeployOnSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jSeparator1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"ACSN_CustomizerRun_NA"));
        this.jSeparator1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACSN_CustomizerRun_NA"));
        this.jLabel1.setLabelFor(this.vmOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomizerRun.class, (String)"Label_JVM_Argument"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACSN_CustomizerRun_NA"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.vmOptions, gridBagConstraints);
        this.vmOptions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACSN_CustomizerRun_NA"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CustomizerRun.class, (String)"Label_VM_Hint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACSN_CustomizerRun_NA"));
    }

    private void jTextFieldContextPathKeyReleased(KeyEvent keyEvent) {
        this.setMessages();
    }

    private void jCheckBoxDisplayBrowserActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jCheckBoxDisplayBrowser.isSelected();
        this.jLabelContextPathDesc.setEnabled(bl);
        this.jLabelRelativeURL.setEnabled(bl);
        this.jTextFieldRelativeURL.setEditable(bl);
    }

    private void jComboBoxServerActionPerformed(ActionEvent actionEvent) {
        this.setDeployOnSaveState();
        this.setMessages();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void setDeployOnSaveState() {
        if (this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null) {
            String string = J2eePlatformUiSupport.getServerInstanceID((Object)this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem());
            J2eeModule j2eeModule = this.uiProperties.getProject().getWebModule().getJ2eeModule();
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string);
            try {
                this.jCheckBoxDeployOnSave.setEnabled(serverInstance.isDeployOnSaveSupported(j2eeModule));
            }
            catch (InstanceRemovedException instanceRemovedException) {
                this.jCheckBoxDeployOnSave.setEnabled(false);
            }
        } else {
            this.jCheckBoxDeployOnSave.setEnabled(false);
        }
    }

    private void setMessages() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        boolean bl = false;
        if (this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null && this.isServerLibraryMessageNeeded(J2eePlatformUiSupport.getServerInstanceID((Object)this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem()), this.uiProperties)) {
            stringBuilder.append(NbBundle.getMessage(CustomizerRun.class, (String)"MSG_CREATING_LIBRARY"));
            bl = true;
        }
        if ((string = this.contextPathValidation()) != null) {
            if (bl) {
                stringBuilder.append("<p>");
            }
            stringBuilder.append(string);
            bl = true;
        }
        if (bl) {
            stringBuilder.append("</html>");
            MessageUtils.setMessage((JLabel)this.errorLabel, (MessageUtils.MessageType)MessageUtils.MessageType.WARNING, (String)stringBuilder.toString());
        } else {
            MessageUtils.clear((JLabel)this.errorLabel);
        }
    }

    private String contextPathValidation() {
        String string = this.jTextFieldContextPath.getText();
        String string2 = null;
        if (string.length() > 0) {
            if (!string.startsWith("/")) {
                string2 = NbBundle.getMessage(CustomizerRun.class, (String)"MSG_INVALID_CP_DOES_NOT_START_WITH_SLASH");
            } else if (string.indexOf("//") >= 0) {
                string2 = NbBundle.getMessage(CustomizerRun.class, (String)"MSG_INVALID_CP_CONTAINS_DOUBLE_SLASH");
            } else if (string.endsWith("/")) {
                string2 = NbBundle.getMessage(CustomizerRun.class, (String)"MSG_INVALID_CP_ENDS_WITH_SLASH");
            }
        }
        return string2;
    }

    private boolean isServerLibraryMessageNeeded(String string, WebProjectProperties webProjectProperties) {
        UpdateHelper updateHelper = webProjectProperties.getProject().getUpdateHelper();
        try {
            if (SharabilityUtility.isLibrarySwitchIntended((String)string, (String)this.oldServerInstanceId, (List)ClassPathUiSupport.getList((DefaultListModel)webProjectProperties.JAVAC_CLASSPATH_MODEL.getDefaultListModel()), (UpdateHelper)updateHelper)) {
                AntProjectHelper antProjectHelper = updateHelper.getAntProjectHelper();
                Library[] libraryArray = SharabilityUtility.getLibraries((File)antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation()), (String)string);
                return libraryArray.length <= 0;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }
}

