/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.cssengine;

import org.openide.ErrorManager;

public class StringIntMap {
    protected Entry[] table;
    protected int count;

    public StringIntMap(int n) {
        this.table = new Entry[n];
    }

    public int get(String string) {
        int n = string.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == string) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public int put(String string, int n) {
        Entry entry;
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.key == string) {
                int n4 = entry2.value;
                entry2.value = n;
                return n4;
            }
            entry2 = entry2.next;
        }
        int n5 = this.table.length;
        if (this.count++ >= n5 * 3 >>> 2) {
            ErrorManager.getDefault().log("Had to rehash StringIntMap");
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, string, n, this.table[n3]);
        return -1;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = entry2.hash % this.table.length;
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
        }
    }

    protected static class Entry {
        public int hash;
        public String key;
        public int value;
        public Entry next;

        public Entry(int n, String string, int n2, Entry entry) {
            this.hash = n;
            this.key = string;
            this.value = n2;
            this.next = entry;
        }
    }
}

