/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.element.providers;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.gotodeclaration.element.providers.BaseProvider;
import org.netbeans.modules.cnd.gotodeclaration.element.providers.FunctionElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.providers.VariableElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementProvider;
import org.openide.util.NbBundle;

public class FuncVarElementProvider
extends BaseProvider
implements ElementProvider {
    protected BaseProvider.ProviderDelegate createDelegate() {
        return new FuncVarDelegate();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(FuncVarElementProvider.class, (String)"FUNCVAR_PROVIDER_DISPLAY_NAME");
    }

    public String name() {
        return "C/C++ Functions and Variables";
    }

    private static class FuncVarDelegate
    extends BaseProvider.ProviderDelegate {
        private FuncVarDelegate() {
        }

        public String name() {
            return "C/C++ Functions and Variables";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(FuncVarElementProvider.class, (String)"FUNCVAR_PROVIDER_DISPLAY_NAME");
        }

        protected void processProject(CsmProject csmProject, BaseProvider.ResultSet resultSet, CsmSelect.CsmFilter csmFilter) {
            if (TRACE) {
                System.err.printf("FuncVarElementProvider.processProject %s\n", csmProject.getName());
            }
            this.processNamespace(csmProject.getGlobalNamespace(), resultSet, csmFilter);
        }

        private void processNamespace(CsmNamespace csmNamespace, BaseProvider.ResultSet resultSet, CsmSelect.CsmFilter csmFilter) {
            if (TRACE) {
                System.err.printf("processNamespace %s\n", csmNamespace.getQualifiedName());
            }
            Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
            while (iterator.hasNext()) {
                if (this.isCancelled()) {
                    return;
                }
                this.processDeclaration((CsmDeclaration)iterator.next(), resultSet);
            }
            for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
                if (this.isCancelled()) {
                    return;
                }
                this.processNamespace(csmNamespace2, resultSet, csmFilter);
            }
        }

        private void processDeclaration(CsmDeclaration csmDeclaration, BaseProvider.ResultSet resultSet) {
            CsmFunctionDefinition csmFunctionDefinition = null;
            switch (csmDeclaration.getKind()) {
                case FUNCTION_DEFINITION: {
                    csmFunctionDefinition = (CsmFunctionDefinition)csmDeclaration;
                    resultSet.add(new FunctionElementDescriptor((CsmFunction)csmFunctionDefinition));
                    break;
                }
                case FUNCTION: {
                    CsmFunction csmFunction = (CsmFunction)csmDeclaration;
                    csmFunctionDefinition = csmFunction.getDefinition();
                    if (csmFunctionDefinition != null && !csmFunctionDefinition.equals(csmFunction)) break;
                    resultSet.add(new FunctionElementDescriptor((CsmFunction)csmDeclaration));
                    break;
                }
                case VARIABLE: {
                    resultSet.add(new VariableElementDescriptor((CsmVariable)csmDeclaration));
                    break;
                }
            }
        }
    }
}

