/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.element.providers;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.gotodeclaration.element.providers.BaseProvider;
import org.netbeans.modules.cnd.gotodeclaration.element.providers.MacroElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementProvider;
import org.openide.util.NbBundle;

public class MacroProvider
extends BaseProvider
implements ElementProvider {
    protected BaseProvider.ProviderDelegate createDelegate() {
        return new MacroDelegate();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MacroProvider.class, (String)"MACRO_PROVIDER_DISPLAY_NAME");
    }

    public String name() {
        return "C/C++ Macros";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MacroDelegate
    extends BaseProvider.ProviderDelegate {
        private MacroDelegate() {
        }

        public String name() {
            return "C/C++ Macros";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(MacroProvider.class, (String)"MACRO_PROVIDER_DISPLAY_NAME");
        }

        @Override
        protected void processProject(CsmProject csmProject, BaseProvider.ResultSet resultSet, CsmSelect.CsmFilter csmFilter) {
            if (TRACE) {
                System.err.printf("MacroProvider.processProject %s\n", csmProject.getName());
            }
            this.processFiles(csmProject.getAllFiles(), resultSet, csmFilter);
        }

        private void processFiles(Collection<CsmFile> collection, BaseProvider.ResultSet resultSet, CsmSelect.CsmFilter csmFilter) {
            for (CsmFile csmFile : collection) {
                if (this.isCancelled()) {
                    return;
                }
                Iterator iterator = CsmSelect.getDefault().getMacros(csmFile, csmFilter);
                while (iterator.hasNext()) {
                    if (this.isCancelled()) {
                        return;
                    }
                    CsmMacro csmMacro = (CsmMacro)iterator.next();
                    resultSet.add(new MacroElementDescriptor(csmMacro));
                }
            }
        }
    }
}

