/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.visitor.PositionFinderVisitor;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMUtil {
    static Document fDoc;
    static Document sDoc;
    public static final String NS_PREFIX = "xmlns";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String XML_PROLOG = "<?xml version=\"1.0\"?>\n";

    public String prettyPrintXML(String string, String string2) throws UnsupportedEncodingException, IOException, BadLocationException {
        BaseDocument baseDocument = new BaseDocument(BaseKit.class, false);
        XDMModel xDMModel = this.createXDMModel((javax.swing.text.Document)baseDocument, string);
        Document document = xDMModel.getDocument();
        BaseDocument baseDocument2 = new BaseDocument(BaseKit.class, false);
        XDMModel xDMModel2 = this.createXDMModel((javax.swing.text.Document)baseDocument2);
        xDMModel2.setPretty(true);
        xDMModel2.setIndentation(string2);
        xDMModel2.sync();
        Node node = xDMModel2.getDocument();
        node = this.doPrettyPrint(xDMModel2, node, document);
        xDMModel2.flush();
        int n = -1;
        Node node2 = (Node)document.getChildNodes().item(0);
        if (node2 != null) {
            n = new PositionFinderVisitor().findPosition(xDMModel.getDocument(), node2);
        }
        int n2 = -1;
        Node node3 = (Node)node.getChildNodes().item(0);
        if (node3 != null) {
            n2 = new PositionFinderVisitor().findPosition(xDMModel2.getDocument(), node3);
        }
        return n == -1 ? string : baseDocument.getText(0, n) + baseDocument2.getText(n2, baseDocument2.getLength() - n2);
    }

    public List<Difference> compareXML(String string, String string2, ComparisonCriteria comparisonCriteria) throws Exception {
        return this.compareXML(string, string2, comparisonCriteria, true);
    }

    public List<Difference> compareXML(String string, String string2, ComparisonCriteria comparisonCriteria, boolean bl) throws BadLocationException, IOException {
        BaseDocument baseDocument = new BaseDocument(BaseKit.class, false);
        XDMModel xDMModel = this.createXDMModel((javax.swing.text.Document)baseDocument);
        baseDocument.remove(0, XML_PROLOG.length());
        baseDocument.insertString(0, string, null);
        xDMModel.sync();
        fDoc = xDMModel.getDocument();
        BaseDocument baseDocument2 = new BaseDocument(BaseKit.class, false);
        baseDocument2.getText(0, baseDocument2.getLength());
        XDMModel xDMModel2 = this.createXDMModel((javax.swing.text.Document)baseDocument2);
        baseDocument2.remove(0, XML_PROLOG.length());
        baseDocument2.insertString(0, string2, null);
        xDMModel2.setPretty(true);
        xDMModel2.sync();
        sDoc = xDMModel2.getDocument();
        XDUDiffFinder xDUDiffFinder = new XDUDiffFinder(this.createElementIdentity());
        List<Difference> list = xDUDiffFinder.findDiff(xDMModel.getDocument(), xDMModel2.getDocument());
        if (bl) {
            list = XDUDiffFinder.filterWhitespace(list);
        }
        if (comparisonCriteria == ComparisonCriteria.EQUAL) {
            ArrayList<Difference> arrayList = new ArrayList<Difference>();
            for (Difference difference : list) {
                if (difference instanceof Change) {
                    Change change = (Change)difference;
                    if (change.isPositionChanged() && !change.isTokenChanged() && !change.isAttributeChanged()) continue;
                    if (change.isAttributeChanged() && !change.isTokenChanged()) {
                        int n;
                        ArrayList<Change.AttributeChange> arrayList2 = new ArrayList<Change.AttributeChange>();
                        List<Change.AttributeDiff> list2 = change.getAttrChanges();
                        for (n = 0; n < list2.size(); ++n) {
                            Change.AttributeChange attributeChange;
                            if (!(list2.get(n) instanceof Change.AttributeChange) || !(attributeChange = (Change.AttributeChange)list2.get(n)).isPositionChanged() || attributeChange.isTokenChanged()) continue;
                            arrayList2.add(attributeChange);
                        }
                        for (n = 0; n < arrayList2.size(); ++n) {
                            change.removeAttrChanges((Change.AttributeDiff)arrayList2.get(n));
                        }
                        if (change.getAttrChanges().size() == 0) continue;
                    }
                    arrayList.add(difference);
                    continue;
                }
                arrayList.add(difference);
            }
            return arrayList;
        }
        XDMUtil.removePseudoAttrPosChanges(list);
        XDMUtil.filterSchemaLocationDiffs(list);
        return list;
    }

    private ElementIdentity createElementIdentity() {
        XDElementIdentity xDElementIdentity = new XDElementIdentity();
        xDElementIdentity.addIdentifier("id");
        xDElementIdentity.addIdentifier("name");
        xDElementIdentity.addIdentifier("ref");
        return xDElementIdentity;
    }

    private XDMModel createXDMModel(javax.swing.text.Document document) throws BadLocationException, IOException {
        return this.createXDMModel(document, "");
    }

    private XDMModel createXDMModel(javax.swing.text.Document document, String string) throws BadLocationException, IOException {
        boolean bl = true;
        if (string.indexOf("<?xml") == -1) {
            document.insertString(0, XML_PROLOG + string, null);
        } else {
            document.insertString(0, string, null);
        }
        Lookup lookup = Lookups.singleton((Object)document);
        ModelSource modelSource = new ModelSource(lookup, true);
        XDMModel xDMModel = new XDMModel(modelSource);
        xDMModel.sync();
        return xDMModel;
    }

    private Node doPrettyPrint(XDMModel xDMModel, Node node, Node node2) {
        Node node3 = null;
        NodeList nodeList = node2.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = (NodeImpl)nodeList.item(i);
            node3 = ((NodeImpl)node2).cloneNode(true, false);
            List<Node> list = xDMModel.add(node, node3, n++);
            node = list.get(0);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.fixPrettyText(xDMModel, node, arrayList, "");
        node = (Node)arrayList.get(0);
        return node;
    }

    private void fixPrettyText(XDMModel xDMModel, Node node, List<Node> list, String string) {
        int n;
        Node node2 = node;
        int n2 = xDMModel.getIndentation().length();
        NodeList nodeList = node2.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node3 = (Node)nodeList.item(n);
            if (XDMUtil.checkPrettyText(node3)) {
                Object object;
                Text text = (Text)((NodeImpl)node3).cloneNode(true);
                if (n < nodeList.getLength() - 1 || list.size() == 0) {
                    text.setText("\n" + string);
                } else {
                    object = "\n";
                    if (xDMModel.getIndentation().length() < string.length()) {
                        object = (String)object + string.substring(xDMModel.getIndentation().length());
                    }
                    text.setText((String)object);
                }
                object = xDMModel.modify(node3, text);
                node2 = (Node)object.get(0);
                continue;
            }
            if (!(nodeList.item(n) instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
            arrayList.add((Node)nodeList.item(n));
        }
        list.add(node2);
        for (n = 0; n < arrayList.size(); ++n) {
            this.fixPrettyText(xDMModel, (Node)arrayList.get(n), list, string + xDMModel.getIndentation());
        }
        arrayList.clear();
    }

    public static boolean checkPrettyText(Node node) {
        return node instanceof Text && ((NodeImpl)node).getTokens().size() == 1 && XDMUtil.isWhitespaceOnly(((NodeImpl)node).getTokens().get(0).getValue());
    }

    public static boolean isWhitespaceOnly(String string) {
        return XDUDiffFinder.isPossibleWhiteSpace(string) && string.trim().length() == 0;
    }

    public static int findPosition(Node node) {
        return new PositionFinderVisitor().findPosition((Node)((Object)node.getOwnerDocument()), node);
    }

    public static void removePseudoAttrPosChanges(List<Difference> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference : list) {
            Change change;
            if (!(difference instanceof Change) || !(change = (Change)difference).isAttributeChanged() || change.isPositionChanged() || change.isTokenChanged()) continue;
            List<Change.AttributeDiff> list2 = change.getAttrChanges();
            int n = list2.size();
            ArrayList<Change.AttributeDiff> arrayList2 = new ArrayList<Change.AttributeDiff>();
            int n2 = 0;
            int n3 = 0;
            for (Change.AttributeDiff attributeDiff : list2) {
                Change.AttributeChange attributeChange;
                if (attributeDiff instanceof Change.AttributeDelete) {
                    ++n2;
                    continue;
                }
                if (attributeDiff instanceof Change.AttributeAdd) {
                    ++n3;
                    continue;
                }
                if (!(attributeDiff instanceof Change.AttributeChange) || !(attributeChange = (Change.AttributeChange)attributeDiff).isPositionChanged() || attributeChange.isTokenChanged() || attributeChange.getOldAttributePosition() - n2 + n3 != attributeChange.getNewAttributePosition()) continue;
                arrayList2.add(attributeDiff);
            }
            for (Change.AttributeDiff attributeDiff : arrayList2) {
                change.removeAttrChanges(attributeDiff);
            }
            if (n <= 0 || change.getAttrChanges().size() != 0) continue;
            arrayList.add(difference);
        }
        for (Difference difference : arrayList) {
            list.remove(difference);
        }
    }

    public static void filterAttributeOrderChange(List<Difference> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference : list) {
            Change change;
            if (!(difference instanceof Change) || !(change = (Change)difference).isAttributeChanged() || change.isPositionChanged() || change.isTokenChanged()) continue;
            List<Change.AttributeDiff> list2 = change.getAttrChanges();
            int n = list2.size();
            ArrayList<Change.AttributeDiff> arrayList2 = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attributeDiff : list2) {
                Change.AttributeChange attributeChange;
                if (!(attributeDiff instanceof Change.AttributeChange) || !(attributeChange = (Change.AttributeChange)attributeDiff).isPositionChanged() || attributeChange.isTokenChanged()) continue;
                arrayList2.add(attributeDiff);
            }
            for (Change.AttributeDiff attributeDiff : arrayList2) {
                change.removeAttrChanges(attributeDiff);
            }
            if (n <= 0 || change.getAttrChanges().size() != 0) continue;
            arrayList.add(difference);
        }
        for (Difference difference : arrayList) {
            list.remove(difference);
        }
    }

    public static void filterSchemaLocationDiffs(List<Difference> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference : list) {
            Change change;
            if (!(difference instanceof Change) || !(change = (Change)difference).isAttributeChanged() || change.isPositionChanged() || change.isTokenChanged() || !XDMUtil.removeSchemaLocationAttrDiffs(change)) continue;
            arrayList.add(difference);
        }
        for (Difference difference : arrayList) {
            list.remove(difference);
        }
    }

    public static boolean removeSchemaLocationAttrDiffs(Change change) {
        List<Change.AttributeDiff> list = change.getAttrChanges();
        int n = list.size();
        ArrayList<Change.AttributeDiff> arrayList = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attributeDiff : list) {
            Attribute attribute = attributeDiff.getOldAttribute();
            Attribute attribute2 = attributeDiff.getNewAttribute();
            if (attribute != null && attribute.getName().endsWith(SCHEMA_LOCATION)) {
                arrayList.add(attributeDiff);
                continue;
            }
            if (attribute2 == null || !attribute2.getName().endsWith(SCHEMA_LOCATION)) continue;
            arrayList.add(attributeDiff);
        }
        for (Change.AttributeDiff attributeDiff : arrayList) {
            change.removeAttrChanges(attributeDiff);
        }
        return n > 0 && list.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XDUDiffFinder
    extends DiffFinder {
        public XDUDiffFinder(ElementIdentity elementIdentity) {
            super(elementIdentity);
        }

        @Override
        public List<Change.Type> checkChange(Node node, Node node2) {
            ArrayList<Change.Type> arrayList = new ArrayList<Change.Type>();
            if (node instanceof org.netbeans.modules.xml.xdm.nodes.Element && node2 instanceof org.netbeans.modules.xml.xdm.nodes.Element && !this.checkAttributesEqual((org.netbeans.modules.xml.xdm.nodes.Element)node, (org.netbeans.modules.xml.xdm.nodes.Element)node2)) {
                arrayList.add(Change.Type.ATTRIBUTE);
            }
            return arrayList;
        }

        @Override
        protected boolean checkAttributesEqual(org.netbeans.modules.xml.xdm.nodes.Element element, org.netbeans.modules.xml.xdm.nodes.Element element2) {
            if (element == null || element2 == null) {
                return false;
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            NamedNodeMap namedNodeMap2 = element2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = (Node)namedNodeMap.item(i);
                if (node.getNodeName().startsWith(XDMUtil.NS_PREFIX)) continue;
                Node node2 = (Node)namedNodeMap2.getNamedItem(node.getNodeName());
                if (node2 == null) {
                    return false;
                }
                if (namedNodeMap2.item(i) != node2) {
                    return false;
                }
                if (node.getNodeValue().equals(node2.getNodeValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean compareTextByValue(Text text, Text text2) {
            return text.getNodeValue().equals(text2.getNodeValue());
        }
    }

    public class XDElementIdentity
    extends DefaultElementIdentity {
        protected boolean compareElement(Element element, Element element2, org.w3c.dom.Node node, org.w3c.dom.Document document, org.w3c.dom.Document document2) {
            String string = element.getLocalName();
            String string2 = element2.getLocalName();
            String string3 = ((Node)((Object)element)).getNamespaceURI((Document)document);
            String string4 = ((Node)((Object)element2)).getNamespaceURI((Document)document2);
            if (string.intern() != string2.intern()) {
                return false;
            }
            if (!((string3 == null || string3.equals("")) && (string4 == null || string4.equals("")) || string3 == null && string4 == null || string3 != null && string4 != null && string3.intern() == string4.intern())) {
                return false;
            }
            if (node == document) {
                return true;
            }
            return this.compareAttr(element, element2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonCriteria {
        EQUAL,
        IDENTICAL;

    }
}

