/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.xml.nbprefuse.NbFocusControl;
import org.netbeans.modules.xml.nbprefuse.util.GraphUtilities;
import org.openide.filesystems.FileObject;
import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ui.UILib;
import prefuse.visual.AggregateItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUsagesFocusControl
extends NbFocusControl {
    protected SelectionMode selectionMode = SelectionMode.SINGLE;
    protected PropertyChangeSupport pcSupport;

    public FindUsagesFocusControl() {
        this.initialize();
    }

    public FindUsagesFocusControl(String string) {
        super(string);
        this.initialize();
    }

    public FindUsagesFocusControl(int n) {
        super(n);
        this.initialize();
    }

    public FindUsagesFocusControl(String string, int n) {
        super(string, n);
        this.initialize();
    }

    public FindUsagesFocusControl(int n, String string) {
        super(n, string);
        this.initialize();
    }

    public FindUsagesFocusControl(String string, int n, String string2) {
        super(string, n, string2);
        this.initialize();
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        super.itemPressed(visualItem, mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.selectNode(visualItem, mouseEvent);
        }
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        super.itemReleased(visualItem, mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.selectNode(visualItem, mouseEvent);
        }
    }

    private void selectNode(VisualItem visualItem, MouseEvent mouseEvent) {
        Visualization visualization = visualItem.getVisualization();
        NodeItem nodeItem = null;
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        nodeItem = (NodeItem)NodeItem.class.cast(visualItem);
        this.selectNode(mouseEvent, nodeItem, visualization);
        this.runActivity(visualization);
    }

    @Override
    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.button) && mouseEvent.getClickCount() == this.ccount) {
            Visualization visualization = visualItem.getVisualization();
            if (this.ccount == 1) {
                this.selectNode(visualItem, mouseEvent);
            } else if (this.ccount == 2) {
                RefactoringElement refactoringElement;
                int n = -1;
                if (visualItem.canGetBoolean("is-file-group-aggregate") && visualItem.getBoolean("is-file-group-aggregate") && visualItem.canGetInt("id")) {
                    n = visualItem.getInt("id");
                }
                if (visualItem.canGetBoolean("is-file-node") && visualItem.getBoolean("is-file-node") || n > -1) {
                    NodeItem nodeItem = null;
                    nodeItem = visualItem instanceof AggregateItem ? this.findFileNode(n, visualItem) : (NodeItem)visualItem;
                    GraphUtilities.expandCollapseFileNode(nodeItem);
                } else if (visualItem.canGet("refactor-element", RefactoringElement.class) && (refactoringElement = (RefactoringElement)visualItem.get("refactor-element")) != null) {
                    refactoringElement.openInEditor();
                }
                if (visualItem instanceof NodeItem) {
                    this.selectNode(mouseEvent, (NodeItem)NodeItem.class.cast(visualItem), visualization);
                }
                this.runActivity(visualization);
            }
        }
    }

    private NodeItem findFileNode(int n, VisualItem visualItem) {
        NodeItem nodeItem = null;
        AggregateItem aggregateItem = (AggregateItem)AggregateItem.class.cast(visualItem);
        Iterator iterator = aggregateItem.items();
        while (iterator.hasNext()) {
            VisualItem visualItem2 = (VisualItem)iterator.next();
            int n2 = -1;
            if (!visualItem2.canGetInt("file-node-file-group") || (n2 = visualItem2.getInt("file-node-file-group")) != n || !visualItem2.canGetBoolean("is-expanded")) continue;
            nodeItem = (NodeItem)NodeItem.class.cast(visualItem2);
            break;
        }
        return nodeItem;
    }

    private void selectNode(MouseEvent mouseEvent, NodeItem nodeItem, Visualization visualization) {
        TupleSet tupleSet = visualization.getFocusGroup(Visualization.FOCUS_ITEMS);
        NodeItem nodeItem2 = null;
        List<NodeItem> list = this.getNodeItemList(tupleSet);
        if (!list.isEmpty()) {
            nodeItem2 = list.get(0);
        }
        Object object = this.getGraphNodeUserObject(nodeItem2);
        Object object2 = this.getGraphNodeUserObject(nodeItem);
        boolean bl = mouseEvent.isControlDown();
        if (!bl) {
            this.pcSupport.firePropertyChange("prop-graph-node-selection-changed", object, object2);
            this.curFocus = nodeItem;
            tupleSet.setTuple((Tuple)nodeItem);
        } else if (tupleSet.containsTuple((Tuple)nodeItem)) {
            this.pcSupport.firePropertyChange("prop-graph-node-selection-changed", object2, null);
            tupleSet.removeTuple((Tuple)nodeItem);
            if (nodeItem instanceof NodeItem && nodeItem.canSetBoolean("mouseover")) {
                nodeItem.setBoolean("mouseover", false);
            }
        } else if (this.selectionMode == SelectionMode.MULTIPLE) {
            tupleSet.addTuple((Tuple)nodeItem);
        } else {
            this.pcSupport.firePropertyChange("prop-graph-node-selection-changed", object, object2);
            this.curFocus = nodeItem;
            tupleSet.setTuple((Tuple)nodeItem);
        }
    }

    private void initialize() {
        this.pcSupport = new PropertyChangeSupport((Object)this);
    }

    public void addGraphNodeSelectionChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcSupport.addPropertyChangeListener("prop-graph-node-selection-changed", propertyChangeListener);
    }

    private List<NodeItem> getNodeItemList(TupleSet tupleSet) {
        ArrayList<NodeItem> arrayList = null;
        int n = tupleSet.getTupleCount();
        if (n <= 0) {
            return Collections.emptyList();
        }
        arrayList = new ArrayList<NodeItem>(n);
        Iterator iterator = tupleSet.tuples();
        while (iterator.hasNext()) {
            arrayList.add((NodeItem)iterator.next());
        }
        return arrayList;
    }

    private Object getGraphNodeUserObject(NodeItem nodeItem) {
        if (nodeItem == null) {
            return null;
        }
        FileObject fileObject = (FileObject)nodeItem.get("file-object");
        if (fileObject != null) {
            return fileObject;
        }
        return nodeItem.get("user-obj");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionMode {
        SINGLE,
        MULTIPLE;

    }
}

