/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.RegionException;

public class RegionManager {
    private ActiveRegion root = new ActiveRegion(null, new Coord(), false);
    private ActiveRegion parent = null;
    private ActiveRegion region = this.root;

    public void reset() {
        this.root = new ActiveRegion(null, new Coord(), false);
        this.parent = null;
        this.region = this.root;
    }

    public ActiveRegion root() {
        return this.root;
    }

    public ActiveRegion beginRegion(Coord coord) throws RegionException {
        if (this.region != null) {
            ActiveRegion activeRegion = new ActiveRegion(this.region, coord, true);
            this.region.addChild(activeRegion);
            this.parent = this.region;
            this.region = activeRegion;
        } else {
            this.region = new ActiveRegion(this.parent, coord, false);
            this.parent.addChild(this.region);
        }
        return this.region;
    }

    public void endRegion(Coord coord) throws RegionException {
        if (this.region == null) {
            throw new RegionException("endRegion(): ", "no current active region");
        }
        if (this.region == this.root) {
            throw new RegionException("endRegion(): ", "cannot end root region");
        }
        this.region.setEnd(coord);
        if (this.region.nested) {
            this.region = this.parent;
            this.parent = this.region.parent;
        } else {
            this.region = null;
        }
    }

    public void cancelRegion() throws RegionException {
        if (this.region == null) {
            throw new RegionException("cancelRegion(): ", "no current active region");
        }
        if (this.region == this.root) {
            throw new RegionException("cancelRegion(): ", "cannot cancel root region");
        }
        this.parent.removeChild(this.region);
        this.region = null;
    }

    public ActiveRegion findRegion(Coord coord) {
        return this.root.contains(coord);
    }

    void relocate(int n, int n2) {
        int n3 = n2 - n;
        this.root.relocate(n3);
    }

    void cull(int n) {
        this.root.cull(n);
    }
}

