/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.io.IOException;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataLoader;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class JsfJspDataLoader
extends UniFileLoader {
    static final long serialVersionUID = -5809935261731217882L;
    static final ThreadLocal<Boolean> jspTemplateCreation = new ThreadLocal();

    public JsfJspDataLoader() {
        super("org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addExtension("jsp");
        this.getExtensions().addExtension("jspf");
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        FileObject fileObject2 = super.findPrimaryFile(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        Object object = fileObject2.getAttribute("jsfjsp");
        if (object != null && object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return fileObject2;
            }
            return null;
        }
        boolean bl = Utils.isTemplateFileObject(fileObject2);
        if (!bl && !JsfProjectUtils.isJsfProjectFile((FileObject)fileObject2)) {
            return null;
        }
        DataObject dataObject = JsfJavaDataLoader.DataObjectPoolFind(fileObject);
        if (dataObject instanceof JsfJspDataObject) {
            return fileObject;
        }
        if (jspTemplateCreation.get() == Boolean.TRUE) {
            return fileObject2;
        }
        FileObject fileObject3 = Utils.findJavaForJsp(fileObject2);
        if (fileObject3 == null) {
            return null;
        }
        if (fileObject2 != Utils.findJspForJava(fileObject3)) {
            return null;
        }
        if (!bl) {
            this.setJsfFileAttribute(fileObject2);
        }
        return fileObject2;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new JsfJspDataObject(fileObject, this);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(JsfJspDataLoader.class, (String)"PROP_JsfJspDataLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-jsp/visual/Actions/";
    }

    private void setJsfFileAttribute(FileObject fileObject) {
        try {
            fileObject.setAttribute("jsfjsp", (Object)Boolean.TRUE);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }
}

