/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.visualweb.api.portlet.dd.PortletModeType;
import org.netbeans.modules.visualweb.project.jsf.api.JsfPortletSupport;
import org.netbeans.modules.visualweb.project.jsf.api.JsfPortletSupportException;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.openide.ErrorManager;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JsfJspDataNode
extends DataNode
implements PropertyChangeListener {
    private static final String SHEETNAME_TEXT_PROPERTIES = "textProperties";
    private static final String PROP_FILE_ENCODING = "encoding";
    private static final String HELP_ID = "org.netbeans.modules.web.core.syntax.JSPKit";
    private WeakReference<ChangeListener> projectPropListener;

    public JsfJspDataNode(DataObject dataObject, Children children) {
        super(dataObject, children);
        this.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"LBL_JsfJspNodeShortDesc"));
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ChangeListener changeListener = new ChangeListener(this);
        JsfProjectUtils.addProjectPropertyListener((Project)project, (PropertyChangeListener)changeListener);
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
        this.projectPropListener = new WeakReference<ChangeListener>(changeListener);
    }

    public void destroy() throws IOException {
        FileObject fileObject = this.getDataObject().getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ChangeListener changeListener = (ChangeListener)this.projectPropListener.get();
        if (changeListener != null) {
            JsfProjectUtils.removeProjectPropertyListener((Project)project, (PropertyChangeListener)changeListener);
        }
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("jsf.startPage")) {
            FileObject fileObject = this.getDataObject().getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (propertyChangeEvent.getSource() == project) {
                this.fireIconChange();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("name") && JsfProjectUtils.isStartPage((FileObject)this.getDataObject().getPrimaryFile())) {
            this.fireIconChange();
        }
    }

    public Image getIcon(int n) {
        Image image;
        block11: {
            image = null;
            FileObject fileObject = this.getDataObject().getPrimaryFile();
            if (null == fileObject) {
                return null;
            }
            JsfPortletSupport jsfPortletSupport = JsfJspDataNode.getPortletSupport(fileObject);
            if (null != jsfPortletSupport) {
                try {
                    if (jsfPortletSupport.isInitialPage(PortletModeType.VIEW, fileObject)) {
                        image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/initialviewpage.png");
                        this.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"LBL_InitialViewShortDesc"));
                        break block11;
                    }
                    if (jsfPortletSupport.isInitialPage(PortletModeType.EDIT, fileObject)) {
                        image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/initialeditpage.png");
                        this.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"LBL_InitialEditShortDesc"));
                        break block11;
                    }
                    if (jsfPortletSupport.isInitialPage(PortletModeType.HELP, fileObject)) {
                        image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/initialhelppage.png");
                        this.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"LBL_InitialHelpShortDesc"));
                        break block11;
                    }
                    image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspObject.png");
                }
                catch (JsfPortletSupportException jsfPortletSupportException) {
                    ErrorManager.getDefault().notify(1, (Throwable)jsfPortletSupportException);
                }
            } else if (fileObject.getExt().compareToIgnoreCase("jspf") == 0) {
                image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspfObject.png");
                this.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"LBL_JsfJspFragmentShortDesc"));
            } else {
                image = n == 1 || n == 3 ? Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspObject.png") : Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspObject32.gif");
                if (JsfProjectUtils.isStartPage((FileObject)this.getDataObject().getPrimaryFile())) {
                    Image image2 = Utilities.loadImage((String)"org/netbeans/modules/visualweb/project/jsfloader/resources/startpagebadge.png");
                    image = Utilities.mergeImages((Image)image, (Image)image2, (int)image.getWidth(null), (int)(image.getHeight(null) - image2.getHeight(null) + 1));
                }
            }
        }
        return image;
    }

    private static JsfPortletSupport getPortletSupport(FileObject fileObject) {
        if (fileObject.getExt().compareToIgnoreCase("jsp") == 0) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            return JsfProjectUtils.getPortletSupport((Project)project);
        }
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName(SHEETNAME_TEXT_PROPERTIES);
        set.setDisplayName(NbBundle.getMessage(JsfJspDataNode.class, (String)"PROP_textfileSetName"));
        set.setShortDescription(NbBundle.getMessage(JsfJspDataNode.class, (String)"HINT_textfileSetName"));
        sheet.put(set);
        set.put((Node.Property)new PropertySupport.ReadOnly<String>(PROP_FILE_ENCODING, String.class, NbBundle.getMessage(JsfJspDataNode.class, (String)"PROP_fileEncoding"), NbBundle.getMessage(JsfJspDataNode.class, (String)"HINT_fileEncoding")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return ((JsfJspDataObject)JsfJspDataNode.this.getDataObject()).getFileEncoding();
            }
        });
        Node.PropertySet[] propertySetArray = sheet.toArray();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.PropertySet propertySet = propertySetArray[i];
            propertySet.setValue("helpID", (Object)(JsfJspDataNode.class.getName() + ".PropertySheet"));
        }
        return sheet;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (string.equals(string2)) {
            return;
        }
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)this);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ((Dictionary)hashtable).put("name", string);
        instanceContent.add(hashtable);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        if (action.isEnabled()) {
            action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
        } else {
            super.setName(string);
        }
    }

    private static final class ChangeListener
    implements PropertyChangeListener {
        private WeakReference<JsfJspDataNode> ref;

        public ChangeListener(JsfJspDataNode jsfJspDataNode) {
            this.ref = new WeakReference<JsfJspDataNode>(jsfJspDataNode);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JsfJspDataNode jsfJspDataNode = (JsfJspDataNode)this.ref.get();
            if (jsfJspDataNode != null) {
                jsfJspDataNode.propertyChange(propertyChangeEvent);
            }
        }
    }
}

