/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOUtil {
    private static final Logger mLog = Logger.getLogger("com.sun.jbi.ui.devtool.tcg.util");
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void encode(InputStream input, String srcEncoding, OutputStream output, String targetEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, srcEncoding);
        OutputStreamWriter out = new OutputStreamWriter(output, targetEncoding);
        IOUtil.copy((Reader)in, (Writer)out);
    }

    public static byte[] encode(byte[] srcBuf, String srcEncoding, String targetEncoding) throws IOException {
        String s = new String(srcBuf, srcEncoding);
        byte[] ret = s.getBytes(targetEncoding);
        return ret;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = input.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        output.flush();
    }

    public static void copy(byte[] input, OutputStream output) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtil.copy((InputStream)in, output);
    }

    public static void copy(Reader input, Writer output) throws IOException {
        char[] buf = new char[4096];
        int n = 0;
        while ((n = input.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        output.flush();
    }

    public static void copy(byte[] input, Writer output) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        IOUtil.copy((InputStream)in, output);
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtil.copy((Reader)in, output);
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtil.copy(input, (Writer)out);
    }

    public static String getText(InputStream input, String srcEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, srcEncoding);
        StringWriter out = new StringWriter();
        IOUtil.copy((Reader)in, (Writer)out);
        String ret = out.toString();
        return ret;
    }

    public static String getText(String name, String srcEncoding) throws IOException {
        InputStream inputStream = null;
        String ret = null;
        try {
            inputStream = IOUtil.getResourceAsStream(name);
            ret = IOUtil.getText(inputStream, srcEncoding);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return ret;
    }

    public static String getText(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] getBytes(String name) throws IOException {
        return IOUtil.getBytes(IOUtil.getResourceAsStream(name));
    }

    public static byte[] getBytes(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream ret;
        block2: {
            ret = null;
            try {
                ret = new File(name).exists() ? new FileInputStream(name) : new URL(name).openStream();
            }
            catch (Exception e) {
                ret = IOUtil.class.getClassLoader().getResourceAsStream(name);
                if (ret != null) break block2;
                mLog.warning("resource " + name + " not found");
            }
        }
        return ret;
    }

    public static Enumeration getResources() {
        return null;
    }

    public static void unzip(String zipFilePath, String targetDirPath) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String path = targetDirPath != null ? targetDirPath + "/" + entry.getName() : entry.getName();
            if (entry.isDirectory()) {
                File dir = new File(path);
                if (dir.exists()) continue;
                dir.mkdirs();
                continue;
            }
            BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(entry));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            IOUtil.copy((InputStream)input, (OutputStream)output);
            ((InputStream)input).close();
            ((OutputStream)output).close();
        }
        zipFile.close();
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java IOUtil zipfile targetdirectory");
        } else {
            try {
                IOUtil.unzip(args[0], args[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

