/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.netbeans.modules.sql.project.anttasks.FileUtil;
import org.netbeans.modules.sql.project.anttasks.SQLMapEntry;
import org.netbeans.modules.sql.project.anttasks.SQLMapReader;

public class JBIFileWriter {
    private String mJbiDescriptorFile;
    private String sqlMapFile;
    private String mbuildDir;
    private Map prefixTable = new HashMap();
    private Map nsTable = new HashMap();
    private FileOutputStream fos = null;

    public JBIFileWriter(String mJbiDescriptorFile, String sqlMapFile, String mBuildDir) {
        this.mJbiDescriptorFile = mJbiDescriptorFile;
        this.sqlMapFile = sqlMapFile;
        this.mbuildDir = mBuildDir;
    }

    public JBIFileWriter(String mJbiDescriptorFile, String sqlMapFile) {
        this.mJbiDescriptorFile = mJbiDescriptorFile;
        this.sqlMapFile = sqlMapFile;
    }

    public void writeJBI() {
        List sqlEntryList = null;
        try {
            sqlEntryList = SQLMapReader.parse("sqlmap.xml", this.mbuildDir);
            this.populatePrefixAndNamespaceTable(sqlEntryList);
            this.generateJBI(sqlEntryList);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void populatePrefixAndNamespaceTable(List sqlEntryList) throws BuildException {
        try {
            int nsIndex = 1;
            int I = sqlEntryList.size();
            for (int i = 0; i < I; ++i) {
                SQLMapEntry entry = (SQLMapEntry)sqlEntryList.get(i);
                String ns = entry.getPartnerLink().getNamespaceURI();
                if (ns != null && !ns.trim().equals("") && !this.nsTable.containsKey(ns)) {
                    this.nsTable.put(ns, "ns" + nsIndex);
                    this.prefixTable.put("ns" + nsIndex, ns);
                    ++nsIndex;
                }
                if ((ns = entry.getPortType().getNamespaceURI()) != null && !ns.trim().equals("") && !this.nsTable.containsKey(ns)) {
                    this.nsTable.put(ns, "ns" + nsIndex);
                    this.prefixTable.put("ns" + nsIndex, ns);
                    ++nsIndex;
                }
                if (entry.getType() == "requestReplyService") continue;
                ns = entry.getPartnerLink().getNamespaceURI();
                if (ns != null && !ns.trim().equals("") && !this.nsTable.containsKey(ns)) {
                    this.nsTable.put(ns, "ns" + nsIndex);
                    this.prefixTable.put("ns" + nsIndex, ns);
                    ++nsIndex;
                }
                if ((ns = entry.getPortType().getNamespaceURI()) == null || ns.trim().equals("") || this.nsTable.containsKey(ns)) continue;
                this.nsTable.put(ns, "ns" + nsIndex);
                this.prefixTable.put("ns" + nsIndex, ns);
                ++nsIndex;
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    private void generateJBI(List sqlEntryList) throws Exception {
        try {
            SQLMapEntry xme;
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("<!--start of generated code -->\n");
            sb.append("<jbi version=\"1.0\"\n");
            sb.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            sb.append("        xmlns=\"http://java.sun.com/xml/ns/jbi\"\n");
            sb.append("        xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi jbi.xsd\"\n");
            int I = this.nsTable.size();
            for (i = 0; i < I; ++i) {
                String ns = "ns" + (i + 1);
                sb.append("        xmlns:" + ns + "=\"" + this.prefixTable.get(ns) + "\"");
                if (i >= I - 1) continue;
                sb.append("\n");
            }
            sb.append(">\n");
            sb.append("    <services binding-component=\"false\">\n");
            I = sqlEntryList.size();
            for (i = 0; i < I; ++i) {
                xme = (SQLMapEntry)sqlEntryList.get(i);
                sb.append("        <provides interface-name=\"" + JBIFileWriter.getDottedQName(xme.getPortType(), this.nsTable));
                sb.append("\" service-name=\"" + JBIFileWriter.getDottedQName(xme.getPartnerLink(), this.nsTable));
                sb.append("\" endpoint-name=\"" + xme.getRoleName());
                sb.append("\"/>\n");
            }
            I = sqlEntryList.size();
            for (i = 0; i < I; ++i) {
                xme = (SQLMapEntry)sqlEntryList.get(i);
                if (xme.getType().equals("requestReplyService")) continue;
                sb.append("        <consumes interface-name=\"" + JBIFileWriter.getDottedQName(xme.getPortType(), this.nsTable));
                sb.append("\" service-name=\"" + JBIFileWriter.getDottedQName(xme.getPartnerLink(), this.nsTable));
                sb.append("\" endpoint-name=\"" + xme.getRoleName());
                sb.append("\" link-type=\"standard\"/>\n");
            }
            sb.append("    </services>\n");
            sb.append(" </jbi>\n");
            sb.append("<!--end of generated code -->\n");
            String content = sb.toString();
            this.fos = new FileOutputStream(this.mJbiDescriptorFile);
            FileUtil.copy(content.getBytes("UTF-8"), (OutputStream)this.fos);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static String getDottedQName(QName qn, Map nsTable) {
        String ns = qn.getNamespaceURI();
        String prefix = (String)nsTable.get(ns);
        if (prefix == null) {
            return qn.getLocalPart();
        }
        return prefix + ":" + qn.getLocalPart();
    }

    public static void main(String[] args) {
        JBIFileWriter fw = new JBIFileWriter("test/jbi.xml", "test/sqlmap.xml", "");
        fw.writeJBI();
    }
}

