/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdaterFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleDeactivator {
    public static final String TO_UNINSTALL = "to_uninstall.txt";
    public static final String TO_DISABLE = "to_disable.txt";
    public static final String CONFIG = "config";
    public static final String MODULES = "Modules";
    private static String ENABLE_TAG = "<param name=\"enabled\">true</param>";
    private static String DISABLE_TAG = "<param name=\"enabled\">false</param>";

    private ModuleDeactivator() {
    }

    public static void delete() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        UpdaterFrame.setLabel(Localization.getBrandedString("CTL_DeletingFiles"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : UpdateTracking.clusters(true)) {
            boolean bl = hashSet.addAll(ModuleDeactivator.readFilesMarkedForDeleteInCluster(object));
            bl = hashSet.add(ModuleDeactivator.getControlFileForMarkedForDelete(object)) || bl;
            bl = hashSet.add(ModuleDeactivator.getDeactivateLater(object)) || bl;
            if (!bl) continue;
            UpdaterDispatcher.touchLastModified(object);
        }
        UpdaterFrame.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            ModuleDeactivator.doDelete(file);
            UpdaterFrame.setProgressValue(n++);
        }
    }

    public static void disable() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        UpdaterFrame.setLabel(Localization.getBrandedString("CTL_DisablingFiles"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : UpdateTracking.clusters(true)) {
            hashSet.addAll(ModuleDeactivator.readFilesMarkedForDisableInCluster(object));
            ModuleDeactivator.doDelete(ModuleDeactivator.getControlFileForMarkedForDisable(object));
            ModuleDeactivator.doDelete(ModuleDeactivator.getDeactivateLater(object));
        }
        UpdaterFrame.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            ModuleDeactivator.doDisable(file);
            UpdaterFrame.setProgressValue(n++);
        }
    }

    public static boolean hasModulesForDelete(File file) {
        File file2 = new File(file, "deactivate");
        return file2.exists() && file2.isDirectory() && Arrays.asList(file2.list()).contains(TO_UNINSTALL);
    }

    public static boolean hasModulesForDisable(File file) {
        File file2 = new File(file, "deactivate");
        return file2.exists() && file2.isDirectory() && Arrays.asList(file2.list()).contains(TO_DISABLE);
    }

    public static File getDeactivateLater(File file) {
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + "deactivate_later.txt");
        return file2;
    }

    public static File getControlFileForMarkedForDelete(File file) {
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + TO_UNINSTALL);
        return file2;
    }

    public static File getControlFileForMarkedForDisable(File file) {
        File file2 = new File(file, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + TO_DISABLE);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String string, File file) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string);
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: Writing " + file + " throws " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Error: Writing " + file + " throws " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(File file) {
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                stringBuffer = new StringBuffer();
                bufferedReader = new BufferedReader(new FileReader(file));
                char[] cArray = new char[1024];
                int n = 0;
                while ((n = bufferedReader.read(cArray)) != -1) {
                    String string = String.valueOf(cArray, 0, n);
                    stringBuffer.append(string);
                    cArray = new char[1024];
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: Reading " + file + " throws " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Error: Reading " + file + " throws " + iOException);
        }
        return stringBuffer == null ? "" : stringBuffer.toString();
    }

    private static void doDelete(File file) {
        assert (file != null) : "Invalid file " + file + " for delete.";
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
        for (file = file.getParentFile(); file != null && ModuleDeactivator.doDeleteEmptyDirectory(file); file = file.getParentFile()) {
        }
    }

    private static boolean doDeleteEmptyDirectory(File file) {
        assert (file != null) : file + " cannot be null";
        boolean bl = false;
        if (file.isDirectory()) {
            File file2;
            List<File> list = Arrays.asList(file.listFiles());
            if (list.size() == 1 && ".lastModified".endsWith((file2 = list.get(0)).getName()) && file2.delete()) {
                bl = file.delete();
            }
            bl = file.delete();
        } else {
            bl = file.delete();
        }
        return bl;
    }

    private static Set<File> readFilesMarkedForDeleteInCluster(File file) {
        File file2 = ModuleDeactivator.getControlFileForMarkedForDelete(file);
        if (!file2.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        String string = ModuleDeactivator.readStringFromFile(file2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, UpdateTracking.PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            File file3 = new File(string2);
            if (!file3.exists()) continue;
            hashSet.add(file3);
        }
        return hashSet;
    }

    private static Set<File> readFilesMarkedForDisableInCluster(File file) {
        File file2 = ModuleDeactivator.getControlFileForMarkedForDisable(file);
        if (!file2.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        String string = ModuleDeactivator.readStringFromFile(file2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, UpdateTracking.PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            File file3 = new File(string2);
            if (!file3.exists()) continue;
            hashSet.add(file3);
        }
        return hashSet;
    }

    private static void doDisable(File file) {
        String string = ModuleDeactivator.readStringFromFile(file);
        int n = string.indexOf(ENABLE_TAG);
        assert (n != -1) : ENABLE_TAG + " must be contained in " + string;
        int n2 = ENABLE_TAG.length();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + n2);
        String string4 = string2 + DISABLE_TAG + string3;
        File file2 = new File(new File(UpdateTracking.getUserDir(), CONFIG), MODULES);
        file2.mkdirs();
        File file3 = new File(file2, file.getName());
        ModuleDeactivator.writeStringToFile(string4, file3);
    }
}

