/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.openide.util.Cancellable;
import org.openide.util.Task;

public final class ActionsManager {
    public static final Object ACTION_STEP_OVER = "stepOver";
    public static final Object ACTION_RUN_INTO_METHOD = "runIntoMethod";
    public static final Object ACTION_STEP_INTO = "stepInto";
    public static final Object ACTION_STEP_OUT = "stepOut";
    public static final Object ACTION_STEP_OPERATION = "stepOperation";
    public static final Object ACTION_CONTINUE = "continue";
    public static final Object ACTION_START = "start";
    public static final Object ACTION_KILL = "kill";
    public static final Object ACTION_MAKE_CALLER_CURRENT = "makeCallerCurrent";
    public static final Object ACTION_MAKE_CALLEE_CURRENT = "makeCalleeCurrent";
    public static final Object ACTION_PAUSE = "pause";
    public static final Object ACTION_RUN_TO_CURSOR = "runToCursor";
    public static final Object ACTION_POP_TOPMOST_CALL = "popTopmostCall";
    public static final Object ACTION_FIX = "fix";
    public static final Object ACTION_RESTART = "restart";
    public static final Object ACTION_TOGGLE_BREAKPOINT = "toggleBreakpoint";
    private Vector listener = new Vector();
    private HashMap listeners = new HashMap();
    private HashMap actionProviders;
    private Object actionProvidersLock = new Object();
    private MyActionListener actionListener = new MyActionListener();
    private Lookup lookup;
    private boolean doiingDo = false;
    private boolean destroy = false;
    private boolean listerersLoaded = false;
    private List lazyListeners;

    ActionsManager(Lookup lookup) {
        this.lookup = lookup;
        if (lookup instanceof Lookup.MetaInf) {
            ((Lookup.MetaInf)lookup).addClearCacheListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = ActionsManager.this.actionProvidersLock;
                    synchronized (object) {
                        ActionsManager.this.actionProviders = null;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doAction(Object object) {
        ArrayList arrayList;
        this.doiingDo = true;
        Object object2 = this.actionProvidersLock;
        synchronized (object2) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((arrayList = (ArrayList)this.actionProviders.get(object)) != null) {
                arrayList = (ArrayList)arrayList.clone();
            }
        }
        boolean bl = false;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!((ActionsProvider)arrayList.get(i)).isEnabled(object)) continue;
                bl = true;
                ((ActionsProvider)arrayList.get(i)).doAction(object);
            }
        }
        if (bl) {
            this.fireActionDone(object);
        }
        this.doiingDo = false;
        if (this.destroy) {
            this.destroyIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task postAction(Object object) {
        ArrayList arrayList;
        this.doiingDo = true;
        Object object2 = this.actionProvidersLock;
        synchronized (object2) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((arrayList = (ArrayList)this.actionProviders.get(object)) != null) {
                arrayList = (ArrayList)arrayList.clone();
            }
        }
        boolean bl = false;
        int n = arrayList != null ? arrayList.size() : 0;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        AsynchActionTask asynchActionTask = new AsynchActionTask(arrayList2);
        if (arrayList != null) {
            Object object3;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                object3 = (ActionsProvider)arrayList.get(n2);
                if (!((ActionsProvider)object3).isEnabled(object)) continue;
                arrayList2.add(object3);
                bl = true;
            }
            if (bl) {
                object3 = new int[]{0};
                Runnable runnable = new Runnable((int[])object3, asynchActionTask, object){
                    final /* synthetic */ int[] val$count;
                    final /* synthetic */ AsynchActionTask val$task;
                    final /* synthetic */ Object val$action;
                    {
                        this.val$count = nArray;
                        this.val$task = asynchActionTask;
                        this.val$action = object;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray = this.val$count;
                        synchronized (this.val$count) {
                            this.val$count[0] = this.val$count[0] - 1;
                            if (this.val$count[0] == 0) {
                                this.val$task.actionDone();
                                ActionsManager.this.fireActionDone(this.val$action);
                                ActionsManager.this.doiingDo = false;
                                if (ActionsManager.this.destroy) {
                                    ActionsManager.this.destroyIn();
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                n = arrayList2.size();
                object3[0] = n;
                for (n2 = 0; n2 < n; ++n2) {
                    ((ActionsProvider)arrayList2.get(n2)).postAction(object, runnable);
                }
            }
        }
        if (!bl) {
            this.doiingDo = false;
            if (this.destroy) {
                this.destroyIn();
            }
            asynchActionTask.actionDone();
        }
        return asynchActionTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled(Object object) {
        ArrayList arrayList;
        Object object2 = this.actionProvidersLock;
        synchronized (object2) {
            if (this.actionProviders == null) {
                this.initActionImpls();
            }
            if ((arrayList = (ArrayList)this.actionProviders.get(object)) != null) {
                arrayList = (ArrayList)arrayList.clone();
            }
        }
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!((ActionsProvider)arrayList.get(i)).isEnabled(object)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        if (!this.doiingDo) {
            this.destroyIn();
        }
        this.destroy = true;
    }

    public void addActionsManagerListener(ActionsManagerListener actionsManagerListener) {
        this.listener.addElement(actionsManagerListener);
    }

    public void removeActionsManagerListener(ActionsManagerListener actionsManagerListener) {
        this.listener.removeElement(actionsManagerListener);
    }

    public void addActionsManagerListener(String string, ActionsManagerListener actionsManagerListener) {
        Vector<ActionsManagerListener> vector = (Vector<ActionsManagerListener>)this.listeners.get(string);
        if (vector == null) {
            vector = new Vector<ActionsManagerListener>();
            this.listeners.put(string, vector);
        }
        vector.addElement(actionsManagerListener);
    }

    public void removeActionsManagerListener(String string, ActionsManagerListener actionsManagerListener) {
        Vector vector = (Vector)this.listeners.get(string);
        if (vector == null) {
            return;
        }
        vector.removeElement(actionsManagerListener);
        if (vector.size() == 0) {
            this.listeners.remove(string);
        }
    }

    private void fireActionDone(Object object) {
        int n;
        this.initListeners();
        Vector vector = (Vector)this.listener.clone();
        Vector vector2 = (Vector)this.listeners.get("actionPerformed");
        if (vector2 != null) {
            vector2 = (Vector)vector2.clone();
        }
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            ((ActionsManagerListener)vector.elementAt(n)).actionPerformed(object);
        }
        if (vector2 != null) {
            n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                ((ActionsManagerListener)vector2.elementAt(n)).actionPerformed(object);
            }
        }
    }

    private void fireActionStateChanged(Object object) {
        int n;
        boolean bl = this.isEnabled(object);
        this.initListeners();
        Vector vector = (Vector)this.listener.clone();
        Vector vector2 = (Vector)this.listeners.get("actionStateChanged");
        if (vector2 != null) {
            vector2 = (Vector)vector2.clone();
        }
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            ((ActionsManagerListener)vector.elementAt(n)).actionStateChanged(object, bl);
        }
        if (vector2 != null) {
            n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                ((ActionsManagerListener)vector2.elementAt(n)).actionStateChanged(object, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProvider(Object object, ActionsProvider actionsProvider) {
        Object object2 = this.actionProvidersLock;
        synchronized (object2) {
            ArrayList<ActionsProvider> arrayList = (ArrayList<ActionsProvider>)this.actionProviders.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<ActionsProvider>();
                this.actionProviders.put(object, arrayList);
            }
            arrayList.add(actionsProvider);
        }
        this.fireActionStateChanged(object);
        actionsProvider.addActionsProviderListener(this.actionListener);
    }

    private void initActionImpls() {
        this.actionProviders = new HashMap();
        for (ActionsProvider actionsProvider : this.lookup.lookup(null, ActionsProvider.class)) {
            Iterator iterator = actionsProvider.getActions().iterator();
            while (iterator.hasNext()) {
                this.registerActionsProvider(iterator.next(), actionsProvider);
            }
        }
    }

    private void initListeners() {
        if (this.listerersLoaded) {
            return;
        }
        this.listerersLoaded = true;
        this.lazyListeners = this.lookup.lookup(null, LazyActionsManagerListener.class);
        int n = this.lazyListeners.size();
        for (int i = 0; i < n; ++i) {
            LazyActionsManagerListener lazyActionsManagerListener = (LazyActionsManagerListener)this.lazyListeners.get(i);
            String[] stringArray = lazyActionsManagerListener.getProperties();
            if (stringArray == null) {
                this.addActionsManagerListener(lazyActionsManagerListener);
                continue;
            }
            int n2 = stringArray.length;
            for (int j = 0; j < n2; ++j) {
                this.addActionsManagerListener(stringArray[j], lazyActionsManagerListener);
            }
        }
    }

    private synchronized void destroyIn() {
        if (this.lazyListeners == null) {
            return;
        }
        int n = this.lazyListeners.size();
        for (int i = 0; i < n; ++i) {
            LazyActionsManagerListener lazyActionsManagerListener = (LazyActionsManagerListener)this.lazyListeners.get(i);
            String[] stringArray = lazyActionsManagerListener.getProperties();
            if (stringArray == null) {
                this.removeActionsManagerListener(lazyActionsManagerListener);
                continue;
            }
            int n2 = stringArray.length;
            for (int j = 0; j < n2; ++j) {
                this.removeActionsManagerListener(stringArray[j], lazyActionsManagerListener);
            }
            lazyActionsManagerListener.destroy();
        }
        this.lazyListeners = new ArrayList();
    }

    class MyActionListener
    implements ActionsProviderListener {
        MyActionListener() {
        }

        public void actionStateChange(Object object, boolean bl) {
            ActionsManager.this.fireActionStateChanged(object);
        }
    }

    private static class AsynchActionTask
    extends Task
    implements Cancellable {
        private Collection postedActions;

        public AsynchActionTask(Collection collection) {
            this.postedActions = collection;
        }

        void actionDone() {
            this.notifyFinished();
        }

        public boolean cancel() {
            for (Object e : this.postedActions) {
                if (e instanceof Cancellable) {
                    if (((Cancellable)e).cancel()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }
}

