/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.FixData;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHolder
implements ChangeListener,
PropertyChangeListener,
DocumentListener {
    static final Map<Severity, AttributeSet> COLORINGS = new EnumMap<Severity, AttributeSet>(Severity.class);
    private Map<ErrorDescription, List<Position>> errors2Lines;
    private Map<Position, List<ErrorDescription>> line2Errors;
    private Map<Position, ParseErrorAnnotation> line2Annotations;
    private Map<String, List<ErrorDescription>> layer2Errors;
    private Set<JEditorPane> openedComponents;
    private EditorCookie.Observable editorCookie;
    private FileObject file;
    private DataObject od;
    private BaseDocument doc;
    private static Map<DataObject, AnnotationHolder> file2Holder;
    Attacher attacher = new NbDocumentAttacher();
    private List<Reference<Position>> knownPositions = new ArrayList<Reference<Position>>();
    private static RuntimeException ABORT;
    private static final RequestProcessor INSTANCE;

    public static synchronized AnnotationHolder getInstance(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            AnnotationHolder annotationHolder = file2Holder.get(dataObject);
            if (annotationHolder == null) {
                EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
                if (observable == null) {
                    Logger.getLogger("global").log(Level.WARNING, "No EditorCookie.Observable for file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                } else {
                    StyledDocument styledDocument = observable.getDocument();
                    if (styledDocument instanceof BaseDocument) {
                        annotationHolder = new AnnotationHolder(fileObject, dataObject, (BaseDocument)styledDocument, observable);
                        file2Holder.put(dataObject, annotationHolder);
                    }
                }
            }
            return annotationHolder;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            return null;
        }
    }

    private AnnotationHolder(FileObject fileObject, DataObject dataObject, BaseDocument baseDocument, EditorCookie.Observable observable) {
        if (fileObject == null) {
            return;
        }
        this.init();
        this.file = fileObject;
        this.od = dataObject;
        this.doc = baseDocument;
        AnnotationHolder.getBag((Document)baseDocument);
        this.doc.addDocumentListener((DocumentListener)this);
        observable.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)observable));
        this.editorCookie = observable;
        this.propertyChange(null);
        Logger.getLogger("TIMER").log(Level.FINE, "Annotation Holder", new Object[]{fileObject, this});
    }

    private synchronized void init() {
        this.errors2Lines = new HashMap<ErrorDescription, List<Position>>();
        this.line2Errors = new HashMap<Position, List<ErrorDescription>>();
        this.line2Annotations = new HashMap<Position, ParseErrorAnnotation>();
        this.layer2Errors = new HashMap<String, List<ErrorDescription>>();
        this.openedComponents = new HashSet<JEditorPane>();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateVisibleRanges();
    }

    void attachAnnotation(Position position, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
        this.attacher.attachAnnotation(position, parseErrorAnnotation);
    }

    void detachAnnotation(Annotation annotation) {
        this.attacher.detachAnnotation(annotation);
    }

    private synchronized void clearAll() {
        for (ParseErrorAnnotation parseErrorAnnotation : this.line2Annotations.values()) {
            this.detachAnnotation(parseErrorAnnotation);
        }
        file2Holder.remove(this.od);
        this.doc.removeDocumentListener((DocumentListener)this);
        AnnotationHolder.getBag((Document)this.doc).clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditorPane[] jEditorPaneArray = AnnotationHolder.this.editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null) {
                    AnnotationHolder.this.clearAll();
                    return;
                }
                HashSet<JEditorPane> hashSet = new HashSet<JEditorPane>(Arrays.asList(jEditorPaneArray));
                HashSet hashSet2 = new HashSet(AnnotationHolder.this.openedComponents);
                hashSet2.removeAll(hashSet);
                hashSet.removeAll(AnnotationHolder.this.openedComponents);
                for (JEditorPane jEditorPane : hashSet) {
                    Container container = jEditorPane.getParent();
                    if (!(container instanceof JViewport)) continue;
                    JViewport jViewport = (JViewport)container;
                    jViewport.addChangeListener(WeakListeners.change((ChangeListener)AnnotationHolder.this, (Object)jViewport));
                }
                AnnotationHolder.this.openedComponents.removeAll(hashSet2);
                AnnotationHolder.this.openedComponents.addAll(hashSet);
                AnnotationHolder.this.updateVisibleRanges();
            }
        });
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        try {
            int n = Utilities.getRowStart((BaseDocument)this.doc, (int)documentEvent.getOffset());
            HashSet<Position> hashSet = new HashSet<Position>();
            int n2 = this.findPositionGE(n);
            if (n2 == this.knownPositions.size()) {
                return;
            }
            Position position = this.knownPositions.get(n2).get();
            if (position == null) {
                return;
            }
            List<ErrorDescription> list = this.getErrorsForLine(position, false);
            if (list == null) {
                return;
            }
            list = new LinkedList<ErrorDescription>(list);
            for (ErrorDescription errorDescription : list) {
                for (Position position2 : this.errors2Lines.remove(errorDescription)) {
                    this.line2Errors.get(position2).remove(errorDescription);
                    hashSet.add(position2);
                }
                for (List list2 : this.layer2Errors.values()) {
                    list2.remove(errorDescription);
                }
            }
            this.line2Errors.remove(position);
            try {
                int n3 = documentEvent.getOffset();
                int n4 = Utilities.getRowEnd((BaseDocument)this.doc, (int)(documentEvent.getOffset() + documentEvent.getLength()));
                AnnotationHolder.getBag((Document)this.doc).removeHighlights(n3, n4, false);
            }
            catch (BadLocationException badLocationException) {
                throw (IOException)new IOException().initCause(badLocationException);
            }
            for (Position position2 : hashSet) {
                this.updateAnnotationOnLine(position2);
                this.updateHighlightsOnLine(position2);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        try {
            Object object;
            Object object2;
            Position position = null;
            int n = -1;
            int n2 = Utilities.getRowStart((BaseDocument)this.doc, (int)documentEvent.getOffset());
            while (position == null) {
                n = this.findPositionGE(n2);
                if (this.knownPositions.size() == 0) break;
                if (n == this.knownPositions.size()) {
                    return;
                }
                position = this.knownPositions.get(n).get();
            }
            if (position == null) {
                return;
            }
            assert (n != -1);
            while (n > 0) {
                object2 = this.knownPositions.get(n - 1).get();
                if (object2 == null) {
                    --n;
                    continue;
                }
                if (object2.getOffset() != position.getOffset()) break;
                --n;
            }
            object2 = new HashSet();
            while (n < this.knownPositions.size()) {
                object = this.knownPositions.get(n).get();
                if (object == null) {
                    ++n;
                    continue;
                }
                if (object.getOffset() != position.getOffset()) break;
                object2.add(object);
                ++n;
            }
            for (Position position2 : new LinkedList(object2)) {
                List<ErrorDescription> list = this.line2Errors.get(position2);
                if (list == null || list.isEmpty()) continue;
                list = new LinkedList<ErrorDescription>(list);
                for (ErrorDescription errorDescription : list) {
                    for (Position position3 : this.errors2Lines.remove(errorDescription)) {
                        this.line2Errors.get(position3).remove(errorDescription);
                        object2.add(position3);
                    }
                    for (List list2 : this.layer2Errors.values()) {
                        list2.remove(errorDescription);
                    }
                }
                this.line2Errors.remove(position2);
            }
            object = object2.iterator();
            while (object.hasNext()) {
                Position position2;
                position2 = (Position)object.next();
                this.updateAnnotationOnLine(position2);
                this.updateHighlightsOnLine(position2);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void updateVisibleRanges() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                long l = System.currentTimeMillis();
                final ArrayList arrayList = new ArrayList();
                AnnotationHolder.this.doc.render(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AnnotationHolder annotationHolder = AnnotationHolder.this;
                        synchronized (annotationHolder) {
                            for (JEditorPane jEditorPane : AnnotationHolder.this.openedComponents) {
                                Container container = jEditorPane.getParent();
                                if (!(container instanceof JViewport)) continue;
                                JViewport jViewport = (JViewport)container;
                                Point point = jViewport.getViewPosition();
                                Dimension dimension = jViewport.getExtentSize();
                                Point point2 = new Point(point.x + dimension.width, point.y + dimension.height);
                                int n = jEditorPane.viewToModel(point);
                                int n2 = jEditorPane.viewToModel(point2);
                                arrayList.add(new int[]{n, n2});
                            }
                        }
                    }
                });
                INSTANCE.post(new Runnable(){

                    public void run() {
                        for (int[] nArray : arrayList) {
                            AnnotationHolder.this.updateAnnotations(nArray[0], nArray[1]);
                        }
                    }
                });
                long l2 = System.currentTimeMillis();
                Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "updateVisibleRanges: time={0}", l2 - l);
            }
        });
    }

    private void updateAnnotations(final int n, final int n2) {
        long l = System.currentTimeMillis();
        final ArrayList arrayList = new ArrayList();
        this.doc.render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        int n7;
                        if (AnnotationHolder.this.doc.getLength() == 0) {
                            return;
                        }
                        int n22 = n < AnnotationHolder.this.doc.getLength() ? n : AnnotationHolder.this.doc.getLength() - 1;
                        int n3 = n7 = n2 < AnnotationHolder.this.doc.getLength() ? n2 : AnnotationHolder.this.doc.getLength() - 1;
                        if (n22 < 0) {
                            n22 = 0;
                        }
                        if (n7 < 0) {
                            n7 = 0;
                        }
                        int n4 = Utilities.getRowStart((BaseDocument)AnnotationHolder.this.doc, (int)n22);
                        int n5 = Utilities.getRowEnd((BaseDocument)AnnotationHolder.this.doc, (int)n7) + 1;
                        int n6 = AnnotationHolder.this.findPositionGE(n4);
                        while (n6 < AnnotationHolder.this.knownPositions.size()) {
                            Position position;
                            Reference reference = (Reference)AnnotationHolder.this.knownPositions.get(n6++);
                            if (reference == null || (position = (Position)reference.get()) == null) continue;
                            if (position.getOffset() <= n5) {
                                List list = (List)AnnotationHolder.this.line2Errors.get(position);
                                if (list == null) continue;
                                arrayList.addAll(list);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
        Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "updateAnnotations: errorsToUpdate={0}", arrayList);
        for (ErrorDescription errorDescription : arrayList) {
            LazyFixList lazyFixList;
            if (errorDescription == null || !(lazyFixList = errorDescription.getFixes()).probablyContainsFixes() || lazyFixList.isComputed()) continue;
            lazyFixList.getFixes();
        }
        long l2 = System.currentTimeMillis();
        Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "updateAnnotations: time={0}", l2 - l);
    }

    private List<ErrorDescription> getErrorsForLayer(String string) {
        List<ErrorDescription> list = this.layer2Errors.get(string);
        if (list == null) {
            list = new ArrayList<ErrorDescription>();
            this.layer2Errors.put(string, list);
        }
        return list;
    }

    private List<ErrorDescription> getErrorsForLine(Position position, boolean bl) {
        List<ErrorDescription> list = this.line2Errors.get(position);
        if (list == null && bl) {
            list = new ArrayList<ErrorDescription>();
            this.line2Errors.put(position, list);
        }
        if (list != null && list.isEmpty() && !bl) {
            this.line2Errors.remove(position);
            list = null;
        }
        return list;
    }

    private static List<ErrorDescription> filter(List<ErrorDescription> list, boolean bl) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        for (ErrorDescription errorDescription : list) {
            if (errorDescription.getSeverity() == Severity.ERROR) {
                if (!bl) continue;
                arrayList.add(errorDescription);
                continue;
            }
            if (bl) continue;
            arrayList.add(errorDescription);
        }
        return arrayList;
    }

    private static void concatDescription(List<ErrorDescription> list, StringBuffer stringBuffer) {
        boolean bl = true;
        for (ErrorDescription errorDescription : list) {
            if (!bl) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(errorDescription.getDescription());
            bl = false;
        }
    }

    private LazyFixList computeFixes(List<ErrorDescription> list) {
        ArrayList<LazyFixList> arrayList = new ArrayList<LazyFixList>();
        for (ErrorDescription errorDescription : list) {
            arrayList.add(errorDescription.getFixes());
        }
        return ErrorDescriptionFactory.lazyListForDelegates(arrayList);
    }

    private void updateAnnotationOnLine(Position position) throws BadLocationException {
        Severity severity;
        List<ErrorDescription> list = this.getErrorsForLine(position, false);
        if (list == null) {
            Annotation annotation = this.line2Annotations.remove(position);
            this.detachAnnotation(annotation);
            return;
        }
        list = this.getErrorsForLine(position, true);
        List<ErrorDescription> list2 = AnnotationHolder.filter(list, true);
        List<ErrorDescription> list3 = AnnotationHolder.filter(list, false);
        boolean bl = !list2.isEmpty();
        StringBuffer stringBuffer = new StringBuffer();
        AnnotationHolder.concatDescription(list2, stringBuffer);
        if (!list2.isEmpty() && !list3.isEmpty()) {
            stringBuffer.append("\n\n");
        }
        AnnotationHolder.concatDescription(list3, stringBuffer);
        if (bl) {
            severity = Severity.ERROR;
        } else {
            severity = Severity.HINT;
            for (ErrorDescription object2 : list3) {
                if (severity.compareTo(object2.getSeverity()) <= 0) continue;
                severity = object2.getSeverity();
            }
        }
        FixData fixData = new FixData(this.computeFixes(list2), this.computeFixes(list3));
        ParseErrorAnnotation parseErrorAnnotation = new ParseErrorAnnotation(severity, fixData, stringBuffer.toString(), position, this);
        Annotation annotation = this.line2Annotations.put(position, parseErrorAnnotation);
        if (annotation != null) {
            this.detachAnnotation(annotation);
        }
        this.attachAnnotation(position, parseErrorAnnotation);
    }

    void updateHighlightsOnLine(Position position) throws IOException {
        List<ErrorDescription> list = this.getErrorsForLine(position, false);
        OffsetsBag offsetsBag = AnnotationHolder.getBag((Document)this.doc);
        AnnotationHolder.updateHighlightsOnLine(offsetsBag, this.doc, position, list);
    }

    static void updateHighlightsOnLine(OffsetsBag offsetsBag, BaseDocument baseDocument, Position position, List<ErrorDescription> list) throws IOException {
        try {
            int n = position.getOffset();
            int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            int n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) + 1;
            offsetsBag.removeHighlights(n, n2, false);
            if (list != null) {
                offsetsBag.addAllHighlights(AnnotationHolder.computeHighlights((Document)baseDocument, list).getHighlights(n3, n4));
            }
        }
        catch (BadLocationException badLocationException) {
            throw (IOException)new IOException().initCause(badLocationException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static OffsetsBag computeHighlights(Document document, List<ErrorDescription> list) throws IOException, BadLocationException {
        OffsetsBag offsetsBag = new OffsetsBag(document);
        Iterator<Severity> iterator = Arrays.asList(Severity.VERIFIER, Severity.WARNING, Severity.ERROR).iterator();
        block6: while (iterator.hasNext()) {
            Severity severity = iterator.next();
            ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
            for (ErrorDescription errorDescription : list) {
                if (errorDescription.getSeverity() != severity) continue;
                arrayList.add(errorDescription);
            }
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator2 = arrayList.iterator();
            while (true) {
                void var11_24;
                void var11_21;
                if (!iterator2.hasNext()) break;
                ErrorDescription errorDescription = (ErrorDescription)iterator2.next();
                int n = errorDescription.getRange().getBegin().getPosition().getOffset();
                int n2 = errorDescription.getRange().getEnd().getPosition().getOffset();
                if (n2 < n) {
                    int n3 = n2;
                    n2 = n;
                    n = n3;
                    Logger.getLogger(AnnotationHolder.class.getName()).warning("Incorrect highlight in ErrorDescription, attach your messages.log to issue #112566: " + errorDescription.toString());
                }
                int[] nArray = new int[]{n, n2};
                Iterator iterator3 = arrayList2.iterator();
                block9: while (iterator3.hasNext() && var11_21 != null) {
                    int[] nArray2 = (int[])iterator3.next();
                    switch (AnnotationHolder.detectCollisions(nArray2, (int[])var11_21)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            iterator3.remove();
                            break;
                        }
                        case 2: {
                            Object var11_22 = null;
                            break block9;
                        }
                        case 3: 
                        case 4: {
                            int n4 = Math.min(nArray2[0], (int)var11_21[0]);
                            int n5 = Math.max(nArray2[1], (int)var11_21[1]);
                            int[] nArray3 = new int[]{n4, n5};
                            iterator3.remove();
                        }
                    }
                }
                if (var11_24 == null) continue;
                arrayList2.add(var11_24);
            }
            Iterator iterator4 = arrayList2.iterator();
            while (true) {
                if (!iterator4.hasNext()) continue block6;
                int[] nArray = (int[])iterator4.next();
                if (nArray[0] <= nArray[1]) {
                    offsetsBag.addHighlight(nArray[0], nArray[1], COLORINGS.get((Object)severity));
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (ErrorDescription errorDescription : arrayList) {
                    stringBuilder.append("[");
                    stringBuilder.append(errorDescription.getRange().getBegin().getOffset());
                    stringBuilder.append("-");
                    stringBuilder.append(errorDescription.getRange().getEnd().getOffset());
                    stringBuilder.append("]");
                }
                stringBuilder.append("=>");
                Iterator iterator5 = arrayList2.iterator();
                while (iterator5.hasNext()) {
                    int[] nArray4 = (int[])iterator5.next();
                    stringBuilder.append("[");
                    stringBuilder.append(nArray4[0]);
                    stringBuilder.append("-");
                    stringBuilder.append(nArray4[1]);
                    stringBuilder.append("]");
                }
                Logger.getLogger(AnnotationHolder.class.getName()).warning("Incorrect highlight computed, please reopen issue #112566 and attach the following output: " + stringBuilder.toString());
            }
            break;
        }
        return offsetsBag;
    }

    private static int detectCollisions(int[] nArray, int[] nArray2) {
        if (nArray2[1] < nArray[0]) {
            return 0;
        }
        if (nArray[1] < nArray2[0]) {
            return 0;
        }
        if (nArray2[0] < nArray[0] && nArray2[1] > nArray[1]) {
            return 1;
        }
        if (nArray[0] < nArray2[0] && nArray[1] > nArray2[1]) {
            return 2;
        }
        if (nArray[0] < nArray2[0]) {
            return 3;
        }
        return 4;
    }

    public void setErrorDescriptions(final String string, final Collection<? extends ErrorDescription> collection) {
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    AnnotationHolder.this.setErrorDescriptionsImpl(AnnotationHolder.this.file, string, collection);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
        });
    }

    private synchronized void setErrorDescriptionsImpl(FileObject fileObject, String string, Collection<? extends ErrorDescription> collection) throws IOException {
        long l;
        block17: {
            l = System.currentTimeMillis();
            if (fileObject != null) break block17;
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + string, new Object[]{fileObject, l2 - l});
            return;
        }
        try {
            List<ErrorDescription> list = this.getErrorsForLayer(string);
            HashSet<Position> hashSet = new HashSet<Position>();
            HashSet<Position> hashSet2 = new HashSet<Position>();
            for (ErrorDescription iterator : list) {
                List<Position> list2 = this.errors2Lines.remove(iterator);
                assert (list2 != null);
                boolean bl = true;
                for (Position position : list2) {
                    List<ErrorDescription> list3 = this.getErrorsForLine(position, false);
                    if (list3 != null) {
                        list3.remove(iterator);
                    }
                    if (bl) {
                        hashSet.add(position);
                    }
                    hashSet2.add(position);
                    bl = false;
                }
            }
            ArrayList arrayList = new ArrayList();
            for (ErrorDescription errorDescription : collection) {
                int n;
                if (errorDescription == null) {
                    Logger.getLogger(AnnotationHolder.class.getName()).log(Level.WARNING, "'null' ErrorDescription in layer {0}.", string);
                    continue;
                }
                if (errorDescription.getRange() == null) continue;
                arrayList.add(errorDescription);
                ArrayList<Position> arrayList2 = new ArrayList<Position>();
                int n2 = errorDescription.getRange().getBegin().getLine();
                int n3 = errorDescription.getRange().getEnd().getLine();
                for (n = n2; n <= n3; ++n) {
                    Position position = this.getPosition(n, true);
                    arrayList2.add(position);
                }
                this.errors2Lines.put(errorDescription, arrayList2);
                n = 1;
                for (Position position : arrayList2) {
                    this.getErrorsForLine(position, true).add(errorDescription);
                    if (n != 0) {
                        hashSet.add(position);
                    }
                    hashSet2.add(position);
                    n = 0;
                }
            }
            list.clear();
            list.addAll(arrayList);
            for (Position position : hashSet) {
                this.updateAnnotationOnLine(position);
            }
            for (Position position : hashSet2) {
                this.updateHighlightsOnLine(position);
            }
            this.updateVisibleRanges();
        }
        catch (BadLocationException badLocationException) {
            try {
                throw (IOException)new IOException().initCause(badLocationException);
            }
            catch (Throwable throwable) {
                long l2 = System.currentTimeMillis();
                Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + string, new Object[]{fileObject, l2 - l});
                throw throwable;
            }
        }
        long l4 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + string, new Object[]{fileObject, l4 - l});
    }

    private synchronized int findPositionGE(int n) {
        while (true) {
            try {
                int n2 = Collections.binarySearch(this.knownPositions, n, new PositionComparator());
                if (n2 >= 0) {
                    return n2;
                }
                return -(n2 + 1);
            }
            catch (Abort abort) {
                Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "a null Position detected - clearing");
                int n3 = 0;
                Iterator<Reference<Position>> iterator = this.knownPositions.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().get() != null) continue;
                    ++n3;
                    iterator.remove();
                }
                Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "clearing finished, {0} positions cleared", n3);
                continue;
            }
            break;
        }
    }

    private synchronized Position getPosition(int n, boolean bl) throws BadLocationException {
        while (true) {
            Object object;
            Object object2;
            int n2;
            int n3;
            block11: {
                n3 = Utilities.getRowStartFromLineOffset((BaseDocument)this.doc, (int)n);
                try {
                    n2 = Collections.binarySearch(this.knownPositions, n3, new PositionComparator());
                    if (n2 >= 0 && (object2 = ((Reference)(object = this.knownPositions.get(n2))).get()) != null) {
                        Object object3 = object2;
                        return object3;
                    }
                    if (bl) break block11;
                    object = null;
                    return object;
                }
                catch (Abort abort) {
                    Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "a null Position detected - clearing");
                    int n4 = 0;
                    object2 = this.knownPositions.iterator();
                    while (object2.hasNext()) {
                        if (object2.next().get() != null) continue;
                        ++n4;
                        object2.remove();
                    }
                    Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "clearing finished, {0} positions cleared", n4);
                    continue;
                }
            }
            object = NbDocument.createPosition((Document)this.doc, (int)n3, (Position.Bias)Position.Bias.Forward);
            this.knownPositions.add(-(n2 + 1), new WeakReference<Object>(object));
            Logger.getLogger("TIMER").log(Level.FINE, "Annotation Holder - Line Token", new Object[]{this.file, object});
            object2 = object;
            return object2;
            break;
        }
        finally {
            Logger.getLogger(AnnotationHolder.class.getName()).log(Level.FINE, "knownPositions.size={0}", this.knownPositions.size());
        }
    }

    public synchronized boolean hasErrors() {
        for (ErrorDescription errorDescription : this.errors2Lines.keySet()) {
            if (errorDescription.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public synchronized List<ErrorDescription> getErrors() {
        return new ArrayList<ErrorDescription>(this.errors2Lines.keySet());
    }

    public synchronized List<Annotation> getAnnotations() {
        return new ArrayList<Annotation>(this.line2Annotations.values());
    }

    public synchronized List<ErrorDescription> getErrorsGE(int n) {
        try {
            Position position = null;
            int n2 = -1;
            int n3 = Utilities.getRowStart((BaseDocument)this.doc, (int)n);
            while (position == null) {
                n2 = this.findPositionGE(n3);
                if (this.knownPositions.size() == 0) break;
                if (n2 == this.knownPositions.size()) {
                    return Collections.emptyList();
                }
                position = this.knownPositions.get(n2).get();
            }
            if (position == null) {
                return Collections.emptyList();
            }
            assert (n2 != -1);
            List<ErrorDescription> list = this.line2Errors.get(position);
            if (list != null) {
                TreeMap<Integer, LinkedList<ErrorDescription>> treeMap = new TreeMap<Integer, LinkedList<ErrorDescription>>();
                for (ErrorDescription object : list) {
                    LinkedList<ErrorDescription> linkedList = (LinkedList<ErrorDescription>)treeMap.get(object.getRange().getBegin().getOffset());
                    if (linkedList == null) {
                        linkedList = new LinkedList<ErrorDescription>();
                        treeMap.put(object.getRange().getBegin().getOffset(), linkedList);
                    }
                    linkedList.add(object);
                }
                SortedMap sortedMap = treeMap.tailMap(n);
                if (!sortedMap.isEmpty()) {
                    Integer n4 = (Integer)sortedMap.firstKey();
                    return new LinkedList<ErrorDescription>((Collection)treeMap.get(n4));
                }
            }
            int n4 = Utilities.getRowEnd((BaseDocument)this.doc, (int)n);
            return this.getErrorsGE(n4 + 1);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return Collections.emptyList();
        }
    }

    public static OffsetsBag getBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(AnnotationHolder.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(AnnotationHolder.class, offsetsBag);
        }
        return offsetsBag;
    }

    public int lineNumber(final Position position) {
        final int[] nArray = new int[]{-1};
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    nArray[0] = Utilities.getLineOffset((BaseDocument)AnnotationHolder.this.doc, (int)position.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
        return nArray[0];
    }

    static {
        COLORINGS.put(Severity.ERROR, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(255, 0, 0), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.WARNING, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(192, 192, 0), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.VERIFIER, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(255, 213, 85), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.HINT, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new TooltipResolver()}));
        file2Holder = new HashMap<DataObject, AnnotationHolder>();
        ABORT = new Abort();
        INSTANCE = new RequestProcessor("AnnotationHolder");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TooltipResolver
    implements HighlightAttributeValue<String> {
        private TooltipResolver() {
        }

        public String getValue(JTextComponent jTextComponent, final Document document, Object object, final int n, final int n2) {
            final Object object2 = document.getProperty("stream");
            if (!(object2 instanceof DataObject) || !(document instanceof BaseDocument)) {
                return null;
            }
            final String[] stringArray = new String[1];
            document.render(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AnnotationHolder annotationHolder;
                        int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                        if (n3 < 0) {
                            return;
                        }
                        AnnotationHolder annotationHolder2 = annotationHolder = AnnotationHolder.getInstance(((DataObject)object2).getPrimaryFile());
                        synchronized (annotationHolder2) {
                            Position position = annotationHolder.getPosition(n3, false);
                            if (position == null) {
                                return;
                            }
                            List list = (List)annotationHolder.line2Errors.get(position);
                            if (list == null || list.isEmpty()) {
                                return;
                            }
                            LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
                            LinkedList<ErrorDescription> linkedList2 = new LinkedList<ErrorDescription>();
                            for (ErrorDescription errorDescription : list) {
                                PositionBounds positionBounds;
                                if (errorDescription == null || n > (positionBounds = errorDescription.getRange()).getEnd().getOffset() || positionBounds.getBegin().getOffset() > n2) continue;
                                if (errorDescription.getSeverity() == Severity.ERROR) {
                                    linkedList.add(errorDescription);
                                    continue;
                                }
                                linkedList2.add(errorDescription);
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            AnnotationHolder.concatDescription(linkedList, stringBuffer);
                            if (!linkedList.isEmpty() && !linkedList2.isEmpty()) {
                                stringBuffer.append("\n\n");
                            }
                            AnnotationHolder.concatDescription(linkedList2, stringBuffer);
                            stringArray[0] = stringBuffer.toString();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            return stringArray[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PositionComparator
    implements Comparator<Object> {
        private PositionComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            int n = -1;
            if (object instanceof Reference) {
                Position position = (Position)((Reference)object).get();
                if (position == null) {
                    throw ABORT;
                }
                n = position.getOffset();
            }
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            assert (n != -1);
            int n2 = -1;
            if (object2 instanceof Reference) {
                Position position = (Position)((Reference)object2).get();
                if (position == null) {
                    throw ABORT;
                }
                n2 = position.getOffset();
            }
            if (object2 instanceof Integer) {
                n2 = (Integer)object2;
            }
            assert (n2 != -1);
            return n - n2;
        }
    }

    private static class Abort
    extends RuntimeException {
        private Abort() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    final class NbDocumentAttacher
    implements Attacher {
        NbDocumentAttacher() {
        }

        public void attachAnnotation(Position position, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
            NbDocument.addAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Position)position, (int)-1, (Annotation)parseErrorAnnotation);
        }

        public void detachAnnotation(Annotation annotation) {
            if (AnnotationHolder.this.doc != null) {
                NbDocument.removeAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Annotation)annotation);
            }
        }
    }

    final class LineAttacher
    implements Attacher {
        LineAttacher() {
        }

        public void attachAnnotation(Position position, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        public void detachAnnotation(Annotation annotation) {
            annotation.detach();
        }
    }

    static interface Attacher {
        public void attachAnnotation(Position var1, ParseErrorAnnotation var2) throws BadLocationException;

        public void detachAnnotation(Annotation var1);
    }
}

