/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.editor.hints.FixData;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.borrowed.ScrollCompletionPane;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class HintsUI
implements MouseListener,
KeyListener,
PropertyChangeListener,
AWTEventListener {
    private static HintsUI INSTANCE;
    private static final String POPUP_NAME = "hintsPopup";
    private static final int POPUP_VERTICAL_OFFSET = 5;
    static Logger UI_GESTURES_LOGGER;
    private JTextComponent comp;
    private Popup listPopup;
    private Popup tooltipPopup;
    private JLabel hintIcon;
    private ScrollCompletionPane hintListComponent;
    private JLabel errorTooltip;
    private PopupFactory pf = null;
    private ChangeInfo changes;
    private static String[] c;
    private static String[] tags;

    public static synchronized HintsUI getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new HintsUI();
        }
        return INSTANCE;
    }

    private HintsUI() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        this.propertyChange(null);
    }

    public JTextComponent getComponent() {
        return this.comp;
    }

    public void removeHints() {
        this.removePopups();
        this.setComponent(null);
    }

    public void setComponent(JTextComponent jTextComponent) {
        boolean bl;
        boolean bl2 = bl = this.comp != jTextComponent;
        if (bl) {
            this.unregister();
            this.comp = jTextComponent;
            this.register();
        }
    }

    private void register() {
        if (this.comp == null) {
            return;
        }
        this.comp.addKeyListener(this);
    }

    private void unregister() {
        if (this.comp == null) {
            return;
        }
        this.comp.removeKeyListener(this);
    }

    public void removePopups() {
        if (this.comp == null) {
            return;
        }
        this.removeIconHint();
        this.removePopup();
    }

    private void removeIconHint() {
        Container container;
        if (this.hintIcon != null && (container = this.hintIcon.getParent()) != null) {
            Rectangle rectangle = this.hintIcon.getBounds();
            container.remove(this.hintIcon);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void removePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.listPopup != null) {
            if (this.tooltipPopup != null) {
                this.tooltipPopup.hide();
            }
            this.tooltipPopup = null;
            this.listPopup.hide();
            if (this.hintListComponent != null) {
                this.hintListComponent.getView().removeMouseListener(this);
            }
            if (this.errorTooltip != null) {
                this.errorTooltip.removeMouseListener(this);
            }
            this.hintListComponent = null;
            this.errorTooltip = null;
            this.listPopup = null;
            if (this.hintIcon != null) {
                this.hintIcon.setToolTipText(NbBundle.getMessage(HintsUI.class, (String)"HINT_Bulb"));
            }
        }
    }

    boolean isKnownComponent(Component component) {
        return component != null && (component == this.comp || component == this.hintIcon || component == this.hintListComponent || component instanceof Container && ((Container)component).isAncestorOf(this.hintListComponent));
    }

    public void showPopup(FixData fixData) {
        if (this.comp == null || fixData.isComputed() && fixData.getFixes().isEmpty()) {
            return;
        }
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        assert (this.hintListComponent == null);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        try {
            int n = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            Rectangle rectangle = this.comp.modelToView(n);
            Point point = new Point(rectangle.x + 5, rectangle.y + 20);
            SwingUtilities.convertPointToScreen(point, this.comp);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            dimension.width -= point.x;
            dimension.height -= point.y;
            this.hintListComponent = new ScrollCompletionPane(this.comp, fixData, null, null, dimension);
            this.hintListComponent.getView().addMouseListener(this);
            this.hintListComponent.setName(POPUP_NAME);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, point.x, point.y);
            this.listPopup.show();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            this.removeHints();
        }
    }

    public void showPopup(FixData fixData, String string, JTextComponent jTextComponent, Point point) {
        this.removeHints();
        this.setComponent(jTextComponent);
        if (this.comp == null || fixData == null) {
            return;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, this.comp);
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        this.errorTooltip = new JLabel("<html>" + this.translate(string));
        this.errorTooltip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.errorTooltip.addMouseListener(this);
        if (!fixData.isComputed() || fixData.getFixes().isEmpty()) {
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.errorTooltip, point2.x, point2.y);
        } else {
            assert (this.hintListComponent == null);
            int n = 14;
            this.hintListComponent = new ScrollCompletionPane(this.comp, fixData, null, null, this.getMaxSizeAt(point2));
            Dimension dimension = this.hintListComponent.getPreferredSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            boolean bl = point2.y + dimension.height > dimension2.height;
            try {
                int n2 = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
                Rectangle rectangle = this.comp.modelToView(n2);
                n = rectangle.height;
                int n3 = bl ? point2.y + 5 : point2.y - n - this.errorTooltip.getPreferredSize().height - 5;
                this.tooltipPopup = this.getPopupFactory().getPopup(this.comp, this.errorTooltip, point2.x, n3);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
                this.errorTooltip = null;
            }
            if (bl) {
                point2.y -= dimension.height + n + 5;
            }
            if (point2.x + dimension.width > dimension2.width) {
                point2.x -= point2.x + dimension.width - dimension2.width;
            }
            this.hintListComponent.getView().addMouseListener(this);
            this.hintListComponent.setName(POPUP_NAME);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, point2.x, point2.y);
        }
        if (this.tooltipPopup != null) {
            this.tooltipPopup.show();
        }
        this.listPopup.show();
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    private Dimension getMaxSizeAt(Point point) {
        Rectangle rectangle = null;
        rectangle = null != this.comp && null != this.comp.getGraphicsConfiguration() ? this.comp.getGraphicsConfiguration().getBounds() : new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Dimension dimension = rectangle.getSize();
        dimension.width -= point.x - rectangle.x;
        dimension.height -= point.y - rectangle.y;
        return dimension;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.hintListComponent || mouseEvent.getSource() instanceof ListCompletionView) {
            Fix fix = null;
            Object e = this.hintListComponent.getView().getSelectedValue();
            if (e instanceof Fix) {
                fix = (Fix)e;
            }
            if (fix != null) {
                mouseEvent.consume();
                JTextComponent jTextComponent = this.comp;
                this.invokeHint(fix);
                if (jTextComponent != null && org.openide.util.Utilities.isMac()) {
                    jTextComponent.requestFocus();
                }
                this.removeHints();
                this.setComponent(jTextComponent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean isActive() {
        boolean bl = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl2 = this.hintListComponent != null && this.hintListComponent.isShowing();
        return bl || bl2;
    }

    public boolean isPopupActive() {
        return this.hintListComponent != null && this.hintListComponent.isShowing();
    }

    private ParseErrorAnnotation findAnnotation(Document document, AnnotationDesc annotationDesc, int n) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        AnnotationHolder annotationHolder = AnnotationHolder.getInstance(dataObject.getPrimaryFile());
        if (annotationHolder != null) {
            for (Annotation annotation : annotationHolder.getAnnotations()) {
                ParseErrorAnnotation parseErrorAnnotation;
                if (!(annotation instanceof ParseErrorAnnotation) || n != (parseErrorAnnotation = (ParseErrorAnnotation)annotation).getLineNumber() || annotationDesc == null || !org.openide.util.Utilities.compareObjects((Object)annotationDesc.getShortDescription(), (Object)annotation.getShortDescription())) continue;
                return parseErrorAnnotation;
            }
        }
        return null;
    }

    boolean invokeDefaultAction(boolean bl) {
        JTextComponent jTextComponent = this.comp;
        if (jTextComponent == null) {
            Logger.getLogger(HintsUI.class.getName()).log(Level.WARNING, "HintsUI.invokeDefaultAction called, but comp == null");
            return false;
        }
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            Annotations annotations = ((BaseDocument)document).getAnnotations();
            try {
                Object object;
                Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                int n = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)jTextComponent.getCaretPosition());
                AnnotationDesc annotationDesc = annotations.getActiveAnnotation(n);
                ParseErrorAnnotation parseErrorAnnotation = this.findAnnotation(document, annotationDesc, n);
                if (parseErrorAnnotation == null) {
                    AnnotationDesc annotationDesc2;
                    if (bl) {
                        return false;
                    }
                    object = annotations.getPasiveAnnotations(n);
                    if (object == null) {
                        return false;
                    }
                    Object object2 = object;
                    int n2 = ((AnnotationDesc[])object2).length;
                    for (int i = 0; i < n2 && (parseErrorAnnotation = this.findAnnotation(document, annotationDesc2 = object2[i], n)) == null; ++i) {
                    }
                    if (parseErrorAnnotation == null) {
                        return false;
                    }
                }
                object = jTextComponent.modelToView(Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n)).getLocation();
                object.y += rectangle.height;
                if (jTextComponent.getParent() instanceof JViewport) {
                    object.x += ((JViewport)jTextComponent.getParent()).getViewPosition().x;
                }
                this.showPopup(parseErrorAnnotation.getFixes(), parseErrorAnnotation.getDescription(), jTextComponent, (Point)object);
                return true;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        if (this.comp == null) {
            return;
        }
        boolean bl2 = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl3 = this.errorTooltip != null && this.errorTooltip.isShowing();
        boolean bl4 = bl = this.hintListComponent != null && this.hintListComponent.isShowing();
        if (bl3 && !bl) {
            this.removePopup();
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getModifiersEx() == 192 || keyEvent.getModifiersEx() == 512) {
                if (!bl) {
                    this.invokeDefaultAction(false);
                    keyEvent.consume();
                }
            } else if (keyEvent.getModifiersEx() == 0 && bl) {
                Fix fix = null;
                Object e = this.hintListComponent.getView().getSelectedValue();
                if (e instanceof Fix) {
                    fix = (Fix)e;
                }
                if (fix != null) {
                    this.invokeHint(fix);
                }
                keyEvent.consume();
            }
        } else if (keyEvent.getKeyCode() == 27) {
            if (bl) {
                this.removePopup();
            }
        } else if (bl) {
            InputMap inputMap = this.hintListComponent.getInputMap();
            Object object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
            if (object != null) {
                Action action = this.hintListComponent.getActionMap().get(object);
                action.actionPerformed(null);
                keyEvent.consume();
                return;
            }
            this.removePopup();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeHint(final Fix fix) {
        Serializable serializable;
        if (UI_GESTURES_LOGGER.isLoggable(Level.FINE)) {
            serializable = new LogRecord(Level.FINE, "GEST_HINT_INVOKED");
            ((LogRecord)serializable).setResourceBundle(NbBundle.getBundle(HintsUI.class));
            ((LogRecord)serializable).setParameters(new Object[]{fix.getText()});
            UI_GESTURES_LOGGER.log((LogRecord)serializable);
        }
        this.removePopups();
        serializable = this.comp;
        JumpList.checkAddEntry((JTextComponent)serializable);
        Cursor cursor = ((Component)serializable).getCursor();
        ((Component)serializable).setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.Task task = null;
        try {
            task = RequestProcessor.getDefault().post(new Runnable((JTextComponent)serializable){
                final /* synthetic */ JTextComponent val$component;
                {
                    this.val$component = jTextComponent;
                }

                public void run() {
                    try {
                        HintsUI.this.changes = fix.implement();
                    }
                    catch (GuardedException guardedException) {
                        HintsUI.reportGuardedException(this.val$component, (Exception)((Object)guardedException));
                    }
                    catch (IOException iOException) {
                        if (iOException.getCause() instanceof GuardedException) {
                            HintsUI.reportGuardedException(this.val$component, iOException);
                        } else {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            });
            if (task == null) return;
        }
        catch (Throwable throwable) {
            if (task == null) throw throwable;
            task.addTaskListener(new TaskListener((JTextComponent)serializable, cursor){
                final /* synthetic */ JTextComponent val$component;
                final /* synthetic */ Cursor val$cur;
                {
                    this.val$component = jTextComponent;
                    this.val$cur = cursor;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HintsUI.open(HintsUI.this.changes, val$component);
                            val$component.setCursor(val$cur);
                        }
                    });
                }
            });
            throw throwable;
        }
        task.addTaskListener(new /* invalid duplicate definition of identical inner class */);
    }

    private static void reportGuardedException(final JTextComponent jTextComponent, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = NbBundle.getMessage(HintsUI.class, (String)"ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)string);
                Logger.getLogger(HintsUI.class.getName()).log(Level.FINE, null, exception);
            }
        });
    }

    private static void open(ChangeInfo changeInfo, JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = jTextComponent;
        if (changeInfo != null && changeInfo.size() > 0) {
            Position position;
            Position position2;
            ChangeInfo.Change change = changeInfo.get(0);
            FileObject fileObject = change.getFileObject();
            if (fileObject != null) {
                try {
                    OpenCookie openCookie;
                    position2 = DataObject.find((FileObject)fileObject);
                    position = (EditCookie)position2.getCookie(EditCookie.class);
                    if (position != null) {
                        position.edit();
                    } else {
                        openCookie = (OpenCookie)position2.getCookie(OpenCookie.class);
                        openCookie.open();
                    }
                    openCookie = (EditorCookie)position2.getCookie(EditorCookie.class);
                    JEditorPane[] jEditorPaneArray = openCookie.getOpenedPanes();
                    if (jEditorPaneArray == null || jEditorPaneArray.length <= 0) {
                        return;
                    }
                    jTextComponent2 = jEditorPaneArray[0];
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(HintsUI.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
                    return;
                }
            }
            position2 = change.getStart();
            position = change.getEnd();
            if (position2 != null) {
                jTextComponent2.setSelectionStart(position2.getOffset());
            }
            if (position != null) {
                jTextComponent2.setSelectionEnd(position.getOffset());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (this.getComponent() != jTextComponent) {
            this.removeHints();
            this.setComponent(jTextComponent);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 500 && mouseEvent.getClickCount() > 0) {
            if (!(aWTEvent.getSource() instanceof Component)) {
                this.removePopup();
                return;
            }
            Component component = (Component)aWTEvent.getSource();
            Container container = SwingUtilities.getAncestorNamed(POPUP_NAME, component);
            if (container == null) {
                this.removePopup();
            }
        }
    }

    private String translate(String string) {
        for (int i = 0; i < c.length; ++i) {
            string = string.replaceAll(c[i], tags[i]);
        }
        return string;
    }

    static {
        UI_GESTURES_LOGGER = Logger.getLogger("org.netbeans.ui.editor.hints");
        c = new String[]{"&", "<", ">", "\n", "\""};
        tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};
    }
}

