/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NextErrorAction
extends AbstractAction
implements PropertyChangeListener {
    public NextErrorAction() {
        this.putValue("Name", NbBundle.getMessage(NextErrorAction.class, (String)"LBL_Next_Error"));
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, EditorRegistry.class));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final JTextComponent jTextComponent = EditorRegistry.focusedComponent();
        if (jTextComponent == null) {
            return;
        }
        jTextComponent.getDocument().render(new Runnable(){

            public void run() {
                List list = null;
                int n = -1;
                int n2 = -1;
                int n3 = jTextComponent.getCaretPosition() + 1;
                if (n3 < jTextComponent.getDocument().getLength()) {
                    list = NextErrorAction.this.findNextError(jTextComponent, n3);
                    n = list.isEmpty() ? -1 : ((ErrorDescription)list.iterator().next()).getRange().getBegin().getOffset();
                    n2 = NextErrorAction.this.findNextUnused(jTextComponent, n3);
                }
                if (n == -1 && n2 == -1) {
                    list = NextErrorAction.this.findNextError(jTextComponent, 0);
                    n = list.isEmpty() ? -1 : ((ErrorDescription)list.iterator().next()).getRange().getBegin().getOffset();
                    n2 = NextErrorAction.this.findNextUnused(jTextComponent, 0);
                }
                if (n == -1 && n2 == -1) {
                    Toolkit.getDefaultToolkit().beep();
                } else if (n != -1 && (n < n2 || n2 == -1)) {
                    jTextComponent.getCaret().setDot(n);
                    Utilities.setStatusText((JTextComponent)jTextComponent, (String)NextErrorAction.this.buildText(list));
                } else {
                    jTextComponent.getCaret().setDot(n2);
                    Utilities.setStatusText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(NextErrorAction.class, (String)"LBL_UnusedElement"));
                }
            }
        });
    }

    private List<ErrorDescription> findNextError(JTextComponent jTextComponent, int n) {
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        Object object = baseDocument.getProperty("stream");
        if (!(object instanceof DataObject)) {
            return Collections.emptyList();
        }
        AnnotationHolder annotationHolder = AnnotationHolder.getInstance(((DataObject)object).getPrimaryFile());
        List<ErrorDescription> list = annotationHolder.getErrorsGE(n);
        return list;
    }

    private int findNextUnused(JTextComponent jTextComponent, int n) {
        try {
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            HighlightsSequence highlightsSequence = HighlightingManager.getInstance().getHighlights(jTextComponent, null).getHighlights(n2, Integer.MAX_VALUE);
            int n3 = -1;
            while (highlightsSequence.moveNext()) {
                if (!highlightsSequence.getAttributes().containsAttribute("unused-browseable", Boolean.TRUE)) continue;
                if (n3 != highlightsSequence.getStartOffset() && highlightsSequence.getStartOffset() >= n) {
                    return highlightsSequence.getStartOffset();
                }
                n3 = highlightsSequence.getEndOffset();
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return -1;
        }
    }

    private String buildText(List<ErrorDescription> list) {
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        LinkedList<ErrorDescription> linkedList2 = new LinkedList<ErrorDescription>();
        for (ErrorDescription errorDescription : list) {
            if (errorDescription == null) continue;
            if (errorDescription.getSeverity() == Severity.ERROR) {
                linkedList.add(errorDescription);
                continue;
            }
            linkedList2.add(errorDescription);
        }
        StringBuffer stringBuffer = new StringBuffer();
        NextErrorAction.concatDescription(linkedList, stringBuffer);
        if (!linkedList.isEmpty() && !linkedList2.isEmpty()) {
            stringBuffer.append(" ");
        }
        NextErrorAction.concatDescription(linkedList2, stringBuffer);
        return stringBuffer.toString().replace('\n', ' ');
    }

    private static void concatDescription(List<ErrorDescription> list, StringBuffer stringBuffer) {
        boolean bl = true;
        for (ErrorDescription errorDescription : list) {
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(errorDescription.getDescription());
            bl = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setEnabled(EditorRegistry.focusedComponent() != null);
    }
}

