/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.serverapi.api;

import java.io.File;
import java.util.Set;
import org.netbeans.modules.websvc.serverapi.WSStackAccessor;
import org.netbeans.modules.websvc.serverapi.api.WSStackFeature;
import org.netbeans.modules.websvc.serverapi.api.WSStackProvider;
import org.netbeans.modules.websvc.serverapi.api.WSUriDescriptor;
import org.netbeans.modules.websvc.serverapi.spi.WSStackSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSStack {
    private WSStackSPI spi;
    private WSStackProvider stackProvider;
    public static final String STACK_JAX_WS = "stack_jax_ws";
    public static final String STACK_JAX_RPC = "stack_jax-rpc";
    public static final String STACK_AXIS2 = "stack_axis2";
    public static final String TOOL_WSIMPORT = "tool_wsimport";
    public static final String TOOL_WSGEN = "tool_wsgen";
    public static final String TOOL_WSCOMPILE = "tool_wscompile";
    public static final String TOOL_AXIS_JAVA2WSDL = "tool_axis_java2wsdl";
    public static final String TOOL_AXIS_WSDL2JAVA = "tool_axis_wsdl2java";
    public static final String TOOL_KEYSTORE = "tool_keystore";
    public static final String TOOL_TRUSTSTORE = "tool_truststore";
    public static final String TOOL_KEYSTORE_CLIENT = "tool_keystore_client";
    public static final String TOOL_TRUSTSTORE_CLIENT = "tool_truststore_client";

    private WSStack(WSStackSPI wSStackSPI, WSStackProvider wSStackProvider) {
        if (wSStackSPI == null) {
            throw new IllegalArgumentException();
        }
        this.spi = wSStackSPI;
        this.stackProvider = wSStackProvider;
    }

    public String getName() {
        return this.spi.getName();
    }

    public String getVersion() {
        return this.spi.getVersion();
    }

    public WSStackProvider getWSStackProvider() {
        return this.stackProvider == null ? WSStackProvider.SERVER : this.stackProvider;
    }

    public Set<String> getSupportedTools() {
        return this.spi.getSupportedTools();
    }

    public File[] getToolClassPathEntries(String string) {
        return this.spi.getToolClassPathEntries(string);
    }

    public WSUriDescriptor getServiceUriDescriptor() {
        return this.spi.getServiceUriDescriptor();
    }

    public Set<WSStackFeature> getServiceFeatures() {
        return this.spi.getServiceFeatures();
    }

    static {
        WSStackAccessor.DEFAULT = new WSStackAccessor(){

            public WSStack createWSStack(WSStackSPI wSStackSPI, WSStackProvider wSStackProvider) {
                return new WSStack(wSStackSPI, wSStackProvider);
            }
        };
    }
}

