/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.TreeBase;
import com.sun.rave.web.ui.component.TreeNode;
import com.sun.rave.web.ui.util.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.validator.Validator;
import javax.servlet.http.Cookie;

public class Tree
extends TreeBase
implements EditableValueHolder {
    private Converter converter = null;
    private List validators = null;
    private MethodBinding validatorBinding = null;
    private Object submittedValue = null;
    private boolean valid = true;
    private boolean localValueSet;
    private MethodBinding valueChangeMethod = null;
    private Object value = null;
    public static final String JAVA_SCRIPT_THEME_KEY = "tree";
    public static final String LAYOUT_KEY = "layout/tree.xml";
    public static final String SELECTED_SUFFIX = "_select";
    public static final String COOKIE_SUFFIX = "-hi";
    public static final String COOKIE_SUFFIX_EXPAND = "-expand";

    public Tree() {
        this.setLayoutDefinitionKey(LAYOUT_KEY);
    }

    public String getSelected() {
        return (String)this.getValue();
    }

    public void setSelected(String s) {
        this.setValue(s);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter conv) {
        this.converter = conv;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            return vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setValue(Object val) {
        this.value = val;
        this.setLocalValueSet(true);
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object value) {
        this.submittedValue = value;
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean value) {
        this.localValueSet = value;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public MethodBinding getValidator() {
        return this.validatorBinding;
    }

    public void setValidator(MethodBinding valBinding) {
        this.validatorBinding = valBinding;
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            return new Validator[0];
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public MethodBinding getValueChangeListener() {
        return this.valueChangeMethod;
    }

    public void setValueChangeListener(MethodBinding method) {
        this.valueChangeMethod = method;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void decode(FacesContext context) {
        this.setValid(true);
        super.decode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding method;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (method = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            method.invoke(context, new Object[]{event});
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException ex) {
            context.renderResponse();
            throw new RuntimeException(ex);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb == null) {
            return;
        }
        try {
            vb.setValue(context, this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
            return;
        }
        catch (Exception ex) {
            String messageStr = ex.getMessage();
            if (messageStr != null) {
                FacesMessage message = null;
                message = new FacesMessage(messageStr);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), message);
            }
            this.setValid(false);
            if (LogUtil.configEnabled()) {
                LogUtil.config("Unable to update Model!", ex);
            }
            return;
        }
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Object newValue = submittedValue;
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.isDifferent(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    protected boolean isDifferent(Object val1, Object val2) {
        if (val1 == val2) {
            return false;
        }
        if (val1 == null) {
            return true;
        }
        return !val1.equals(val2);
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (!this.isValid()) {
            return;
        }
        if (this.isRequired() && (newValue == null || newValue.toString().trim().equals(""))) {
            this.setValid(false);
        }
    }

    public void selectTreeNode(TreeNode treeNode) {
        this.setValue(treeNode);
    }

    public void selectTreeNode(String clientId) {
        this.setValue(clientId);
    }

    public String getCookieSelectedTreeNode() {
        String treeCID;
        FacesContext context = FacesContext.getCurrentInstance();
        Cookie cookie = this.getCookie(context, (treeCID = this.getClientId(context)) + COOKIE_SUFFIX);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public String getCookieExpandNode() {
        String treeCID;
        FacesContext context = FacesContext.getCurrentInstance();
        Cookie cookie = this.getCookie(context, (treeCID = this.getClientId(context)) + COOKIE_SUFFIX_EXPAND);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    private Cookie getCookie(FacesContext context, String name) {
        ExternalContext extCtx = context.getExternalContext();
        return (Cookie)extCtx.getRequestCookieMap().get(name);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), Tree.saveAttachedState((FacesContext)context, (Object)this.converter), this.value, this.localValueSet ? Boolean.TRUE : Boolean.FALSE, this.valid ? Boolean.TRUE : Boolean.FALSE, Tree.saveAttachedState((FacesContext)context, (Object)this.validators), Tree.saveAttachedState((FacesContext)context, (Object)this.validatorBinding), Tree.saveAttachedState((FacesContext)context, (Object)this.valueChangeMethod)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.converter = (Converter)Tree.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.value = values[2];
        this.localValueSet = (Boolean)values[3];
        this.valid = (Boolean)values[4];
        List restoredValidators = null;
        Iterator iter = null;
        restoredValidators = (List)Tree.restoreAttachedState((FacesContext)context, (Object)values[5]);
        if (null != restoredValidators) {
            if (null != this.validators) {
                iter = restoredValidators.iterator();
                while (iter.hasNext()) {
                    this.validators.add(iter.next());
                }
            } else {
                this.validators = restoredValidators;
            }
        }
        this.validatorBinding = (MethodBinding)Tree.restoreAttachedState((FacesContext)context, (Object)values[6]);
        this.valueChangeMethod = (MethodBinding)Tree.restoreAttachedState((FacesContext)context, (Object)values[7]);
    }
}

