/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.converter;

import com.sun.rave.web.ui.component.DateManager;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class DateConverter
implements Converter,
Serializable {
    private static final String INVALID_DATE_ID = "DateConverter.invalidDate";

    public String getAsString(FacesContext context, UIComponent component, Object o) throws ConverterException {
        try {
            return this.getDateManager(component).getDateFormat().format((Date)o);
        }
        catch (Exception ex) {
            throw new ConverterException((Throwable)ex);
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String s) throws ConverterException {
        if (s.length() == 0) {
            return null;
        }
        DateFormat df = this.getDateManager(component).getDateFormat();
        boolean saveLenient = df.isLenient();
        df.setLenient(false);
        try {
            Date date;
            Date date2 = date = df.parse(s);
            return date2;
        }
        catch (Exception ex) {
            FacesMessage facesMessage = null;
            try {
                String message = ThemeUtilities.getTheme(context).getMessage(INVALID_DATE_ID);
                MessageFormat mf = new MessageFormat(message, context.getViewRoot().getLocale());
                String example = this.getDateManager(component).getDateFormat().format(new Date());
                Object[] params = new Object[]{s, example};
                facesMessage = new FacesMessage(mf.format(params));
            }
            catch (Exception e) {
                throw new ConverterException((Throwable)ex);
            }
            throw new ConverterException(facesMessage);
        }
        finally {
            df.setLenient(saveLenient);
        }
    }

    private DateManager getDateManager(UIComponent component) {
        DateManager dateManager = null;
        if (component instanceof DateManager) {
            dateManager = (DateManager)component;
        } else if (component.getParent() instanceof DateManager) {
            dateManager = (DateManager)component.getParent();
        }
        if (dateManager == null) {
            throw new RuntimeException("The DateConverter can only be used with components which implement DateManager");
        }
        return dateManager;
    }
}

