/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.event;

import com.sun.rave.web.ui.component.Table;
import com.sun.rave.web.ui.component.TableRowGroup;
import com.sun.rave.web.ui.component.TextField;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.LogUtil;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class TablePaginationActionListener
implements ActionListener {
    public void processAction(ActionEvent event) throws AbortProcessingException {
        UIComponent source;
        UIComponent uIComponent = source = event != null ? (UIComponent)event.getSource() : null;
        if (source == null) {
            this.log("processAction", "Cannot process action, ActionEvent source is null");
            return;
        }
        this.processTable(this.getTableAncestor(source), source.getId());
    }

    private void processTable(Table component, String id) throws AbortProcessingException {
        if (component == null) {
            this.log("processTable", "Cannot process Table action, Table is null");
            return;
        }
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            if (id.equals("_paginationFirstButton")) {
                this.setFirst(group);
                continue;
            }
            if (id.equals("_paginationLastButton")) {
                this.setLast(group);
                continue;
            }
            if (id.equals("_paginationNextButton")) {
                this.setNext(group);
                continue;
            }
            if (id.equals("_paginateButton")) {
                this.setPaginated(group);
                continue;
            }
            if (id.equals("_paginationPrevButton")) {
                this.setPrev(group);
                continue;
            }
            if (!id.equals("_paginationSubmitButton")) continue;
            try {
                this.setPage(group, this.getPage(component));
            }
            catch (NumberFormatException e) {
                this.log("processTable", "Cannot obtain page field value");
                return;
            }
        }
    }

    private Table getTableAncestor(UIComponent component) {
        if (component == null) {
            this.log("getTableAncestor", "Cannot obtain Table ancestor, UIComponent is null");
            return null;
        }
        if (component instanceof Table) {
            return (Table)component;
        }
        return this.getTableAncestor(component.getParent());
    }

    private int getPage(Table component) {
        UIComponent actions = component.getFacet("_tableActionsBottom");
        UIComponent field = actions != null ? actions.getFacet("_paginationPageField") : null;
        String value = null;
        if (field instanceof TextField) {
            value = ConversionUtilities.convertValueToString(field, ((TextField)field).getValue());
        } else {
            this.log("getPage", "Cannot obtain page text field value, not TextField instance");
        }
        return value != null ? Integer.parseInt(value) : -1;
    }

    private void setPage(TableRowGroup component, int page) {
        if (component == null) {
            this.log("setPage", "Cannot set page, TableRowGroup is null");
            return;
        }
        int row = (page - 1) * component.getRows();
        this.setRow(component, row);
    }

    private void setFirst(TableRowGroup component) {
        if (component == null) {
            this.log("setFirst", "Canot set first row, TableRowGroup is null");
            return;
        }
        this.setRow(component, 0);
    }

    private void setLast(TableRowGroup component) {
        if (component == null) {
            this.log("setLast", "Cannot set last row, TableRowGroup is null");
            return;
        }
        this.setRow(component, component.getLast());
    }

    private void setNext(TableRowGroup component) {
        if (component == null) {
            this.log("setNext", "Cannot set next row, TableRowGroup is null");
            return;
        }
        int row = component.getFirst() + component.getRows();
        this.setRow(component, row);
    }

    private void setPaginated(TableRowGroup component) {
        if (component == null) {
            this.log("setPaginated", "Cannot set paginated, TableRowGroup is null");
            return;
        }
        component.setPaginated(!component.isPaginated());
    }

    private void setPrev(TableRowGroup component) {
        if (component == null) {
            this.log("setPrev", "Cannot set previous row, TableRowGroup is null");
            return;
        }
        int row = component.getFirst() - component.getRows();
        this.setRow(component, row);
    }

    private void setRow(TableRowGroup component, int row) {
        if (component == null) {
            this.log("setRow", "Cannot set row, TableRowGroup is null");
            return;
        }
        int result = Math.min(row, component.getLast());
        component.setFirst(Math.min(Math.max(result, 0), component.getRowCount()));
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

