/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.MessageGroup;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.FacesMessageUtils;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageGroupRenderer
extends AbstractRenderer {
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        MessageGroup msgGrp = (MessageGroup)component;
        Iterator<FacesMessage> msgIt = null;
        String forComponentId = null;
        if (Beans.isDesignTime() && (msgGrp.isShowDetail() || msgGrp.isShowSummary())) {
            StringBuffer resourceNameBuffer = new StringBuffer();
            resourceNameBuffer.append("MessageGroup.");
            if (msgGrp.isShowGlobalOnly()) {
                resourceNameBuffer.append("global.");
            } else {
                resourceNameBuffer.append("default.");
            }
            if (msgGrp.isShowDetail() && msgGrp.isShowSummary()) {
                resourceNameBuffer.append("both");
            } else if (msgGrp.isShowDetail()) {
                resourceNameBuffer.append("detail");
            } else if (msgGrp.isShowSummary()) {
                resourceNameBuffer.append("summary");
            }
            String summary = MessageUtil.getMessage(context, "com.sun.rave.web.ui.renderer.Bundle", resourceNameBuffer.toString());
            FacesMessage defaultMessage = new FacesMessage();
            defaultMessage.setSummary(summary);
            msgIt = Collections.singletonList(defaultMessage).iterator();
        } else {
            if (msgGrp.isShowGlobalOnly()) {
                forComponentId = "";
            }
            msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)msgGrp);
        }
        if (msgIt.hasNext()) {
            this.renderMessageGroup(context, (UIComponent)msgGrp, writer, msgIt);
        }
    }

    public void renderMessageGroup(FacesContext context, UIComponent component, ResponseWriter writer, Iterator msgIt) throws IOException {
        MessageGroup msgGrp = (MessageGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderUserStyles(context, msgGrp, writer);
        this.renderOpeningTable(msgGrp, writer, theme);
        FacesMessage fMsg = null;
        boolean showSummary = msgGrp.isShowSummary();
        boolean showDetail = msgGrp.isShowDetail();
        String summaryStyle = "MsgGrpSumTxt";
        String detailStyle = "MsgGrpTxt";
        String summary = null;
        String detail = null;
        while (msgIt.hasNext()) {
            fMsg = (FacesMessage)msgIt.next();
            if (showSummary && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
                summary = null;
            }
            if (showDetail && (detail = fMsg.getDetail()) != null && detail.length() <= 0) {
                detail = null;
            }
            if (summary == null && detail == null) continue;
            writer.startElement("div", (UIComponent)msgGrp);
            writer.writeAttribute("class", (Object)theme.getStyleClass("MsgGrpDiv"), null);
            writer.startElement("ul", (UIComponent)msgGrp);
            writer.startElement("li", (UIComponent)msgGrp);
            String severityStyleClass = null;
            if (fMsg.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyleClass = theme.getStyleClass("MsgGrpInfo");
            } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyleClass = theme.getStyleClass("MsgGrpWarn");
            } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyleClass = theme.getStyleClass("MsgGrpError");
            } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyleClass = theme.getStyleClass("MsgGrpFatal");
            }
            if (severityStyleClass != null && severityStyleClass.length() > 0) {
                writer.writeAttribute("class", (Object)severityStyleClass, "styleClass");
            }
            if (summary != null) {
                if (severityStyleClass == null || severityStyleClass == "") {
                    this.renderMessageText(msgGrp, writer, summary, summaryStyle);
                } else {
                    this.renderMessageText(msgGrp, writer, summary, null);
                }
            }
            if (detail != null) {
                if (summary != null) {
                    detail = " " + detail;
                }
                if (severityStyleClass == null || severityStyleClass == "") {
                    this.renderMessageText(msgGrp, writer, detail, detailStyle);
                } else {
                    this.renderMessageText(msgGrp, writer, detail, null);
                }
            }
            writer.endElement("li");
            writer.endElement("ul");
            writer.endElement("div");
        }
        this.renderClosingTable(writer);
        writer.endElement("div");
    }

    public void renderOpeningTable(MessageGroup msgGrp, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("table", (UIComponent)msgGrp);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        if (msgGrp.getToolTip() != null) {
            writer.writeAttribute("title", (Object)msgGrp.getToolTip(), null);
        }
        writer.writeAttribute("class", (Object)theme.getStyleClass("MsgGrpTbl"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("caption", (UIComponent)msgGrp);
        writer.writeAttribute("class", (Object)theme.getStyleClass("MsgGrpTblTtl"), null);
        writer.writeText((Object)theme.getMessage("messageGroup.heading"), null);
        writer.endElement("caption");
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)msgGrp);
        writer.startElement("td", (UIComponent)msgGrp);
    }

    public void renderClosingTable(ResponseWriter writer) throws IOException {
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    public void renderMessageText(MessageGroup msgGrp, ResponseWriter writer, String msgText, String textStyle) throws IOException {
        writer.startElement("span", (UIComponent)msgGrp);
        if (textStyle != null && textStyle.length() > 0) {
            writer.writeAttribute("class", (Object)textStyle, "class");
        }
        writer.writeText((Object)msgText, null);
        writer.endElement("span");
    }

    private void renderUserStyles(FacesContext context, MessageGroup msgGrp, ResponseWriter writer) throws IOException {
        String userStyle = msgGrp.getStyle();
        String userStyleClass = msgGrp.getStyleClass();
        String id = msgGrp.getClientId(context);
        writer.startElement("div", (UIComponent)msgGrp);
        writer.writeAttribute("id", (Object)id, "id");
        if (userStyle != null && userStyle.length() > 0) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)msgGrp, null);
    }
}

