/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.SkipHyperlink;
import com.sun.rave.web.ui.component.Tab;
import com.sun.rave.web.ui.component.TabSet;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;

public class TabSetRenderer
extends AbstractRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        TabSet tabSet = (TabSet)component;
        String selectedTabId = tabSet.getSelected();
        Theme theme = ThemeUtilities.getTheme(context);
        String lite = theme.getStyleClass("TabGrpBox");
        if (selectedTabId == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        Tab selectedTab = tabSet.findChildTab(selectedTabId);
        if (selectedTab == null) {
            if (tabSet.isMini() && tabSet.isLite()) {
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)lite, null);
                writer.endElement("div");
            }
            writer.endElement("div");
            return;
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.startElement("div", (UIComponent)tabSet);
            writer.writeAttribute("class", (Object)lite, null);
        }
        while (selectedTab.hasTabChildren()) {
            selectedTabId = selectedTab.getSelectedChildId();
            if (selectedTabId == null) {
                selectedTabId = ((Tab)selectedTab.getChildren().get(0)).getId();
            }
            selectedTab = (Tab)selectedTab.findComponent(selectedTabId);
        }
        int numKids = selectedTab.getChildCount();
        if (numKids > 0) {
            UIComponent facet = tabSet.getFacet("contentHeader");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
            List kids = selectedTab.getChildren();
            for (int i = 0; i < numKids; ++i) {
                UIComponent kid = (UIComponent)kids.get(i);
                RenderingUtilities.renderComponent(kid, context);
            }
            facet = tabSet.getFacet("contentFooter");
            if (facet != null) {
                RenderingUtilities.renderComponent(facet, context);
            }
        }
        if (tabSet.isMini() && tabSet.isLite()) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        List level3Tabs;
        TabSet tabSet = (TabSet)component;
        ResponseWriter writer = context.getResponseWriter();
        List level1 = tabSet.getChildren();
        if (level1.size() < 1) {
            if (LogUtil.infoEnabled()) {
                LogUtil.info((Object)TabSetRenderer.class, "WEBUI0005", new String[]{tabSet.getId()});
            }
            return;
        }
        String style = tabSet.getStyle();
        String styleClass = tabSet.getStyleClass();
        Theme theme = ThemeUtilities.getTheme(context);
        String lite = theme.getStyleClass("TabGrp");
        if (tabSet.isMini() && tabSet.isLite()) {
            styleClass = styleClass != null ? styleClass + " " + lite : lite;
        }
        if (!tabSet.isVisible()) {
            String hiddenStyle = theme.getStyleClass("hidden");
            styleClass = styleClass == null ? hiddenStyle : style + " " + hiddenStyle;
        }
        writer.startElement("div", (UIComponent)tabSet);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        Tab selectedTab = tabSet.findChildTab(tabSet.getSelected());
        String selectedTabText = "";
        if (selectedTab != null) {
            ConversionUtilities.convertValueToString((UIComponent)selectedTab, selectedTab.getText());
        }
        Object[] args = new String[]{selectedTabText};
        SkipHyperlink skipLink = new SkipHyperlink();
        skipLink.setId(tabSet.getId() + "skipLink");
        skipLink.setDescription(theme.getMessage("tab.skipTagAltText", args));
        skipLink.encodeBegin(context);
        List level2Tabs = this.renderLevel(context, tabSet, writer, 1, tabSet.getChildren());
        if (level2Tabs != null && (level3Tabs = this.renderLevel(context, tabSet, writer, 2, level2Tabs)) != null) {
            this.renderLevel(context, tabSet, writer, 3, level3Tabs);
        }
        skipLink.encodeEnd(context);
    }

    protected List renderLevel(FacesContext context, TabSet tabSet, ResponseWriter writer, int level, List currentLevelTabs) throws IOException {
        int numTabs = currentLevelTabs.size();
        if (numTabs == 0) {
            return null;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String selectedTabId = tabSet.getSelected();
        if (selectedTabId == null) {
            try {
                selectedTabId = ((UIComponent)tabSet.getChildren().get(0)).getId();
                tabSet.setSelected(selectedTabId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        List nextLevelToRender = null;
        String divStyle = "";
        String tableStyle = "";
        String linkStyle = "";
        String selectedTdStyle = "";
        String selectedTextStyle = "";
        String hidden = theme.getStyleClass("hidden");
        switch (level) {
            case 1: {
                if (tabSet.isMini()) {
                    divStyle = theme.getStyleClass("MniTabDiv");
                    tableStyle = theme.getStyleClass("MniTabTbl");
                    linkStyle = theme.getStyleClass("MniTabLnk");
                    selectedTdStyle = theme.getStyleClass("MniTabTblSelTd");
                    selectedTextStyle = theme.getStyleClass("MniTabSelTxt");
                    break;
                }
                divStyle = theme.getStyleClass("Tab1Div");
                tableStyle = theme.getStyleClass("Tab1Tbl3New");
                linkStyle = theme.getStyleClass("Tab1Lnk");
                selectedTdStyle = theme.getStyleClass("Tab1TblSelTd");
                selectedTextStyle = theme.getStyleClass("Tab1SelTxtNew");
                break;
            }
            case 2: {
                divStyle = theme.getStyleClass("Tab2Div");
                tableStyle = theme.getStyleClass("Tab2Tbl3New");
                linkStyle = theme.getStyleClass("Tab2Lnk");
                selectedTdStyle = theme.getStyleClass("Tab2TblSelTd");
                selectedTextStyle = theme.getStyleClass("Tab2SelTxt");
                break;
            }
            case 3: {
                divStyle = theme.getStyleClass("Tab3Div");
                tableStyle = theme.getStyleClass("Tab3TblNew");
                linkStyle = theme.getStyleClass("Tab3Lnk");
                selectedTdStyle = theme.getStyleClass("Tab3TblSelTd");
                selectedTextStyle = theme.getStyleClass("Tab3SelTxt");
            }
        }
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("class", (Object)divStyle, null);
        writer.startElement("table", (UIComponent)tabSet);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("class", (Object)tableStyle, null);
        writer.writeAttribute("title", (Object)"", null);
        writer.startElement("tr", (UIComponent)tabSet);
        MethodBinding binding = tabSet.getActionListener();
        for (int i = 0; i < numTabs; ++i) {
            Tab tab = null;
            try {
                tab = (Tab)currentLevelTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!tab.isRendered()) continue;
            if (binding != null && tab.getActionListener() == null) {
                tab.setActionListener(binding);
            }
            writer.startElement("td", (UIComponent)tabSet);
            String newSelectedClass = null;
            String newNonSelectedClass = null;
            if (!tab.isVisible()) {
                newSelectedClass = selectedTdStyle + " " + hidden;
                newNonSelectedClass = hidden;
            } else {
                newSelectedClass = selectedTdStyle;
                newNonSelectedClass = null;
            }
            if (selectedTabId != null && this.isSelected(tab, selectedTabId)) {
                String label;
                UIComponent parent = tab.getParent();
                if (parent != null && parent instanceof Tab) {
                    ((Tab)parent).setSelectedChildId(tab.getId());
                }
                if ((label = ConversionUtilities.convertValueToString((UIComponent)tab, tab.getText())) == null) {
                    label = "";
                }
                writer.writeAttribute("class", (Object)newSelectedClass, null);
                writer.startElement("div", (UIComponent)tabSet);
                writer.writeAttribute("class", (Object)selectedTextStyle, null);
                String titleString = theme.getMessage("tabSet.selectedTab", new Object[]{label});
                writer.writeAttribute("title", (Object)titleString, null);
                boolean wasDisabled = tab.isDisabled();
                tab.setDisabled(true);
                RenderingUtilities.renderComponent((UIComponent)tab, context);
                tab.setDisabled(wasDisabled);
                writer.endElement("div");
                if (tab.hasTabChildren()) {
                    nextLevelToRender = tab.getChildren();
                }
            } else {
                if (!tab.isVisible()) {
                    writer.writeAttribute("class", (Object)newNonSelectedClass, null);
                }
                tab.setStyleClass(linkStyle);
                RenderingUtilities.renderComponent((UIComponent)tab, context);
            }
            writer.endElement("td");
            if (selectedTabId == null || level != 3 || i >= numTabs - 1) continue;
            Tab nextTab = (Tab)currentLevelTabs.get(i + 1);
            if (!nextTab.isRendered()) {
                try {
                    nextTab = (Tab)currentLevelTabs.get(i + 2);
                }
                catch (IndexOutOfBoundsException e) {
                    nextTab = null;
                }
            }
            if (nextTab == null || tab.getId().equals(selectedTabId) || nextTab.getId().equals(selectedTabId)) continue;
            String dividerSrc = theme.getIcon("TAB_DIVIDER").getUrl();
            this.writeDivider(tabSet, writer, dividerSrc);
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        return nextLevelToRender;
    }

    protected void writeDivider(TabSet tabSet, ResponseWriter writer, String src) throws IOException {
        writer.startElement("td", (UIComponent)tabSet);
        writer.startElement("img", (UIComponent)tabSet);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)"20", null);
        writer.writeAttribute("width", (Object)"5", null);
        writer.endElement("img");
        writer.endElement("td");
    }

    protected boolean isSelected(Tab tab, String selectedTabId) {
        if (tab.getId().equals(selectedTabId)) {
            return true;
        }
        List subTabs = tab.getChildren();
        boolean descendantSelected = false;
        for (int i = 0; i < subTabs.size(); ++i) {
            Tab subTab = null;
            try {
                subTab = (Tab)subTabs.get(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            descendantSelected = this.isSelected(subTab, selectedTabId);
            if (descendantSelected) break;
        }
        return descendantSelected;
    }
}

