/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Table;
import com.sun.rave.web.ui.component.TableColumn;
import com.sun.rave.web.ui.component.TableFooter;
import com.sun.rave.web.ui.component.TableRowGroup;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableFooterRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"abbr", "align", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableFooter footer = (TableFooter)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, footer, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableFooter footer = (TableFooter)component;
        ResponseWriter writer = context.getResponseWriter();
        if (footer.isGroupFooter()) {
            this.renderGroupFooter(context, footer, writer);
        } else if (footer.isTableColumnFooter()) {
            this.renderTableColumnFooter(context, footer, writer);
        } else if (footer.isTableFooter()) {
            this.renderTableFooter(context, footer, writer);
        } else {
            this.renderColumnFooter(context, footer, writer);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableFooter footer = (TableFooter)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagEnd(context, footer, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderColumnFooter(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderColumnFooter", "Cannot render column footer, TableFooter is null");
            return;
        }
        TableColumn col = component.getTableColumnAncestor();
        UIComponent uIComponent = facet = col != null ? component.getFacet("footer") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)this.getTheme().getStyleClass("TblGrpColFtrTxt"), null);
            if (col != null && col.getFooterText() != null) {
                writer.writeText((Object)col.getFooterText(), null);
            }
            writer.endElement("span");
        }
    }

    protected void renderGroupFooter(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderGroupFooter", "Cannot render group footer, TableFooter is null");
            return;
        }
        TableRowGroup group = component.getTableRowGroupAncestor();
        UIComponent uIComponent = facet = group != null ? group.getFacet("footer") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)this.getTheme().getStyleClass("TblGrpFtrRowTxt"), null);
            if (group.getFooterText() != null) {
                writer.writeText((Object)group.getFooterText(), null);
            }
            writer.endElement("span");
        }
    }

    protected void renderTableColumnFooter(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        UIComponent facet;
        if (component == null) {
            this.log("renderTableColumnFooter", "Cannot render table column footer, TableFooter is null");
            return;
        }
        TableColumn col = component.getTableColumnAncestor();
        UIComponent uIComponent = facet = col != null ? col.getFacet("tableFooter") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)this.getTheme().getStyleClass("TblColFtrTxt"), null);
            if (col != null && col.getTableFooterText() != null) {
                writer.writeText((Object)col.getTableFooterText(), null);
            }
            writer.endElement("span");
        }
    }

    protected void renderTableFooter(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderTableFooter", "Cannot render table footer, TableFooter is null");
            return;
        }
        Table table = component.getTableAncestor();
        if (table == null) {
            this.log("renderTableFooter", "Cannot render table footer, Table is null");
            return;
        }
        UIComponent facet = table.getFacet("tableFooter");
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            String hiddenSelectionsText;
            Theme theme = this.getTheme();
            String string = hiddenSelectionsText = table.isHiddenSelectedRows() ? theme.getMessage("table.hiddenSelections", new String[]{Integer.toString(table.getHiddenSelectedRowsCount())}) : null;
            if (hiddenSelectionsText != null && table.getFooterText() != null) {
                writer.startElement("span", (UIComponent)component);
                writer.writeAttribute("class", (Object)theme.getStyleClass("TblFtrLft"), null);
                writer.writeText((Object)table.getFooterText(), null);
                writer.endElement("span");
                writer.startElement("span", (UIComponent)component);
                writer.writeAttribute("class", (Object)theme.getStyleClass("TblFtrMsgSpn"), null);
                writer.writeText((Object)hiddenSelectionsText, null);
                writer.endElement("span");
            } else {
                writer.startElement("span", (UIComponent)component);
                writer.writeAttribute("class", (Object)theme.getStyleClass("TblFtrRowTxt"), null);
                writer.writeText((Object)(table.getFooterText() != null ? table.getFooterText() : hiddenSelectionsText), null);
                writer.endElement("span");
            }
        }
    }

    protected void renderEnclosingTagStart(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, TableFooter is null");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String extraHtml = RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, this.getStyleClass(component), component.getExtraHtml());
        if (component.getColSpan() > -1 && (extraHtml == null || extraHtml.indexOf("colspan=") == -1)) {
            writer.writeAttribute("colspan", (Object)Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1 && (extraHtml == null || extraHtml.indexOf("rowspan=") == -1)) {
            writer.writeAttribute("rowspan", (Object)Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap() && (extraHtml == null || extraHtml.indexOf("nowrap=") == -1)) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if (component.getToolTip() != null && (extraHtml == null || extraHtml.indexOf("title=") == -1)) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, stringAttributes, extraHtml);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TableFooter component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagEnd", "Cannot render enclosing tag, TableFooter is null");
            return;
        }
        writer.endElement("td");
    }

    private String getStyleClass(TableFooter component) {
        TableColumn col;
        String styleClass = null;
        if (component == null) {
            this.log("getStyleClass", "Cannot obtain style class, TableFooter is null");
            return styleClass;
        }
        styleClass = component.isTableFooter() ? "TblFtrRow" : (component.isGroupFooter() ? "TblGrpFtrRow" : ((col = component.getTableColumnAncestor()) != null && col.isSpacerColumn() ? (component.isTableColumnFooter() ? "TblColFtrSpc" : "TblTdSpc") : (component.getSortLevel() == 1 ? (component.isTableColumnFooter() ? "TblColFtrSrt" : "TblGrpColFtrSrt") : (component.isTableColumnFooter() ? "TblColFtr" : "TblGrpColFtr"))));
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

