/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.theme;

import com.sun.rave.web.ui.component.Icon;
import com.sun.rave.web.ui.theme.ThemeConfigurationException;
import com.sun.rave.web.ui.util.ClassLoaderFinder;
import com.sun.rave.web.ui.util.ClientSniffer;
import com.sun.rave.web.ui.util.ClientType;
import com.sun.rave.web.ui.util.MessageUtil;
import java.beans.Beans;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class Theme {
    private ResourceBundle bundle = null;
    private ResourceBundle fallbackBundle = null;
    private ResourceBundle classMapper = null;
    private ResourceBundle imageResources = null;
    private ResourceBundle jsFiles = null;
    private ResourceBundle stylesheets = null;
    private String[] globalJSFiles = null;
    private String[] globalStylesheets = null;
    public static final String THEME_ATTR = "com.sun.rave.web.ui.Theme";
    public static final String RESOURCE_PATH_ATTR = "com.sun.web.console.resource_path";
    private static final String HEIGHT_SUFFIX = "_HEIGHT";
    private static final String WIDTH_SUFFIX = "_WIDTH";
    private static final String GLOBAL_JSFILES = "global";
    private static final String GLOBAL_STYLESHEETS = "global";
    private static final String MASTER_STYLESHEET = "master";
    private String prefix = null;
    private String path = null;
    private Locale locale = null;
    private boolean realServer = !Beans.isDesignTime();
    private static final boolean DEBUG = false;

    public Theme(Locale locale) {
        this.locale = locale;
    }

    public String[] getGlobalJSFiles() {
        if (this.globalJSFiles == null) {
            try {
                String files = this.jsFiles.getString("global");
                StringTokenizer tokenizer = new StringTokenizer(files, " ");
                String pathKey = null;
                String path = null;
                ArrayList<String> fileNames = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    pathKey = tokenizer.nextToken();
                    path = this.jsFiles.getString(pathKey);
                    fileNames.add(this.translateURI(path));
                }
                int numFiles = fileNames.size();
                this.globalJSFiles = new String[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    this.globalJSFiles[i] = fileNames.get(i).toString();
                }
            }
            catch (MissingResourceException npe) {
                this.globalJSFiles = new String[0];
            }
        }
        return this.globalJSFiles;
    }

    public String[] getGlobalStylesheets() {
        if (this.globalStylesheets == null) {
            try {
                String files = this.stylesheets.getString("global");
                StringTokenizer tokenizer = new StringTokenizer(files, " ");
                String pathKey = null;
                String path = null;
                ArrayList<String> fileNames = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    pathKey = tokenizer.nextToken();
                    path = this.stylesheets.getString(pathKey);
                    fileNames.add(this.translateURI(path));
                }
                int numFiles = fileNames.size();
                this.globalStylesheets = new String[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    this.globalStylesheets[i] = fileNames.get(i).toString();
                }
            }
            catch (MissingResourceException npe) {
                this.globalStylesheets = new String[0];
            }
        }
        return this.globalStylesheets;
    }

    public String getPathToJSFile(String key) {
        String path = this.jsFiles.getString(key);
        return this.translateURI(path);
    }

    public String getPathToStylesheet(FacesContext context) {
        ClientType clientType = ClientSniffer.getClientType(context);
        try {
            String path = this.stylesheets.getString(clientType.toString());
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuffer msgBuffer = new StringBuffer("Could not find propery ");
            msgBuffer.append(clientType.toString());
            msgBuffer.append(" in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    public String getPathToMasterStylesheet() {
        try {
            String path = this.stylesheets.getString(MASTER_STYLESHEET);
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuffer msgBuffer = new StringBuffer("Could not find master ");
            msgBuffer.append("stylesheet in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    public String getPathToStylesheet(String clientName) {
        try {
            String path = this.stylesheets.getString(clientName);
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuffer msgBuffer = new StringBuffer("Could not find propery ");
            msgBuffer.append(clientName);
            msgBuffer.append(" in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    public String getStyleClass(String name) {
        if (this.classMapper == null) {
            return name;
        }
        String styleClass = this.classMapper.getString(name);
        return styleClass == null ? name : styleClass;
    }

    public String getMessage(String key) {
        String message = null;
        try {
            message = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            try {
                message = this.fallbackBundle.getString(key);
            }
            catch (NullPointerException npe) {
                throw mre;
            }
        }
        return message;
    }

    public String getMessage(String key, Object[] params) {
        String message = this.getMessage(key);
        MessageFormat mf = new MessageFormat(message, this.locale);
        return mf.format(params);
    }

    protected void setPrefix(String p) {
        this.prefix = p;
    }

    protected void configureClassMapper(ResourceBundle classMapper) {
        this.classMapper = classMapper;
    }

    protected void configureMessages(ResourceBundle base, ResourceBundle override) {
        if (override == null) {
            this.bundle = base;
        } else {
            this.bundle = override;
            this.fallbackBundle = base;
        }
    }

    protected void configureImages(ResourceBundle imageResources) {
        this.imageResources = imageResources;
    }

    protected void configureJSFiles(ResourceBundle jsFiles) {
        this.jsFiles = jsFiles;
    }

    protected void configureStylesheets(ResourceBundle stylesheets) {
        this.stylesheets = stylesheets;
    }

    private String translateURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        if (this.path == null) {
            this.initializePath();
        }
        if (this.realServer) {
            return this.path.concat(uri);
        }
        ClassLoader loader = ClassLoaderFinder.getCurrentLoader(Theme.class);
        if (Beans.isDesignTime()) {
            uri = uri.startsWith("/") ? uri.substring(1) : uri;
        }
        URL url = loader.getResource(uri);
        return url.toString();
    }

    private void initializePath() {
        FacesContext context = FacesContext.getCurrentInstance();
        Object consolePath = context.getExternalContext().getApplicationMap().get(RESOURCE_PATH_ATTR);
        if (consolePath == null) {
            this.path = context.getApplication().getViewHandler().getResourceURL(context, this.prefix);
            return;
        }
        Object request = context.getExternalContext().getRequest();
        String protocol = null;
        String server = null;
        if (!(request instanceof ServletRequest)) {
            String message = "REquest opbject is " + request.getClass().getName();
            throw new RuntimeException(message);
        }
        ServletRequest sr = (ServletRequest)request;
        protocol = sr.getScheme();
        server = sr.getServerName();
        int port = sr.getServerPort();
        URL url = null;
        try {
            url = new URL(protocol, server, port, consolePath.toString().concat(this.prefix));
        }
        catch (MalformedURLException mue) {
            throw new ThemeConfigurationException("Couldn't figure out resource path");
        }
        this.path = url.toString();
    }

    public void initializePath(ServletContext context, HttpServletRequest request) {
        if (this.path != null) {
            return;
        }
        String pathString = null;
        Object consolePath = context.getAttribute(RESOURCE_PATH_ATTR);
        if (consolePath == null) {
            pathString = request.getContextPath();
        } else {
            pathString = consolePath.toString();
            if (pathString.length() > 0 && !pathString.startsWith("/")) {
                pathString = "/".concat(this.path);
            }
        }
        this.path = pathString.concat(this.prefix);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Icon getIcon(String identifier) {
        Icon icon = new Icon();
        icon.setIcon(identifier);
        if (identifier != null) {
            String path = null;
            try {
                path = this.imageResources.getString(identifier);
            }
            catch (MissingResourceException mre) {
                Object[] params = new Object[]{identifier};
                String message = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Theme.noIcon", params);
                throw new RuntimeException(message, mre);
            }
            path = this.translateURI(path);
            icon.setUrl(path);
            try {
                String height = this.imageResources.getString(identifier.concat(HEIGHT_SUFFIX));
                int ht = Integer.parseInt(height);
                icon.setHeight(ht);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                String width = this.imageResources.getString(identifier.concat(WIDTH_SUFFIX));
                int wt = Integer.parseInt(width);
                icon.setWidth(wt);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return icon;
    }
}

