/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.util;

import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class RenderingUtilities {
    public static final String NL = "/n";
    public static final String SCRIPT = "script";
    public static final String TYPE = "type";
    public static final String SRC = "src";
    public static final String MEDIA = "text/javascript";
    public static final String SJWUIC_JSFILE = "sjwuic_jsfile";
    public static final String USCORE = "_";
    public static final String COLON = ":";
    public static final char USCORE_CHAR = '_';
    public static final char COLON_CHAR = ':';
    private static final String newJsId = "var {0} = new {1}(''{2}'');";
    private static final String newJsIdAndArgs = "var {0} = new {1}(''{2}'',{3});";

    public static void renderComponent(UIComponent component, FacesContext context) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String id = component.getId();
        if (id != null) {
            component.setId(id);
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                RenderingUtilities.renderComponent(kid, context);
            }
        }
        component.encodeEnd(context);
    }

    public static void writeStringAttributes(UIComponent component, ResponseWriter writer, String[] possibleAttributes) throws IOException {
        Map attributes = component.getAttributes();
        int numNames = possibleAttributes.length;
        String attributeName = null;
        for (int counter = 0; counter < numNames; ++counter) {
            attributeName = possibleAttributes[counter];
            Object attributeValue = attributes.get(attributeName);
            if (attributeValue == null) continue;
            writer.writeAttribute(attributeName.toLowerCase(), (Object)String.valueOf(attributeValue), attributeName);
        }
    }

    public static void writeStringAttributes(UIComponent component, ResponseWriter writer, String[] names, String extraHtml) throws IOException {
        if (component == null || names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            Object value;
            if (extraHtml != null && (extraHtml.indexOf(names[i] + "=") == 0 || extraHtml.indexOf(" " + names[i] + "=") != -1) || (value = attributes.get(names[i])) == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(names[i].toLowerCase(), (Object)((String)value), names[i]);
                continue;
            }
            writer.writeAttribute(names[i].toLowerCase(), (Object)value.toString(), names[i]);
        }
        RenderingUtilities.renderExtraHtmlAttributes(writer, extraHtml);
    }

    public static void renderHiddenField(UIComponent component, ResponseWriter writer, String id, String value) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("An f:param tag had a null name attribute");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute(TYPE, (Object)"hidden", null);
        writer.endElement("input");
    }

    public static String getStyleClasses(FacesContext context, UIComponent component, String styles) {
        boolean componentNotVisible;
        String styleClass = (String)component.getAttributes().get("styleClass");
        boolean bl = componentNotVisible = !RenderingUtilities.isVisible(component);
        if (componentNotVisible) {
            String hiddenStyleClass = ThemeUtilities.getTheme(context).getStyleClass("hidden");
            styleClass = styleClass != null ? styleClass + " " + hiddenStyleClass : hiddenStyleClass;
        }
        if (styleClass != null) {
            if (styles != null) {
                return styleClass + " " + styles;
            }
            return styleClass;
        }
        if (styles != null) {
            return styles;
        }
        return null;
    }

    public static void renderStyleClass(FacesContext context, ResponseWriter writer, UIComponent component, String extraStyles) throws IOException {
        String classes = RenderingUtilities.getStyleClasses(context, component, extraStyles);
        if (classes != null) {
            writer.writeAttribute("class", (Object)classes, "styleClass");
        }
    }

    public static String renderStyleClass(FacesContext context, ResponseWriter writer, UIComponent component, String styleClass, String extraHtml) throws IOException {
        if (styleClass != null) {
            int first = -1;
            if (extraHtml != null && (first = extraHtml.indexOf("class=")) != -1) {
                try {
                    int quote = first + 6;
                    char ch = extraHtml.charAt(quote);
                    int last = extraHtml.indexOf(ch, quote + 1);
                    String s = extraHtml.substring(first, last + 1);
                    extraHtml = extraHtml.replaceAll(s, "");
                    s = s.substring(7, s.length() - 1);
                    styleClass = s + " " + styleClass;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            RenderingUtilities.renderStyleClass(context, writer, component, styleClass);
        }
        return extraHtml;
    }

    public static String getJavascriptId(FacesContext context, UIComponent component) {
        String client = component.getClientId(context);
        return client.replace(':', '_');
    }

    public static boolean isPortlet(FacesContext context) {
        return !(context.getExternalContext().getContext() instanceof ServletContext);
    }

    public static String getLastClientID(FacesContext context) {
        return (String)context.getExternalContext().getRequestMap().get("com.sun.rave.web.ui_body_focusComponent");
    }

    public static void setLastClientID(FacesContext context, String clientId) {
        context.getExternalContext().getRequestMap().put("com.sun.rave.web.ui_body_focusComponent", clientId);
    }

    public static void renderSpacer(ResponseWriter writer, UIComponent component, String dotSrc, int height, int width) throws IOException {
        if (height == 0 && width == 0) {
            return;
        }
        writer.startElement("img", component);
        writer.writeAttribute(SRC, (Object)dotSrc, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)new Integer(height), null);
        writer.writeAttribute("width", (Object)new Integer(width), null);
        writer.endElement("img");
    }

    public static void renderSpacer(FacesContext context, ResponseWriter writer, UIComponent component, int height, int width) throws IOException {
        if (height == 0 && width == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String dotSrc = theme.getIcon("DOT").getUrl();
        RenderingUtilities.renderSpacer(writer, component, dotSrc, height, width);
    }

    public static void renderJavaScript(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        String[] javascripts = theme.getGlobalJSFiles();
        for (int i = 0; i < javascripts.length; ++i) {
            writer.startElement(SCRIPT, component);
            writer.writeAttribute(TYPE, (Object)MEDIA, null);
            writer.writeURIAttribute(SRC, (Object)javascripts[i], null);
            writer.endElement(SCRIPT);
            writer.write("\n");
        }
    }

    public static void renderStyleSheetLink(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        String browserSS;
        String master = theme.getPathToMasterStylesheet();
        if (master != null) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute(TYPE, (Object)"text/css", null);
            writer.writeURIAttribute("href", (Object)master, null);
            writer.endElement("link");
            writer.write("\n");
        }
        if ((browserSS = theme.getPathToStylesheet(context)) != null) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute(TYPE, (Object)"text/css", null);
            writer.writeURIAttribute("href", (Object)browserSS, null);
            writer.endElement("link");
            writer.write("\n");
        }
        String[] stylesheets = theme.getGlobalStylesheets();
        for (int i = 0; i < stylesheets.length; ++i) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute(TYPE, (Object)"text/css", null);
            writer.writeURIAttribute("href", (Object)stylesheets[i], null);
            writer.endElement("link");
            writer.write("\n");
        }
    }

    public static void renderStyleSheetInline(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        String browserSS;
        writer.startElement("style", component);
        writer.writeAttribute(TYPE, (Object)"text/css", null);
        writer.write("\n");
        String master = theme.getPathToMasterStylesheet();
        if (master != null) {
            writer.write("@import(\"");
            writer.write(master);
            writer.write("\");");
            writer.write("\n");
        }
        if ((browserSS = theme.getPathToStylesheet(context)) != null) {
            writer.write("@import(\"");
            writer.write(browserSS);
            writer.write("\");");
            writer.write("\n");
        }
        String[] stylesheets = theme.getGlobalStylesheets();
        for (int i = 0; i < stylesheets.length; ++i) {
            writer.write("@import(\"");
            writer.write(stylesheets[i]);
            writer.write("\");");
            writer.write("\n");
        }
        writer.endElement("style");
    }

    public static void includeJsp(FacesContext context, ResponseWriter writer, String jspURI) throws IOException {
        if (jspURI == null) {
            return;
        }
        try {
            if (!jspURI.startsWith("/")) {
                String contextPath = context.getExternalContext().getRequestContextPath();
                jspURI = contextPath.concat("/").concat(jspURI);
            }
            ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
            ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
            RequestDispatcher rd = request.getRequestDispatcher(jspURI);
            class ResponseWrapper
            extends HttpServletResponseWrapper {
                private PrintWriter printWriter;

                public ResponseWrapper(HttpServletResponse response, Writer writer) {
                    super(response);
                    this.printWriter = new PrintWriter(writer);
                }

                public PrintWriter getWriter() {
                    return this.printWriter;
                }

                public ServletOutputStream getOutputStream() throws IOException {
                    throw new IllegalStateException();
                }

                public void resetBuffer() {
                }
            }
            rd.include(request, (ServletResponse)new ResponseWrapper((HttpServletResponse)response, (Writer)writer));
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static boolean renderJsInclude(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String includeFile) throws IOException {
        String jsFile;
        if (includeFile == null) {
            return false;
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, String> jsFileMap = (HashMap<String, String>)requestMap.get(SJWUIC_JSFILE);
        if (jsFileMap == null) {
            jsFileMap = new HashMap<String, String>();
            requestMap.put(SJWUIC_JSFILE, jsFileMap);
        }
        if ((jsFile = (String)jsFileMap.get(includeFile)) != null) {
            return true;
        }
        jsFile = theme.getPathToJSFile(includeFile);
        if (jsFile == null) {
            return false;
        }
        jsFileMap.put(includeFile, jsFile);
        writer.startElement(SCRIPT, component);
        writer.writeAttribute(TYPE, (Object)MEDIA, null);
        writer.writeURIAttribute(SRC, (Object)jsFile, null);
        writer.endElement(SCRIPT);
        return true;
    }

    public static boolean renderJsObject(FacesContext context, UIComponent component, ResponseWriter writer, String objectName, String jsObjectClass, String arguments) throws IOException {
        String clientId;
        if (context == null || component == null || writer == null || jsObjectClass == null) {
            return false;
        }
        if (objectName == null) {
            objectName = jsObjectClass;
        }
        if ((clientId = component.getClientId(context)) == null) {
            return false;
        }
        String jsObject = RenderingUtilities.getJsObjectName(clientId, objectName);
        String format = arguments != null ? newJsIdAndArgs : newJsId;
        Object[] args = new Object[]{jsObject, jsObjectClass, clientId, arguments};
        writer.startElement(SCRIPT, component);
        writer.writeAttribute(TYPE, (Object)MEDIA, null);
        writer.writeText((Object)MessageFormat.format(format, args), null);
        writer.endElement(SCRIPT);
        return true;
    }

    public static String getJsObjectName(FacesContext context, UIComponent component, String objectPrefix) {
        return RenderingUtilities.getJsObjectName(component.getClientId(context), objectPrefix);
    }

    public static String getJsObjectName(String clientId, String objectPrefix) {
        return objectPrefix.concat(USCORE).concat(clientId.replace(':', '_'));
    }

    public static void renderExtraHtmlAttributes(ResponseWriter writer, String extraHtml) throws IOException {
        if (extraHtml == null) {
            return;
        }
        int n = extraHtml.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char quote;
            StringBuffer name = new StringBuffer();
            StringBuffer value = new StringBuffer();
            while (i < n && Character.isWhitespace(extraHtml.charAt(i))) {
                ++i;
            }
            while (i < n) {
                char c2 = extraHtml.charAt(i);
                if (c2 == '\'' || c2 == '\"') {
                    return;
                }
                if (c2 == '=') break;
                name.append(c2);
                ++i;
            }
            char c3 = quote = ++i < n ? extraHtml.charAt(i) : (char)'\u0000';
            if (quote != '\'' && quote != '\"') {
                return;
            }
            ++i;
            while (i < n && (c = extraHtml.charAt(i)) != quote) {
                value.append(c);
                ++i;
            }
            writer.writeAttribute(name.toString(), (Object)value.toString(), null);
        }
    }

    public static void renderURLAttribute(FacesContext context, ResponseWriter writer, UIComponent component, String name, String url, String compPropName) throws IOException {
        if (url == null) {
            return;
        }
        Param[] paramList = RenderingUtilities.getParamList(context, component);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int len = paramList.length;
        sb = new StringBuffer();
        sb.append(url);
        if (0 < len) {
            sb.append("?");
        }
        for (i = 0; i < len; ++i) {
            if (0 != i) {
                sb.append("&");
            }
            sb.append(paramList[i].getName());
            sb.append("=");
            sb.append(paramList[i].getValue());
        }
        String newName = null;
        if (compPropName != null) {
            String string = newName = compPropName.equals(name) ? null : compPropName;
        }
        if (url.trim().length() != 0) {
            writer.writeURIAttribute(name, (Object)context.getExternalContext().encodeResourceURL(sb.toString()), newName);
        } else {
            writer.writeURIAttribute(name, (Object)"", newName);
        }
    }

    protected static Param[] getParamList(FacesContext context, UIComponent command) {
        ArrayList<Param> parameterList = new ArrayList<Param>();
        Iterator kids = command.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            Object value = uiParam.getValue();
            Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
            parameterList.add(param);
        }
        return parameterList.toArray(new Param[parameterList.size()]);
    }

    public static void renderSkipLink(String anchorName, String styleClass, String style, String toolTip, Integer tabIndex, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        writer.startElement("div", component);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)styleClass, null);
        }
        writer.write("\n");
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("#");
        buffer.append(component.getClientId(context));
        buffer.append(USCORE);
        buffer.append(anchorName);
        writer.startElement("a", component);
        writer.writeAttribute("href", (Object)buffer.toString(), null);
        if (toolTip != null) {
            writer.writeAttribute("alt", (Object)toolTip, null);
        }
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", (Object)tabIndex.toString(), null);
        }
        writer.write("\n");
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("div");
    }

    public static void renderAnchor(String anchorName, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(component.getClientId(context));
        buffer.append(USCORE);
        buffer.append(anchorName);
        writer.startElement("div", component);
        writer.write("\n");
        writer.startElement("a", component);
        writer.writeAttribute("name", (Object)buffer.toString(), null);
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("div");
    }

    public static boolean isVisible(UIComponent component) {
        Object visible = component.getAttributes().get("visible");
        if (visible == null) {
            return true;
        }
        return (Boolean)visible;
    }

    protected static class Param {
        private String name;
        private String value;

        public Param(String name, String value) {
            this.set(name, value);
        }

        public void set(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

