/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.util;

import com.sun.rave.web.ui.component.util.descriptors.LayoutComponent;
import com.sun.rave.web.ui.component.util.descriptors.LayoutElement;
import com.sun.rave.web.ui.util.ClientSniffer;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

public class VariableResolver {
    private static Map dataSourceMap = new HashMap();
    public static final String ATTRIBUTE = "attribute";
    public static final String PROPERTY = "property";
    public static final String HAS_PROPERTY = "hasProperty";
    public static final String HAS_FACET = "hasFacet";
    public static final String SESSION = "session";
    public static final String STYLE = "style";
    public static final String THEME = "theme";
    public static final String THEME_JS = "themeScript";
    public static final String REQUEST_PARAMETER = "requestParameter";
    public static final String THIS = "this";
    public static final String ESCAPE = "escape";
    public static final String BOOLEAN = "boolean";
    public static final String BROWSER = "browser";
    public static final String INT = "int";
    public static final String METHOD_BINDING = "methodBinding";
    public static final String CONSTANT = "constant";
    public static final String RESOURCE = "resource";
    private static Class[] actionArgs;
    public static final String SUB_START = "$";
    public static final String SUB_TYPE_DELIM = "{";
    public static final String SUB_END = "}";

    public static Object resolveVariables(FacesContext ctx, LayoutElement desc, UIComponent component, String string, String startToken, String typeDelim, String endToken) {
        int stringLen = string.length();
        int startTokenLen = startToken.length();
        int delimLen = typeDelim.length();
        int endTokenLen = endToken.length();
        boolean expressionIsWholeString = false;
        char firstEndChar = SUB_END.charAt(0);
        char firstDelimChar = SUB_TYPE_DELIM.charAt(0);
        int startIndex = string.lastIndexOf(startToken);
        while (startIndex != -1) {
            int delimIndex = string.indexOf(typeDelim, startIndex + startTokenLen);
            if (delimIndex != -1) {
                int parenSemi = 0;
                int endIndex = -1;
                int curr = delimIndex + delimLen;
                while (curr < stringLen) {
                    char currChar = string.charAt(curr);
                    if (currChar == firstDelimChar && typeDelim.equals(string.substring(curr, curr + delimLen))) {
                        ++parenSemi;
                        curr += delimLen;
                        continue;
                    }
                    if (currChar == firstEndChar && endToken.equals(string.substring(curr, curr + endTokenLen))) {
                        if (--parenSemi < 0) {
                            endIndex = curr;
                            break;
                        }
                        curr += endTokenLen;
                        continue;
                    }
                    ++curr;
                }
                if (endIndex != -1) {
                    String type;
                    DataSource ds;
                    if (startIndex == 0 && endIndex == string.lastIndexOf(endToken) && string.endsWith(endToken)) {
                        expressionIsWholeString = true;
                    }
                    if ((ds = (DataSource)dataSourceMap.get(type = string.substring(startIndex + startTokenLen, delimIndex))) == null) {
                        throw new IllegalArgumentException("Invalid type '" + type + "' in attribute value: '" + string + "'.");
                    }
                    Object variable = string.substring(delimIndex + delimLen, endIndex);
                    variable = ds.getValue(ctx, desc, component, (String)variable);
                    if (expressionIsWholeString) {
                        return variable;
                    }
                    string = string.substring(0, startIndex) + (variable == null ? "" : variable.toString()) + string.substring(endIndex + endTokenLen);
                    stringLen = string.length();
                }
            }
            startIndex = string.lastIndexOf(startToken, startIndex - 1);
        }
        return string;
    }

    public static Object resolveVariables(LayoutElement desc, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        return VariableResolver.resolveVariables(FacesContext.getCurrentInstance(), desc, component, value);
    }

    public static Object resolveVariables(FacesContext ctx, LayoutElement desc, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            value = VariableResolver.resolveVariables(ctx, desc, component, (String)value, SUB_START, SUB_TYPE_DELIM, SUB_END);
        } else if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            ArrayList<Object> newList = new ArrayList<Object>(size);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                newList.add(VariableResolver.resolveVariables(ctx, desc, component, it.next()));
            }
            return newList;
        }
        return value;
    }

    public static DataSource getDataSource(String key) {
        return (DataSource)dataSourceMap.get(key);
    }

    public static void setDataSource(String key, DataSource dataSource) {
        dataSourceMap.put(key, dataSource);
    }

    public static void main(String[] args) {
        String test = null;
        String good = null;
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(LayoutElement))", SUB_START, "(", ")");
        good = "LayoutElement";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager))", SUB_START, "(", ")");
        good = "EEPersistenceManager";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$es$cape$escape(EEPersistenceManager))", SUB_START, "(", ")");
        good = "$es$capeEEPersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escapeEEP$ersistenceManager))", SUB_START, "(", ")");
        good = "$escapeEEP$ersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager)))", SUB_START, "(", ")");
        good = "EEPersistenceManager)";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape(EEPersistenceManager())", SUB_START, "(", ")");
        good = "$escape(EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, "(", ")");
        good = "EEPersistenceManager()==EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
        test = "" + VariableResolver.resolveVariables(null, null, null, "$escape($escape($escape(EEPersistenceManager()))==$escape(EEPersistenceManager()))", SUB_START, "(", ")");
        good = "EEPersistenceManager()==EEPersistenceManager()";
        System.out.println("Expected Result: '" + good + "'");
        System.out.println("         Result: '" + test + "'");
        if (!test.equals(good)) {
            System.out.println("FAILED!!!!");
        }
    }

    static {
        AttributeDataSource attrDS = new AttributeDataSource();
        dataSourceMap.put(ATTRIBUTE, attrDS);
        dataSourceMap.put("", attrDS);
        dataSourceMap.put(PROPERTY, new PropertyDataSource());
        dataSourceMap.put(HAS_PROPERTY, new HasPropertyDataSource());
        dataSourceMap.put(HAS_FACET, new HasFacetDataSource());
        dataSourceMap.put(SESSION, new SessionDataSource());
        dataSourceMap.put(STYLE, new StyleDataSource());
        dataSourceMap.put(THEME, new ThemeDataSource());
        dataSourceMap.put(THEME_JS, new ThemeJavaScriptDataSource());
        dataSourceMap.put(REQUEST_PARAMETER, new RequestParameterDataSource());
        dataSourceMap.put(THIS, new ThisDataSource());
        dataSourceMap.put(ESCAPE, new EscapeDataSource());
        dataSourceMap.put(INT, new IntDataSource());
        dataSourceMap.put(BOOLEAN, new BooleanDataSource());
        dataSourceMap.put(BROWSER, new BrowserDataSource());
        dataSourceMap.put(CONSTANT, new ConstantDataSource());
        dataSourceMap.put(RESOURCE, new ResourceBundleDataSource());
        dataSourceMap.put(METHOD_BINDING, new MethodBindingDataSource());
        actionArgs = new Class[]{ActionEvent.class};
    }

    public static class ThisDataSource
    implements DataSource {
        public static final String COMPONENT = "component";
        public static final String CLIENT_ID = "clientId";
        public static final String ID = "id";
        public static final String LAYOUT_ELEMENT = "layoutElement";
        public static final String PARENT = "parent";
        public static final String PARENT_ID = "parentId";
        public static final String PARENT_CLIENT_ID = "parentClientId";
        public static final String PARENT_LAYOUT_ELEMENT = "parentLayoutElement";
        public static final String NAMING_CONTAINER = "namingContainer";
        public static final String VALUE_BINDING = "valueBinding";

        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent comp, String key) {
            Object value = null;
            if (key.equalsIgnoreCase(CLIENT_ID) || key.length() == 0) {
                value = comp.getClientId(ctx);
            } else if (key.equalsIgnoreCase(ID)) {
                value = comp.getId();
            } else if (key.equalsIgnoreCase(COMPONENT)) {
                value = comp;
            } else if (key.equalsIgnoreCase(LAYOUT_ELEMENT)) {
                value = desc;
            } else if (key.equalsIgnoreCase(PARENT_ID)) {
                value = comp.getParent().getId();
            } else if (key.equalsIgnoreCase(PARENT_CLIENT_ID)) {
                value = comp.getParent().getClientId(ctx);
            } else if (key.equalsIgnoreCase(PARENT)) {
                value = comp.getParent();
            } else if (key.equalsIgnoreCase(PARENT_LAYOUT_ELEMENT)) {
                value = desc.getParent();
            } else if (key.equalsIgnoreCase(NAMING_CONTAINER)) {
                value = comp.getParent();
                while (value != null && !(value instanceof NamingContainer)) {
                    value = ((UIComponent)value).getParent();
                }
            } else if (key.equalsIgnoreCase(VALUE_BINDING)) {
                Stack<String> stack = new Stack<String>();
                String id = null;
                for (comp = comp.getParent(); comp != null && !(comp instanceof UIViewRoot); comp = comp.getParent()) {
                    id = comp.getId();
                    if (id == null) {
                        id = comp.getClientId(ctx);
                        id = id.substring(id.lastIndexOf(58) + 1);
                    }
                    stack.push(id);
                }
                StringBuffer buf = new StringBuffer();
                buf.append("view");
                while (!stack.empty()) {
                    buf.append("." + stack.pop());
                }
                value = buf.toString();
            } else {
                throw new IllegalArgumentException("'" + key + "' is not valid in $this{" + key + "}.");
            }
            return value;
        }
    }

    public static class ThemeJavaScriptDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ThemeUtilities.getTheme(ctx).getPathToJSFile(key);
        }
    }

    public static class ThemeDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ThemeUtilities.getTheme(ctx).getMessage(key);
        }
    }

    public static class StyleDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ThemeUtilities.getTheme(ctx).getStyleClass(key);
        }
    }

    public static class SessionDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getSessionMap().get(key);
        }
    }

    public static class ResourceBundleDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            int separator = key.indexOf(".");
            if (separator == -1) {
                throw new IllegalArgumentException("'" + key + "' is not in format: \"[bundleID].[bundleKey]\"!");
            }
            String value = key.substring(0, separator);
            ResourceBundle bundle = (ResourceBundle)ctx.getExternalContext().getRequestMap().get(value);
            if (bundle == null) {
                return key;
            }
            value = bundle.getString(key.substring(separator + 1));
            if (value == null) {
                value = key;
            }
            return value;
        }
    }

    public static class MethodBindingDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getApplication().createMethodBinding(key, actionArgs);
        }
    }

    public static class ConstantDataSource
    implements DataSource {
        private static Map constantMap = new HashMap();

        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            Object value = constantMap.get(key);
            if (value == null) {
                HashMap map = new HashMap(constantMap);
                value = this.resolveValue(map, key);
                constantMap = map;
            }
            return value;
        }

        private Object resolveValue(Map map, String key) {
            int lastDot = key.lastIndexOf(46);
            if (lastDot == -1) {
                throw new IllegalArgumentException("Unable to resolve '" + key + "' in $constant{" + key + "}.  '" + key + "' must be a " + "fully qualified classname plus the constant name.");
            }
            String className = key.substring(0, lastDot);
            try {
                this.addConstants(map, Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("'" + className + "' was not found!  This must be a valid " + "classname.  This was found in expression $constant{" + key + "}.");
                iae.initCause(ex);
                throw iae;
            }
            return map.get(key);
        }

        private void addConstants(Map map, Class cls) {
            String className = cls.getName();
            Field[] fields = cls.getFields();
            Field field = null;
            for (int count = 0; count < fields.length; ++count) {
                field = fields[count];
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                try {
                    map.put(className + '.' + field.getName(), field.get(null));
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static class IntDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return Integer.valueOf(key);
        }
    }

    public static class BrowserDataSource
    implements DataSource {
        private static Map innerDataSources = new HashMap();

        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            DataSource ds = (DataSource)innerDataSources.get(key);
            if (ds == null) {
                throw new IllegalArgumentException("'" + key + "' is not a valid key for BrowserDataSource!");
            }
            return ds.getValue(ctx, desc, component, key);
        }

        static {
            innerDataSources.put("getUserAgent", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).getUserAgent();
                }
            });
            innerDataSources.put("getUserAgentMajor", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return new Integer(ClientSniffer.getInstance(ctx).getUserAgentMajor());
                }
            });
            innerDataSources.put("isIe", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe();
                }
            });
            innerDataSources.put("isNav", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav();
                }
            });
            innerDataSources.put("isGecko", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isGecko();
                }
            });
            innerDataSources.put("isSun", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isSun();
                }
            });
            innerDataSources.put("isWin", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isWin();
                }
            });
            innerDataSources.put("isIe5up", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe5up();
                }
            });
            innerDataSources.put("isIe6up", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe6up();
                }
            });
            innerDataSources.put("isNav7up", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav7up();
                }
            });
            innerDataSources.put("isIe6", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe6();
                }
            });
            innerDataSources.put("isIe5", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe5();
                }
            });
            innerDataSources.put("isIe4", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe4();
                }
            });
            innerDataSources.put("isIe3", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isIe3();
                }
            });
            innerDataSources.put("isNav70", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav70();
                }
            });
            innerDataSources.put("isNav7", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav7();
                }
            });
            innerDataSources.put("isNav6up", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav6up();
                }
            });
            innerDataSources.put("isNav6", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav6();
                }
            });
            innerDataSources.put("isNav4up", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav4up();
                }
            });
            innerDataSources.put("isNav4", new DataSource(){

                public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
                    return ClientSniffer.getInstance(ctx).isNav4();
                }
            });
        }
    }

    public static class BooleanDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return Boolean.valueOf(key);
        }
    }

    public static class EscapeDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return key;
        }
    }

    public static class HasFacetDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            boolean hasFacet = component.getFacets().containsKey(key);
            if (!hasFacet && desc instanceof LayoutComponent) {
                return this.getValue(ctx, desc.getParent(), component.getParent(), key);
            }
            return hasFacet;
        }
    }

    public static class HasPropertyDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            boolean hasKey = component.getAttributes().containsKey(key);
            if (!hasKey && component.getAttributes().get(key) != null) {
                hasKey = true;
            }
            if (!hasKey && desc instanceof LayoutComponent) {
                return this.getValue(ctx, desc.getParent(), component.getParent(), key);
            }
            return hasKey;
        }
    }

    public static class PropertyDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            int idx = key.indexOf(44);
            boolean walk = false;
            if (idx > 0) {
                walk = Boolean.valueOf(key.substring(idx + 1));
                key = key.substring(0, idx);
            }
            Object value = component.getAttributes().get(key);
            while (walk && value == null && component.getParent() != null) {
                component = component.getParent();
                value = component.getAttributes().get(key);
            }
            return value;
        }
    }

    public static class RequestParameterDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getRequestParameterMap().get(key);
        }
    }

    public static class AttributeDataSource
    implements DataSource {
        public Object getValue(FacesContext ctx, LayoutElement desc, UIComponent component, String key) {
            return ctx.getExternalContext().getRequestMap().get(key);
        }
    }

    public static interface DataSource {
        public Object getValue(FacesContext var1, LayoutElement var2, UIComponent var3, String var4);
    }
}

