/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.utils.FortranReader;
import org.netbeans.modules.cnd.api.utils.UnexpectedEOFException;

public class FortranParser {
    private FortranReader in;
    private boolean verbose = false;

    public FortranParser(String string, String string2, boolean bl, boolean bl2) {
        this.verbose = bl;
        try {
            this.in = new FortranReader(string, string2, bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.in = null;
        }
    }

    public FortranParser(String string, String string2) {
        this(string, string2, false, false);
    }

    public ArrayList parser() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.in == null) {
            return null;
        }
        try {
            String string;
            while ((string = this.in.getStatement()) != null) {
                String string2;
                if (string.length() >= 15 && string.substring(0, 15).equalsIgnoreCase("moduleprocedure")) continue;
                if (string.length() >= 6 && string.substring(0, 6).equalsIgnoreCase("module")) {
                    string2 = this.getName(string.substring(6));
                    arrayList.add("M" + string2);
                    continue;
                }
                if (string.length() < 3 || !string.substring(0, 3).equalsIgnoreCase("use")) continue;
                string2 = this.getName(string.substring(3));
                arrayList.add("U" + string2);
            }
        }
        catch (UnexpectedEOFException unexpectedEOFException) {
            if (this.verbose) {
                System.err.println("Error: Unexpected EOF");
                unexpectedEOFException.printStackTrace();
            }
            return null;
        }
        return arrayList;
    }

    private String getName(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.trim();
        for (int i = 0; i < string2.length() && ((c = string2.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_'); ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        FortranParser fortranParser = null;
        boolean bl = false;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-v")) {
                bl = true;
                continue;
            }
            string = stringArray[i];
        }
        fortranParser = new FortranParser(string, null);
        fortranParser.verbose = bl;
        ArrayList arrayList = fortranParser.parser();
        System.out.println("FortranParser: list has " + arrayList.size() + " elements");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i).toString();
            if (string2.charAt(0) == 'M') {
                System.out.println("\tModule " + string2.substring(1));
                continue;
            }
            System.out.println("\tUse " + string2.substring(1));
        }
    }
}

