/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.editor.CppFoldManagerBase;
import org.netbeans.modules.cnd.editor.parser.CppFile;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.CppMetaModel;
import org.netbeans.modules.cnd.editor.parser.ParsingEvent;
import org.netbeans.modules.cnd.editor.parser.ParsingListener;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

final class CppFoldManager
extends CppFoldManagerBase
implements SettingsChangeListener,
Runnable,
ParsingListener {
    private FoldOperation operation;
    private List<BlockFoldInfo> blockFoldInfos = Collections.emptyList();
    private boolean foldIncludesPreset;
    private boolean foldCommentPreset;
    private boolean foldCodeBlocksPreset;
    private boolean foldInitialCommentsPreset;
    private boolean listeningOnParsing;
    private static RequestProcessor cppFoldsRP;
    private static final Logger log;

    private CppFoldManager() {
    }

    private static synchronized RequestProcessor getCppFoldsRP() {
        if (cppFoldsRP == null) {
            cppFoldsRP = new RequestProcessor("CPP-Folds", 1);
        }
        return cppFoldsRP;
    }

    private String getFilename() {
        FoldHierarchy foldHierarchy = this.operation != null ? this.operation.getHierarchy() : null;
        JTextComponent jTextComponent = foldHierarchy != null ? foldHierarchy.getComponent() : null;
        Document document = jTextComponent != null ? jTextComponent.getDocument() : null;
        DataObject dataObject = document != null ? NbEditorUtilities.getDataObject((Document)document) : null;
        String string = dataObject != null ? FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()) : null;
        return string;
    }

    private String getShortName() {
        String string = (String)this.getDocument().getProperty("title");
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private BlockFoldInfo findBlockFoldInfo(BlockFoldInfo blockFoldInfo) {
        if (blockFoldInfo == null) {
            return null;
        }
        for (BlockFoldInfo blockFoldInfo2 : this.blockFoldInfos) {
            if (blockFoldInfo2.equals(blockFoldInfo)) {
                return blockFoldInfo2;
            }
            if (!blockFoldInfo2.after(blockFoldInfo)) continue;
            return null;
        }
        return null;
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    private void removeFoldNotify(Fold fold) {
        log.log(Level.FINE, "CppFoldManager.removeFoldNotify");
    }

    private synchronized void updateFolds() {
        log.log(Level.FINE, "CFM.updateFolds: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
        final UpdateFoldsRequest updateFoldsRequest = this.collectFoldUpdates();
        if (updateFoldsRequest == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!CppFoldManager.this.getOperation().isReleased()) {
                    Document document = CppFoldManager.this.getDocument();
                    if (!(document instanceof AbstractDocument)) {
                        return;
                    }
                    log.log(Level.FINE, "CFM.updateFolds$X1.run: Processing " + CppFoldManager.this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readLock();
                    try {
                        FoldHierarchy foldHierarchy = CppFoldManager.this.getOperation().getHierarchy();
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = CppFoldManager.this.getOperation().openTransaction();
                            try {
                                log.log(Level.FINE, "CFM.updateFolds$X1.run: Calling processUpdateFoldRequest for " + CppFoldManager.this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                                CppFoldManager.this.processUpdateFoldRequest(updateFoldsRequest, foldHierarchyTransaction);
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
            }
        };
        log.log(Level.FINE, "CFM.updateFolds: Starting update for " + this.getShortName() + " on AWT thread");
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateFoldsRequest collectFoldUpdates() {
        log.log(Level.FINE, "CFM.collectFoldUpdates: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
        Document document = this.getDocument();
        if (this.getOperation().isReleased() || !(document instanceof AbstractDocument)) {
            log.log(Level.FINE, "CFM.collectFoldUpdates: No doc found for " + this.getShortName());
            return null;
        }
        CppFile cppFile = CppMetaModel.getDefault().get(document.getProperty("title").toString());
        if (cppFile == null) {
            return null;
        }
        cppFile.waitScanFinished(1);
        if (cppFile.isParsingFailed()) {
            return null;
        }
        UpdateFoldsRequest updateFoldsRequest = new UpdateFoldsRequest();
        AbstractDocument abstractDocument = (AbstractDocument)document;
        abstractDocument.readLock();
        try {
            updateFoldsRequest.addBlockFoldInfo(cppFile.getInitialCommentFold());
            for (CppFoldRecord cppFoldRecord : cppFile.getIncludesFolds()) {
                updateFoldsRequest.addBlockFoldInfo(cppFoldRecord);
            }
            for (CppFoldRecord cppFoldRecord : cppFile.getBlockFolds()) {
                updateFoldsRequest.addBlockFoldInfo(cppFoldRecord);
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
        return updateFoldsRequest;
    }

    private void processUpdateFoldRequest(UpdateFoldsRequest updateFoldsRequest, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (updateFoldsRequest != null && updateFoldsRequest.isValid()) {
            log.log(Level.FINE, "CFM.processUpdateFoldRequest: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
            List<BlockFoldInfo> list = updateFoldsRequest.getBlockFoldInfos();
            for (BlockFoldInfo blockFoldInfo : list) {
                BlockFoldInfo blockFoldInfo2 = this.findBlockFoldInfo(blockFoldInfo);
                if (blockFoldInfo2 == null || blockFoldInfo.isUpdateRequired(blockFoldInfo2)) {
                    if (blockFoldInfo2 != null) {
                        blockFoldInfo2.removeFromHierarchy(foldHierarchyTransaction);
                        this.blockFoldInfos.remove(blockFoldInfo2);
                    }
                    try {
                        blockFoldInfo.addToHierarchy(foldHierarchyTransaction);
                    }
                    catch (BadLocationException badLocationException) {}
                    continue;
                }
                this.blockFoldInfos.remove(blockFoldInfo2);
                blockFoldInfo.fold = blockFoldInfo2.fold;
            }
            for (BlockFoldInfo blockFoldInfo : this.blockFoldInfos) {
                blockFoldInfo.removeFromHierarchy(foldHierarchyTransaction);
            }
            this.blockFoldInfos = list;
        }
    }

    Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    DataObject getDataObject() {
        Document document = this.getDocument();
        return document != null ? NbEditorUtilities.getDataObject((Document)document) : null;
    }

    public void run() {
        try {
            if (new File(this.getFilename()).exists()) {
                log.log(Level.FINE, "CFM.run: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                if (!this.listeningOnParsing) {
                    log.log(Level.FINE, "CFM.run: Processing " + this.getShortName() + " [" + Thread.currentThread().getName() + "]");
                    this.listeningOnParsing = true;
                    log.log(Level.FINE, "CFM.run: Starting WeakParsingListener [" + Thread.currentThread().getName() + "]");
                    new WeakParsingListener(this).startListening();
                }
                log.log(Level.FINE, "CFM.run: Calling updateFolds [" + Thread.currentThread().getName() + "]");
                this.updateFolds();
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        this.settingsChange(null);
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            log.log(Level.FINE, "CFM.initFolds: Posting for " + this.getShortName() + " on Cpp Folds RP [" + Thread.currentThread().getName() + "]");
            CppFoldManager.getCppFoldsRP().post((Runnable)this, 1000, 1);
        }
    }

    private void scheduleParsing(Document document) {
        log.log(Level.FINE, "TitleProperty: " + document.getProperty("title"));
        if (document.getProperty("title") != null) {
            CppMetaModel.getDefault().scheduleParsing(document);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        log.log(Level.FINE, "FoldManager.insertUpdate: " + documentEvent.getDocument().toString());
        this.scheduleParsing(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        log.log(Level.FINE, "FoldManager.removeUpdate");
        this.scheduleParsing(documentEvent.getDocument());
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        log.log(Level.FINE, "FoldManager.changeUpdate");
    }

    void removeFoldInfo(Fold fold) {
        Iterator<BlockFoldInfo> iterator = this.blockFoldInfos.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().fold != fold) continue;
            iterator.remove();
            break;
        }
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeFoldNotify(fold);
        this.removeFoldInfo(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.removeFoldNotify(fold);
        this.removeFoldInfo(fold);
    }

    public void expandNotify(Fold fold) {
    }

    public void release() {
    }

    public void objectParsed(ParsingEvent parsingEvent) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)parsingEvent.getSource();
        String string = this.getFilename();
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            String string2 = FileUtil.getFileDisplayName((FileObject)fileObject);
            if (string2.equals(string)) {
                log.log(Level.FINE, "CFM.objectParsed: Calling updateFolds for " + this.getShortName());
                this.updateFolds();
            } else {
                log.log(Level.FINE, "CFM.objectParsed: Skipping updateFolds");
            }
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass((JTextComponent)this.operation.getHierarchy().getComponent());
        this.foldInitialCommentsPreset = SettingsUtil.getBoolean((Class)clazz, (String)"code-folding-collapse-initial-comment", (boolean)false);
        this.foldIncludesPreset = SettingsUtil.getBoolean((Class)clazz, (String)"code-folding-collapse-import", (boolean)false);
        this.foldCodeBlocksPreset = SettingsUtil.getBoolean((Class)clazz, (String)"code-folding-collapse-method", (boolean)false);
        this.foldCommentPreset = SettingsUtil.getBoolean((Class)clazz, (String)"code-folding-collapse-javadoc", (boolean)false);
    }

    static {
        log = Logger.getLogger(CppFoldManager.class.getName());
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new CppFoldManager();
        }
    }

    private static final class WeakParsingListener
    implements ParsingListener {
        private WeakReference<ParsingListener> ref;

        WeakParsingListener(ParsingListener parsingListener) {
            this.ref = new WeakReference<ParsingListener>(parsingListener);
        }

        public void startListening() {
            CppMetaModel.getDefault().addParsingListener(this);
        }

        public void objectParsed(ParsingEvent parsingEvent) {
            ParsingListener parsingListener = (ParsingListener)this.ref.get();
            if (parsingListener != null) {
                parsingListener.objectParsed(parsingEvent);
            } else {
                CppMetaModel.getDefault().removeParsingListener(this);
            }
        }
    }

    private final class BlockFoldInfo {
        private Fold fold = null;
        private final CppFoldManagerBase.FoldTemplate template;
        private final int type;
        private final boolean collapse;
        private final int startOffset;
        private final int endOffset;

        public BlockFoldInfo(CppFoldRecord cppFoldRecord) throws BadLocationException {
            this.startOffset = cppFoldRecord.getStartOffset();
            this.endOffset = cppFoldRecord.getEndOffset();
            this.type = cppFoldRecord.getType();
            switch (cppFoldRecord.getType()) {
                case 1: {
                    this.template = CppFoldManagerBase.INITIAL_COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldInitialCommentsPreset;
                    break;
                }
                case 4: {
                    this.template = CppFoldManagerBase.INCLUDES_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldIncludesPreset;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.template = CppFoldManagerBase.CODE_BLOCK_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCodeBlocksPreset;
                    break;
                }
                case 2: {
                    this.template = CppFoldManagerBase.COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCommentPreset;
                    break;
                }
                case 3: {
                    this.template = CppFoldManagerBase.LINE_COMMENT_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                case 5: {
                    this.template = CppFoldManagerBase.IFDEF_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                default: {
                    assert (false) : "unsupported block type " + cppFoldRecord;
                    this.collapse = false;
                    this.template = null;
                }
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof BlockFoldInfo)) {
                return false;
            }
            BlockFoldInfo blockFoldInfo = (BlockFoldInfo)object;
            return this.template == blockFoldInfo.template && this.getRealStartOffset() == blockFoldInfo.getRealStartOffset();
        }

        public boolean after(BlockFoldInfo blockFoldInfo) {
            return this.getRealStartOffset() > blockFoldInfo.getRealEndOffset();
        }

        public boolean isUpdateRequired(BlockFoldInfo blockFoldInfo) {
            assert (this.equals(blockFoldInfo)) : "only equal orig can be here";
            return blockFoldInfo.fold == null || this.getRealEndOffset() != blockFoldInfo.getRealEndOffset();
        }

        private int getRealStartOffset() {
            if (this.fold != null) {
                return this.fold.getStartOffset();
            }
            return this.startOffset;
        }

        private int getRealEndOffset() {
            if (this.fold != null) {
                return this.fold.getEndOffset();
            }
            return this.endOffset;
        }

        public void addToHierarchy(FoldHierarchyTransaction foldHierarchyTransaction) throws BadLocationException {
            if (FoldOperation.isBoundsValid((int)this.startOffset, (int)this.endOffset, (int)this.template.getStartGuardedLength(), (int)this.template.getEndGuardedLength())) {
                log.log(Level.FINE, "CFM.BlockFoldInfo.updateHierarchy: Creating fold at (" + this.startOffset + ", " + this.endOffset + ")");
                this.fold = CppFoldManager.this.getOperation().addToHierarchy(this.template.getType(), this.template.getDescription(), this.collapse, this.startOffset, this.endOffset, this.template.getStartGuardedLength(), this.template.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
            }
        }

        public void removeFromHierarchy(FoldHierarchyTransaction foldHierarchyTransaction) {
            FoldOperation foldOperation;
            if (this.fold != null && (foldOperation = CppFoldManager.this.getOperation()).isAddedOrBlocked(this.fold)) {
                foldOperation.removeFromHierarchy(this.fold, foldHierarchyTransaction);
            }
        }

        public String toString() {
            return "BlockFoldInfo:" + this.template.getType() + " at[" + this.getRealStartOffset() + "," + this.getRealEndOffset() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UpdateFoldsRequest {
        private final Document creationTimeDoc;
        private final List<BlockFoldInfo> blockFoldInfos = new LinkedList<BlockFoldInfo>();

        UpdateFoldsRequest() {
            this.creationTimeDoc = CppFoldManager.this.getDocument();
        }

        boolean isValid() {
            return this.creationTimeDoc != null && this.creationTimeDoc == CppFoldManager.this.getDocument();
        }

        List<BlockFoldInfo> getBlockFoldInfos() {
            return this.blockFoldInfos;
        }

        void addBlockFoldInfo(CppFoldRecord cppFoldRecord) {
            if (cppFoldRecord != null) {
                try {
                    this.blockFoldInfos.add(new BlockFoldInfo(cppFoldRecord));
                }
                catch (BadLocationException badLocationException) {
                    log.log(Level.FINE, "CFM.addBlockFoldInfo: Got BadLocationException\n    " + badLocationException.getMessage());
                }
            }
        }
    }
}

