/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public abstract class ViewNode
extends AbstractNode {
    private Line line = null;
    private DataObject dao = null;
    private int lineno = 0;
    private char kind;
    private String scope;
    private int scopeCluster;
    private int cluster;
    private String sortName;
    private int scopeLevels = 0;

    public ViewNode(String string, DataObject dataObject, int n, char c, String string2, int n2, int n3) {
        super(Children.LEAF);
        this.dao = dataObject;
        this.lineno = n;
        this.kind = c;
        this.scope = string2;
        this.scopeCluster = n2;
        this.cluster = n3;
        this.setName(string);
        if (string2 != null) {
            this.sortName = this.createSortScope(string2) + "::" + n3 + string;
            this.setDisplayName(string);
        } else {
            this.sortName = n3 + string;
            this.setDisplayName(string);
        }
    }

    private String createSortScope(String string) {
        String string2 = "";
        if (string == null) {
            this.scopeLevels = 0;
            string2 = "";
        } else {
            int n;
            this.scopeLevels = 1;
            int n2 = 0;
            while ((n = string.indexOf("::", n2)) >= 0) {
                string2 = string2 + this.scopeCluster + string.substring(n2, n) + "::";
                ++this.scopeLevels;
                n2 = n + 2;
            }
            string2 = string2 + this.scopeCluster + string.substring(n2);
        }
        return string2;
    }

    public String getSortName() {
        return this.sortName;
    }

    public int getScopeLevel() {
        return this.scopeLevels;
    }

    public String getScope() {
        return this.scope;
    }

    public int getScopeCluster() {
        return this.scopeCluster;
    }

    public int getCluster() {
        return this.cluster;
    }

    public Line getLine() {
        if (this.line == null) {
            this.line = this.lineNumberToLine();
        }
        if (this.line == null) {
            ErrorManager.getDefault().notify((Throwable)new Exception("No Line info for line " + this.lineno + " in " + this.dao.getPrimaryFile().getNameExt()));
        }
        return this.line;
    }

    public int getLineNo() {
        return this.lineno;
    }

    public void goToLine() {
        this.getLine().show(2);
    }

    private Line lineNumberToLine() {
        Line.Set set;
        LineCookie lineCookie = (LineCookie)this.dao.getCookie(LineCookie.class);
        Line line = null;
        if (lineCookie != null && (set = lineCookie.getLineSet()) != null) {
            line = set.getCurrent(this.lineno - 1);
        }
        return line;
    }

    public int getLineOffset() {
        EditorCookie editorCookie = (EditorCookie)this.dao.getCookie(EditorCookie.class);
        assert (editorCookie != null);
        return NbDocument.findLineOffset((StyledDocument)editorCookie.getDocument(), (int)(this.lineno - 1));
    }

    public void goToOffset(JEditorPane jEditorPane) {
        jEditorPane.getCaret().setDot(this.getLineOffset());
        jEditorPane.requestFocus();
    }

    public char getKind() {
        return this.kind;
    }

    public DataObject getDataObject() {
        return this.dao;
    }
}

