/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.execution.NativeExecution;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LocalNativeExecution
extends NativeExecution {
    private static File stdOutErrFile = null;
    private static boolean hasWarned = false;
    private File runDirFile;
    private static ResourceBundle bundle = NbBundle.getBundle(LocalNativeExecution.class);
    private OutputReaderThread outputReaderThread = null;
    private InputReaderThread inputReaderThread = null;
    private Process executionProcess = null;
    private PrintWriter out;

    public int executeCommand(File file, String string, String string2, String[] stringArray, PrintWriter printWriter, Reader reader) throws IOException, InterruptedException {
        int n = -1;
        this.runDirFile = file;
        this.out = printWriter;
        if (!file.exists() || !file.isDirectory()) {
            String string3 = MessageFormat.format(LocalNativeExecution.getString("NOT_A_VALID_BUILD_DIRECTORY"), file.getPath());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return -1;
        }
        String string4 = LocalNativeExecution.getStdOutErrFile().getPath();
        String string5 = string + " " + string2;
        NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string4, string5);
        ArrayList<Object> arrayList = stringArray != null ? new ArrayList<String>(Arrays.asList(stringArray)) : new ArrayList<String>();
        arrayList.add("SPRO_EXPAND_ERRORS=");
        stringArray = arrayList.toArray(new String[0]);
        this.executionProcess = nbProcessDescriptor.exec(null, stringArray, true, file);
        this.outputReaderThread = new OutputReaderThread(this.executionProcess.getErrorStream(), printWriter);
        this.outputReaderThread.start();
        if (reader != null) {
            this.inputReaderThread = new InputReaderThread(this.executionProcess.getOutputStream(), reader);
            this.inputReaderThread.start();
        } else {
            this.inputReaderThread = null;
        }
        try {
            n = this.executionProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.executionProcess.destroy();
            while (n < 0) {
                try {
                    n = this.executionProcess.waitFor();
                }
                catch (InterruptedException interruptedException2) {}
            }
        }
        try {
            this.outputReaderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n;
    }

    public void stop() {
        this.outputReaderThread.cancel();
    }

    public static File getStdOutErrFile() {
        if (stdOutErrFile == null) {
            String string = Utilities.isUnix() ? "bin/stdouterr.sh" : "bin\\stdouterr.bat";
            stdOutErrFile = InstalledFileLocator.getDefault().locate(string, null, false);
            if (stdOutErrFile == null && !hasWarned) {
                String string2 = MessageFormat.format(LocalNativeExecution.getString("CANNOT_FIND_SCRIPT"), string);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                hasWarned = true;
            }
        }
        return stdOutErrFile;
    }

    private static String getString(String string) {
        return bundle.getString(string);
    }

    private static final class InputReaderThread
    extends Thread {
        private Reader in;
        private OutputStream pout;

        public InputReaderThread(OutputStream outputStream, Reader reader) {
            this.pout = outputStream;
            this.in = reader;
            this.setName("inputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    this.pout.write((char)n);
                    this.pout.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.pout.flush();
                    this.pout.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static final class OutputReaderThread
    extends Thread {
        private Reader err;
        private Writer output;
        private boolean cancel = false;

        public OutputReaderThread(InputStream inputStream, Writer writer) {
            this.err = new InputStreamReader(inputStream);
            this.output = writer;
            this.setName("OutputReaderThread");
        }

        public void run() {
            try {
                int n;
                while ((n = this.err.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    if (n == 10) {
                        this.output.write("\n");
                        continue;
                    }
                    this.output.write((char)n);
                }
                this.output.flush();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

