/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWindowWriter
extends Writer {
    private OutputWriter delegate;
    private StringBuffer buffer;
    private boolean parseOutputForErrors;
    private static final String LINE_SEPARATOR_QUOTED = System.getProperty("line.separator");
    private final ErrorParser[] parsers;
    private static final Pattern SS_OF_1 = Pattern.compile("::\\(.*\\)");
    private static final Pattern SS_OF_2 = Pattern.compile(":\\(.*\\).*");
    private static final Pattern SS_OF_3 = Pattern.compile("\\(.*\\).*:");
    private static final Pattern[] SunStudioOutputFilters = new Pattern[]{SS_OF_1, SS_OF_2, SS_OF_3};
    private static final int LENGTH_TRESHOLD = 2048;
    private static final Pattern CW_ERROR_SCANNER = Pattern.compile("([^:\n]*):([0-9]+): .*");
    private static final Pattern MSVC_WARNING_SCANNER = Pattern.compile("([a-zA-Z0-0\\\\._]+)\\(([0-9]+)\\) : warning ([a-zA-Z0-9]+): .*");
    private static final Pattern MSVC_ERROR_SCANNER = Pattern.compile("([a-zA-Z0-0\\\\._]+)\\(([0-9]+)\\) : error ([a-zA-Z0-9]+): .*");
    private static final Pattern GCC_ERROR_SCANNER = Pattern.compile("([a-zA-Z]:[^:\n]*|[^:\n]*):([^:\n]*):([^:\n]*):([^\n]*)");
    private static final Pattern GCC_ERROR_SCANNER_ANOTHER = Pattern.compile("([^:\n]*):([0-9]+): ([a-zA-Z]*):*.*");
    private static final Pattern GCC_ERROR_SCANNER_INTEL = Pattern.compile("([^\\(\n]*)\\(([0-9]+)\\): ([^:\n]*): ([^\n]*)");
    private static final Pattern GCC_DIRECTORY_ENTER = Pattern.compile("[gd]?make\\[([0-9]+)\\]: Entering[\\w+\\s+]+`([^']*)'");
    private static final Pattern GCC_DIRECTORY_LEAVE = Pattern.compile("[gd]?make\\[([0-9]+)\\]: Leaving[\\w+\\s+]+`([^']*)'");
    private static final Pattern GCC_DIRECTORY_CD = Pattern.compile("cd\\s+([\\S]+)[\\s;]");
    private static final Pattern GCC_STACK_HEADER = Pattern.compile("In file included from ([A-Z]:[^:\n]*|[^:\n]*):([^:^,]*)");
    private static final Pattern GCC_STACK_NEXT = Pattern.compile("                 from ([A-Z]:[^:\n]*|[^:\n]*):([^:^,]*)");
    private static final Pattern SUN_ERROR_SCANNER_CPP_ERROR = Pattern.compile("^\"(.*)\", line ([0-9]+): Error:");
    private static final Pattern SUN_ERROR_SCANNER_CPP_WARNING = Pattern.compile("^\"(.*)\", line ([0-9]+): Warning:");
    private static final Pattern SUN_ERROR_SCANNER_C_ERROR = Pattern.compile("^\"(.*)\", line ([0-9]+):");
    private static final Pattern SUN_ERROR_SCANNER_C_WARNING = Pattern.compile("^\"(.*)\", line ([0-9]+): warning:");
    private static final Pattern SUN_ERROR_SCANNER_FORTRAN_ERROR = Pattern.compile("^\"(.*)\", Line = ([0-9]+),");
    private static final Pattern SUN_ERROR_SCANNER_FORTRAN_WARNING = Pattern.compile("^\"(.*)\", Line = ([0-9]+), Column = ([0-9]+): WARNING:");
    private static final Pattern SUN_DIRECTORY_ENTER = Pattern.compile("\\(([^)]*)\\)[^:]*:");

    public OutputWindowWriter(OutputWriter outputWriter, FileObject fileObject, boolean bl) {
        this.delegate = outputWriter;
        this.parseOutputForErrors = bl;
        this.buffer = new StringBuffer();
        this.parsers = new ErrorParser[]{new GCCErrorParser(fileObject), new SUNErrorParser(fileObject), new MSVCErrorParser(fileObject), new CWErrorParser(fileObject)};
        ErrorAnnotation.getInstance().detach(null);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this.buffer.append(new String(cArray, n, n2).replaceAll(LINE_SEPARATOR_QUOTED, "\n"));
        while ((n3 = this.buffer.indexOf("\n")) != -1) {
            this.handleLine(this.buffer.substring(0, n3));
            this.buffer.delete(0, n3 + "\n".length() + 1);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static FileObject resolveFile(String string) {
        if (Utilities.isWindows() && string.startsWith("/cygdrive/")) {
            string = string.substring("/cygdrive/".length());
            string = "" + string.charAt(0) + ':' + string.substring(1);
            string = string.replace('/', File.separatorChar);
        }
        File file = FileUtil.normalizeFile((File)new File(string));
        return FileUtil.toFileObject((File)file);
    }

    private static FileObject resolveRelativePath(FileObject object, String string) {
        Object object2;
        Object object3;
        String string2;
        Object object4;
        if (IpeUtils.isPathAbsolute(string)) {
            if (Utilities.isWindows()) {
                object4 = string;
                string2 = null;
                if (((String)object4).startsWith("/usr/lib")) {
                    string2 = ((String)object4).substring(4);
                }
                object3 = CompilerSetManager.getDefault().getCompilerSets();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    CompilerSet compilerSet = (CompilerSet)object2.next();
                    Tool tool = compilerSet.getTool(0);
                    if (tool == null) continue;
                    String string3 = tool.getIncludeFilePathPrefix();
                    File file = new File(string3 + (String)object4);
                    if (!file.exists() && string2 != null) {
                        file = new File(string3 + string2);
                    }
                    if (!file.exists()) continue;
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    return fileObject;
                }
            }
            if (string.startsWith(File.separator)) {
                string = string.substring(1);
            }
            try {
                object4 = object.getFileSystem();
                string2 = object4.findResource(string);
                if (string2 != null) {
                    return string2;
                }
                string2 = object4.getRoot();
                if (string2 != null) {
                    object = string2;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        object4 = object;
        string2 = Utilities.isWindows() ? File.separator + '/' : File.separator;
        object3 = new StringTokenizer(string, string2);
        while (object4 != null && ((StringTokenizer)object3).hasMoreTokens()) {
            object2 = ((StringTokenizer)object3).nextToken();
            if ("..".equals(object2)) {
                object4 = object4.getParent();
                continue;
            }
            if (".".equals(object2)) continue;
            object4 = object4.getFileObject((String)object2, null);
        }
        return object4;
    }

    private void handleLine(String string) throws IOException {
        if (this.parseOutputForErrors && string.length() < 2048) {
            int n;
            Object object;
            int n2;
            for (n2 = 0; n2 < this.parsers.length; ++n2) {
                object = this.parsers[n2].getPattern();
                for (n = 0; n < ((Pattern[])object).length; ++n) {
                    Object object2 = object[n];
                    Matcher matcher = ((Pattern)object2).matcher(string);
                    boolean bl = matcher.find();
                    if (!bl || matcher.start() != 0 || !this.parsers[n2].handleLine(this.delegate, string, matcher)) continue;
                    return;
                }
            }
            for (n2 = 0; n2 < SunStudioOutputFilters.length; ++n2) {
                object = SunStudioOutputFilters[n2].matcher(string);
                n = ((Matcher)object).find() ? 1 : 0;
                if (n == 0 || ((Matcher)object).start() != 0) continue;
                return;
            }
        }
        this.delegate.println(string);
    }

    private static class ErrorAnnotation
    extends Annotation
    implements PropertyChangeListener {
        private static ErrorAnnotation instance;
        private Line currentLine;

        private ErrorAnnotation() {
        }

        public static ErrorAnnotation getInstance() {
            if (instance == null) {
                instance = new ErrorAnnotation();
            }
            return instance;
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-cnd-error";
        }

        public String getShortDescription() {
            return NbBundle.getMessage(OutputWindowWriter.class, (String)"HINT_CompilerError");
        }

        public void attach(Line line) {
            if (this.currentLine != null) {
                this.detach(this.currentLine);
            }
            this.currentLine = line;
            super.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void detach(Line line) {
            if (line == this.currentLine || line == null) {
                this.currentLine = null;
                Annotatable annotatable = this.getAttachedAnnotatable();
                if (annotatable != null) {
                    annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("text".equals(propertyChangeEvent.getPropertyName())) {
                this.detach(null);
            }
        }
    }

    private static final class SUNErrorParser
    implements ErrorParser {
        private FileObject relativeTo;

        public SUNErrorParser(FileObject fileObject) {
            this.relativeTo = fileObject;
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == SUN_DIRECTORY_ENTER) {
                this.relativeTo = OutputWindowWriter.resolveFile(matcher.group(1));
                return false;
            }
            if (matcher.pattern() == SUN_ERROR_SCANNER_CPP_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_CPP_WARNING || matcher.pattern() == SUN_ERROR_SCANNER_C_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_C_WARNING || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_WARNING) {
                try {
                    boolean bl;
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = OutputWindowWriter.resolveRelativePath(this.relativeTo, string2);
                    boolean bl2 = bl = matcher.pattern() == SUN_ERROR_SCANNER_CPP_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_C_ERROR || matcher.pattern() == SUN_ERROR_SCANNER_FORTRAN_ERROR;
                    if (fileObject != null) {
                        outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), bl);
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{SUN_ERROR_SCANNER_CPP_ERROR, SUN_ERROR_SCANNER_CPP_WARNING, SUN_ERROR_SCANNER_FORTRAN_WARNING, SUN_ERROR_SCANNER_FORTRAN_ERROR, SUN_ERROR_SCANNER_C_WARNING, SUN_ERROR_SCANNER_C_ERROR, SUN_DIRECTORY_ENTER};
        }
    }

    private static final class GCCErrorParser
    implements ErrorParser {
        private Stack<FileObject> relativeTo = new Stack();
        private Stack<Integer> relativeLevel = new Stack();
        private ArrayList<StackIncludeItem> errorInludes = new ArrayList();
        private FileObject relativeToFO;
        private boolean failed;
        private boolean isEntered;

        public GCCErrorParser(FileObject fileObject) {
            this.relativeToFO = fileObject;
            this.relativeTo.push(fileObject);
            this.relativeLevel.push(0);
            this.isEntered = false;
        }

        private void popPath() {
            if (this.relativeTo.size() > 1) {
                this.relativeTo.pop();
            }
        }

        private void popLevel() {
            if (this.relativeLevel.size() > 1) {
                this.relativeLevel.pop();
            }
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == GCC_DIRECTORY_ENTER || matcher.pattern() == GCC_DIRECTORY_LEAVE) {
                int n = Integer.valueOf(matcher.group(1));
                int n2 = this.relativeLevel.peek();
                String fileObject = matcher.group(2);
                if (n > n2) {
                    this.isEntered = true;
                    this.relativeLevel.push(n);
                    this.isEntered = true;
                } else if (n == n2) {
                    this.isEntered = !this.isEntered;
                } else {
                    this.isEntered = false;
                    this.popLevel();
                }
                if (this.isEntered) {
                    FileObject fileObject4;
                    if (!IpeUtils.isPathAbsolute(fileObject) && this.relativeToFO != null && this.relativeToFO.isFolder()) {
                        fileObject = this.relativeToFO.getURL().getPath() + File.separator + fileObject;
                    }
                    if ((fileObject4 = OutputWindowWriter.resolveFile(fileObject)) != null) {
                        this.relativeTo.push(fileObject4);
                    }
                    return false;
                }
                this.popPath();
                return false;
            }
            if (matcher.pattern() == GCC_DIRECTORY_CD) {
                FileObject fileObject;
                String string3 = matcher.group(1);
                if (!IpeUtils.isPathAbsolute(string3) && this.relativeToFO != null && this.relativeToFO.isFolder()) {
                    string3 = this.relativeToFO.getURL().getPath() + File.separator + string3;
                }
                if ((fileObject = OutputWindowWriter.resolveFile(string3)) != null) {
                    this.relativeTo.push(fileObject);
                }
                return false;
            }
            if (matcher.pattern() == GCC_STACK_HEADER) {
                for (StackIncludeItem object : this.errorInludes) {
                    outputWriter.println(object.line);
                }
                this.errorInludes.clear();
                try {
                    FileObject fileObject;
                    String string4 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject2 = this.relativeTo.peek();
                    if (fileObject2 != null && (fileObject = OutputWindowWriter.resolveRelativePath(fileObject2, string4)) != null) {
                        this.errorInludes.add(new StackIncludeItem(fileObject, string, n - 1));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.errorInludes.add(new StackIncludeItem(null, string, 0));
                return true;
            }
            if (matcher.pattern() == GCC_STACK_NEXT) {
                try {
                    FileObject fileObject;
                    String string5 = matcher.group(1);
                    Integer object = Integer.valueOf(matcher.group(2));
                    FileObject fileObject3 = this.relativeTo.peek();
                    if (fileObject3 != null && (fileObject = OutputWindowWriter.resolveRelativePath(fileObject3, string5)) != null) {
                        this.errorInludes.add(new StackIncludeItem(fileObject, string, object - 1));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.errorInludes.add(new StackIncludeItem(null, string, 0));
                return true;
            }
            if (matcher.pattern() == GCC_ERROR_SCANNER || matcher.pattern() == GCC_ERROR_SCANNER_ANOTHER || matcher.pattern() == GCC_ERROR_SCANNER_INTEL) {
                try {
                    String string6 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = this.relativeTo.peek();
                    if (fileObject != null) {
                        boolean bl;
                        FileObject fileObject4 = OutputWindowWriter.resolveRelativePath(fileObject, string6);
                        boolean bl2 = bl = matcher.group(3).indexOf("error") != -1;
                        if (fileObject4 != null) {
                            for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                                if (stackIncludeItem.fo != null) {
                                    outputWriter.println(stackIncludeItem.line, (OutputListener)new OutputListenerImpl(stackIncludeItem.fo, stackIncludeItem.lineNumber), bl);
                                    continue;
                                }
                                outputWriter.println(stackIncludeItem.line);
                            }
                            this.errorInludes.clear();
                            outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject4, n - 1), bl);
                            if (!this.failed) {
                                this.failed = true;
                            }
                            return true;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (StackIncludeItem stackIncludeItem : this.errorInludes) {
                    outputWriter.println(stackIncludeItem.line);
                }
                this.errorInludes.clear();
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{GCC_DIRECTORY_ENTER, GCC_DIRECTORY_LEAVE, GCC_DIRECTORY_CD, GCC_STACK_HEADER, GCC_STACK_NEXT, GCC_ERROR_SCANNER, GCC_ERROR_SCANNER_ANOTHER, GCC_ERROR_SCANNER_INTEL};
        }

        private static class StackIncludeItem {
            private FileObject fo;
            private String line;
            private int lineNumber;

            private StackIncludeItem(FileObject fileObject, String string, int n) {
                this.fo = fileObject;
                this.line = string;
                this.lineNumber = n;
            }
        }
    }

    private static final class MSVCErrorParser
    implements ErrorParser {
        private FileObject relativeTo;
        private boolean failed;

        public MSVCErrorParser(FileObject fileObject) {
            this.relativeTo = fileObject;
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == MSVC_ERROR_SCANNER || matcher.pattern() == MSVC_WARNING_SCANNER) {
                try {
                    boolean bl;
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = this.relativeTo.getFileSystem().getRoot().getFileObject(string2);
                    if (fileObject == null) {
                        return false;
                    }
                    boolean bl2 = bl = matcher.pattern() == MSVC_ERROR_SCANNER;
                    if (fileObject != null) {
                        outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), bl);
                        if (!this.failed) {
                            this.failed = true;
                        }
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return false;
            }
            throw new IllegalArgumentException("Unknown pattern: " + matcher.pattern().pattern());
        }

        public Pattern[] getPattern() {
            return new Pattern[]{MSVC_WARNING_SCANNER, MSVC_ERROR_SCANNER};
        }
    }

    private static final class CWErrorParser
    implements ErrorParser {
        private FileObject relativeTo;
        private boolean failed;

        public CWErrorParser(FileObject fileObject) {
            this.relativeTo = fileObject;
        }

        public boolean handleLine(OutputWriter outputWriter, String string, Matcher matcher) throws IOException {
            if (matcher.pattern() == CW_ERROR_SCANNER) {
                try {
                    String string2 = matcher.group(1);
                    Integer n = Integer.valueOf(matcher.group(2));
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(FileUtil.toFile((FileObject)this.relativeTo), string2)));
                    if (fileObject == null) {
                        return false;
                    }
                    outputWriter.println(string, (OutputListener)new OutputListenerImpl(fileObject, n - 1), true);
                    if (!this.failed) {
                        this.failed = true;
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public Pattern[] getPattern() {
            return new Pattern[]{CW_ERROR_SCANNER};
        }
    }

    private static interface ErrorParser {
        public boolean handleLine(OutputWriter var1, String var2, Matcher var3) throws IOException;

        public Pattern[] getPattern();
    }

    private static final class OutputListenerImpl
    implements OutputListener {
        private FileObject file;
        private int line;

        public OutputListenerImpl(FileObject fileObject, int n) {
            this.file = fileObject;
            this.line = n;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.showLine();
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.showLine();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            ErrorAnnotation.getInstance().detach(null);
        }

        private void showLine() {
            block5: {
                try {
                    DataObject dataObject = DataObject.find((FileObject)this.file);
                    LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                    if (lineCookie == null) break block5;
                    try {
                        Line line = lineCookie.getLineSet().getOriginal(this.line);
                        if (!line.isDeleted()) {
                            line.show(2);
                            ErrorAnnotation.getInstance().attach(line);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        }
    }
}

