/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class MakeTargetPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -8864738441088422274L;
    private JPanel panel;
    private GridBagConstraints grid;
    Insets insets;
    private JTextField targetName;
    private JTextField dependsOn;
    private JTextField subdirectory;
    private JTextField makeFlags;
    private JTextArea commandDisplay;
    private boolean enableCommandSelection;
    private String tname;
    private String depends;
    private String subdir;
    private String mflags;
    private int row;
    private boolean initialized;
    private int key;

    MakeTargetPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = new String(this.getString("LBL_MakeTargetPanel"));
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        this.insets = new Insets(10, 0, 0, 0);
        this.grid = new GridBagConstraints();
        this.grid.anchor = 18;
        this.grid.insets = this.insets;
        this.tname = new String("");
        this.depends = new String("");
        this.subdir = new String("");
        this.mflags = new String("");
        this.row = 0;
        JPanel jPanel = this.createTextFields();
        this.insets.top = 0;
        this.insets.left = 0;
        this.grid.gridx = 0;
        this.grid.gridy = 0;
        this.grid.insets = this.insets;
        this.add((Component)jPanel, this.grid);
        Dimension dimension = jPanel.getPreferredSize();
        Dimension dimension2 = this.getPreferredSize();
        Dimension dimension3 = new Dimension(dimension2.width, dimension2.height - dimension.height);
        this.createCommandDisplay(dimension3, "LBL_CommandDisplay", "MNEM_CommandDisplay");
        this.setupListeners();
    }

    private JPanel createTextFields() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.targetName = this.createTextField(jPanel, "LBL_TargetName", "MNEM_TargetName");
        this.dependsOn = this.createTextField(jPanel, "LBL_DependsOn", "MNEM_DependsOn");
        this.subdirectory = this.createTextField(jPanel, "LBL_Subdirectory", "MNEM_Subdirectory");
        this.makeFlags = this.createTextField(jPanel, "LBL_MakeFlags", "MNEM_MakeFlags");
        return jPanel;
    }

    private JTextField createTextField(JPanel jPanel, String string, String string2) {
        JLabel jLabel = new JLabel(this.getString(string));
        JTextField jTextField = new JTextField();
        this.insets.left = 0;
        this.grid.gridx = 0;
        this.grid.gridy = this.row++;
        this.grid.gridwidth = 1;
        this.grid.weightx = 0.0;
        jPanel.add((Component)jLabel, this.grid);
        this.insets.left = 5;
        this.grid.gridx = 1;
        this.grid.gridwidth = 0;
        this.grid.weightx = 1.0;
        this.grid.fill = 2;
        jPanel.add((Component)jTextField, this.grid);
        jLabel.setDisplayedMnemonic(this.getString(string2).charAt(0));
        jLabel.setLabelFor(jTextField);
        return jTextField;
    }

    private void createCommandDisplay(Dimension dimension, String string, String string2) {
        JLabel jLabel = new JLabel(this.getString(string));
        jLabel.setDisplayedMnemonic(this.getString(string2).charAt(0));
        this.insets.top = 16;
        this.grid.gridx = 0;
        this.grid.gridy = 1;
        this.grid.gridwidth = 1;
        this.add((Component)jLabel, this.grid);
        dimension.setSize(dimension.getWidth(), dimension.getHeight() - (double)this.insets.top - jLabel.getPreferredSize().getHeight());
        this.commandDisplay = new JTextArea();
        this.commandDisplay.setEditable(false);
        this.commandDisplay.setBackground(this.getBackground());
        this.commandDisplay.addFocusListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.commandDisplay);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        dimension.height = dimension.height - this.insets.top - jLabel.getPreferredSize().height;
        jScrollPane.setPreferredSize(dimension);
        jLabel.setLabelFor(this.commandDisplay);
        this.insets.top = 0;
        this.grid.gridy = 2;
        this.grid.gridwidth = 0;
        this.grid.gridheight = 0;
        this.add((Component)jScrollPane, this.grid);
        this.enableCommandSelection = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.enableCommandSelection) {
            this.commandDisplay.selectAll();
        }
        this.enableCommandSelection = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.commandDisplay.setSelectionEnd(0);
    }

    private void setupListeners() {
        this.targetName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.dependsOn.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.subdirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.makeFlags.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        MakefileWizard makefileWizard = MakefileWizard.getMakefileWizard();
        if (this.tname.length() > 0 || this.depends.length() > 0 || this.subdir.length() > 0 || this.mflags.length() > 0) {
            makefileWizard.getNextButton().setEnabled(true);
            if (makefileWizard.getMakefileData().isComplete(true)) {
                makefileWizard.getFinishButton().setEnabled(true);
            }
        } else {
            makefileWizard.getNextButton().setEnabled(false);
            makefileWizard.getFinishButton().setEnabled(false);
        }
    }

    public boolean isPanelValid() {
        if (this.tname != null && this.depends != null && this.subdir != null && this.mflags != null) {
            return this.tname.length() > 0 || this.depends.length() > 0 || this.subdir.length() > 0 || this.mflags.length() > 0;
        }
        return false;
    }

    private String getCommandDisplay() {
        return this.getCommandDisplay(-1);
    }

    private String getCommandDisplay(int n) {
        StringBuffer stringBuffer = new StringBuffer(512);
        TargetData targetData = n < 0 ? this.getMakefileData().getCurrentTarget() : this.getMakefileData().getTarget(n);
        stringBuffer.append(targetData.getName());
        stringBuffer.append(": ");
        if (this.depends.length() > 0) {
            stringBuffer.append(this.depends);
        }
        String[] stringArray = this.getSubDirList();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\n\t");
            if (stringArray[i].length() > 0) {
                stringBuffer.append("cd ").append(stringArray[i]).append("; ");
            }
            stringBuffer.append("$(MAKE) ");
            if (this.mflags.length() > 0) {
                stringBuffer.append(this.mflags).append(' ');
            }
            if (this.tname.length() <= 0) continue;
            stringBuffer.append(this.tname);
        }
        return stringBuffer.toString();
    }

    private String[] getSubDirList() {
        String[] stringArray;
        if (this.subdir.length() < 1 || this.subdir.equals(".")) {
            stringArray = new String[]{new String("")};
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.subdir, " ");
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            stringArray = new String[n];
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public void validateData(ArrayList arrayList, int n) {
        block5: {
            block3: {
                File file;
                block4: {
                    TargetData targetData = this.getMakefileData().getTarget(n);
                    String string = this.getMakefileData().getBaseDirectory(true);
                    file = null;
                    if (this.subdir.length() > 0 && !this.subdir.equals(".") && (file = this.subdir.startsWith(File.separator) ? new File(this.subdir) : new File(string, this.subdir)).getPath().equals(string)) {
                        file = null;
                    }
                    if (file == null) break block3;
                    if (file.exists()) break block4;
                    this.warn(arrayList, WARN_SUBDIR_DOES_NOT_EXIST, this.subdir, this.tname);
                    break block5;
                }
                if (file.canWrite()) break block5;
                this.warn(arrayList, WARN_SUBDIR_NOT_WRITABLE, this.subdir, this.tname);
                break block5;
            }
            ArrayList arrayList2 = this.getMakefileData().getTargetList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (!this.tname.equals(((TargetData)arrayList2.get(i)).getName())) continue;
                this.warn(arrayList, WARN_INFINITE_RECURSION, this.tname);
            }
        }
        if (!this.isValidMakeFlags()) {
            this.warn(arrayList, WARN_INVALID_MAKEFLAGS);
        }
    }

    private boolean isValidMakeFlags() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.mflags.length(); ++i) {
            char c = this.mflags.charAt(i);
            if (n != 92) {
                if (c == '\'') {
                    ++n2;
                }
                if (c == '\"') {
                    ++n3;
                }
            }
            n = c;
        }
        return n2 % 2 != 1 && n3 % 2 != 1;
    }

    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        this.key = targetData.getKey();
        this.targetName.setText(this.tname);
        this.dependsOn.setText(this.depends);
        this.subdirectory.setText(this.subdir);
        this.makeFlags.setText(this.mflags);
        this.commandDisplay.setText(this.getCommandDisplay());
        this.updateButtons();
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        targetData.setTargetName(this.tname);
        targetData.setDependsOn(this.depends);
        targetData.setSubdirectory(this.subdir);
        targetData.setMakeFlags(this.mflags);
    }
}

