/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.CompilerFlags;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.openide.util.NbBundle;

public final class MakefileData {
    public static final int EXECUTABLE_MAKEFILE_TYPE = 1;
    public static final int ARCHIVE_MAKEFILE_TYPE = 2;
    public static final int SHAREDLIB_MAKEFILE_TYPE = 3;
    public static final int COMPLEX_MAKEFILE_TYPE = 4;
    public static final int SUN_TOOLSET_TYPE = 0;
    public static final int GNU_TOOLSET_TYPE = 1;
    public static final int SUNGNU_TOOLSET_TYPE = 2;
    public static final int SOLARIS_OS_TYPE = 0;
    public static final int LINUX_OS_TYPE = 1;
    public static final int UNIX_OS_TYPE = 2;
    public static final int WINDOWS_OS_TYPE = 3;
    public static final int MACOSX_OS_TYPE = 4;
    private int conformLevelCSun = 1;
    public static final String[] conformLevelsCSun = new String[]{"-Xc", "", "-Xs"};
    private int conformLevelCppSun = 1;
    public static final String[] conformLevelsCppSun = new String[]{"-compat=4", ""};
    private int conformLevelCGNU = 1;
    public static final String[] conformLevelsCGNU = new String[]{"-ansi", ""};
    private int conformLevelCppGNU = 1;
    public static final String[] conformLevelsCppGNU = new String[]{"-ansi", ""};
    private int makefileType;
    private int toolset;
    private int makefileOS;
    private String baseDirectory;
    private String makefileName;
    private String makefileDirName;
    private ArrayList targetList;
    private CompilerFlags compilerFlags;
    private ResourceBundle bundle;
    private String cCompilerSun;
    private String cCompilerGNU;
    private String cppCompilerSun;
    private String cppCompilerGNU;
    private String fCompilerSun;
    private String fCompilerGNU;
    private int ftype;
    private boolean moduleEnabled;
    private String xdCompiler;
    private String asmPath;
    private static String binDir;
    public static final int COMPAT_DEFAULT = 0;
    public static final int COMPAT_ANSI = 1;
    public static final int COMPAT_4_2 = 2;
    public static final boolean EXPAND = true;
    private String indent;

    public MakefileData() {
        this.makefileType = 4;
        this.toolset = 2;
        this.makefileOS = 2;
        this.baseDirectory = new String(System.getProperty("user.dir"));
        this.makefileName = this.getString("DFLT_MakefileName");
        this.targetList = new ArrayList();
        this.compilerFlags = new CompilerFlags();
        binDir = null;
        this.moduleEnabled = false;
    }

    public MakefileData(MakefileData makefileData) {
        this.bundle = NbBundle.getBundle(MakefileWizardPanel.class);
        this.makefileType = makefileData.getMakefileType();
        this.toolset = makefileData.getToolset();
        this.makefileOS = makefileData.getMakefileOS();
        this.baseDirectory = makefileData.getBaseDirectory();
        this.makefileName = makefileData.getMakefileName();
        this.makefileDirName = makefileData.getMakefileDirName();
        this.targetList = new ArrayList();
        this.compilerFlags = new CompilerFlags();
    }

    public String getMakefilePath() {
        String string;
        String string2 = IpeUtils.expandPath(this.makefileName);
        if (string2.charAt(0) == File.separatorChar) {
            string = this.makefileName;
        } else {
            File file = new File(this.getBaseDirectory(true), string2);
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
        }
        return string;
    }

    public String defaultOutputDirectory() {
        String string = "toolset";
        String string2 = "os";
        String string3 = null;
        if (this.getToolset() == 0) {
            string = "Sun";
        } else if (this.getToolset() == 1) {
            string = "GNU";
        }
        if (this.getMakefileOS() == 0) {
            string2 = "Solaris";
        } else if (this.getMakefileOS() == 1) {
            string2 = "Linux";
        } else if (this.getMakefileOS() == 3) {
            string2 = "Windows";
        } else if (this.getMakefileOS() == 4) {
            string2 = "MacOSX";
        }
        string3 = string + "-" + System.getProperty("os.arch") + "-" + string2;
        return string3;
    }

    public int getMakefileType() {
        return this.makefileType;
    }

    public void setMakefileType(int n) {
        this.makefileType = n;
    }

    public String getConformFlagCSun() {
        return conformLevelsCSun[this.conformLevelCSun];
    }

    public int getConformLevelCSun() {
        return this.conformLevelCSun;
    }

    public void setConformLevelCSun(int n) {
        this.conformLevelCSun = n;
    }

    public String getConformFlagCppSun() {
        return conformLevelsCppSun[this.conformLevelCppSun];
    }

    public int getConformLevelCppSun() {
        return this.conformLevelCppSun;
    }

    public void setConformLevelCppSun(int n) {
        this.conformLevelCppSun = n;
    }

    public String getConformFlagCGNU() {
        return conformLevelsCGNU[this.conformLevelCGNU];
    }

    public int getConformLevelCGNU() {
        return this.conformLevelCGNU;
    }

    public void setConformLevelCGNU(int n) {
        this.conformLevelCGNU = n;
    }

    public String getConformFlagCppGNU() {
        return conformLevelsCppGNU[this.conformLevelCppGNU];
    }

    public int getConformLevelCppGNU() {
        return this.conformLevelCppGNU;
    }

    public void setConformLevelCppGNU(int n) {
        this.conformLevelCppGNU = n;
    }

    public int getToolset() {
        return this.toolset;
    }

    public void setToolset(int n) {
        this.toolset = n;
    }

    public int getMakefileOS() {
        return this.makefileOS;
    }

    public void setMakefileOS(int n) {
        this.makefileOS = n;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getBaseDirectory(boolean bl) {
        return this.getBaseDirectory();
    }

    public void setBaseDirectory(String string) {
        this.baseDirectory = IpeUtils.trimSlashes(string);
    }

    public String getMakefileName() {
        return this.makefileName;
    }

    public void setMakefileName(String string) {
        if (string.length() > 0) {
            this.makefileName = string;
        }
    }

    public String getMakefileDirName() {
        return this.makefileDirName;
    }

    public void setMakefileDirName(String string) {
        if (string.length() > 0) {
            this.makefileDirName = string;
        }
    }

    public CompilerFlags getCompilerFlags() {
        return this.compilerFlags;
    }

    public ArrayList getTargetList() {
        if (this.targetList == null) {
            this.targetList = new ArrayList(this.makefileType == 4 ? 15 : 1);
        }
        return this.targetList;
    }

    public TargetData getCurrentTarget() {
        int n = MakefileWizard.getMakefileWizard().getCurrentTargetKey();
        return this.getTarget(n);
    }

    public TargetData getTarget(int n) {
        TargetData targetData = null;
        for (int i = 0; i < this.targetList.size() && (targetData = (TargetData)this.targetList.get(i)).getKey() != n; ++i) {
        }
        return targetData;
    }

    public boolean isComplete(boolean bl) {
        TargetData targetData = this.getCurrentTarget();
        for (int i = 0; i < this.targetList.size(); ++i) {
            TargetData targetData2 = (TargetData)this.targetList.get(i);
            if (targetData2 == targetData && bl || targetData2.isComplete()) continue;
            return false;
        }
        return this.targetList.size() > 0;
    }

    public boolean isComplete() {
        return this.isComplete(false);
    }

    public String getCCompiler(int n) {
        if (n == 0) {
            return this.getCCompilerSun();
        }
        if (n == 1) {
            return this.getCCompilerGNU();
        }
        return null;
    }

    public String getCCompilerSun() {
        if (this.cCompilerSun == null) {
            this.cCompilerSun = "cc";
        }
        return this.cCompilerSun;
    }

    public String getCCompilerGNU() {
        if (this.cCompilerGNU == null) {
            this.cCompilerGNU = "gcc";
        }
        return this.cCompilerGNU;
    }

    public void setCCompiler(int n, String string) {
        if (n == 0) {
            this.setCCompilerSun(string);
        } else if (n == 1) {
            this.setCCompilerGNU(string);
        }
    }

    public void setCCompilerSun(String string) {
        this.cCompilerSun = string;
    }

    public void setCCompilerGNU(String string) {
        this.cCompilerGNU = string;
    }

    public String getCppCompiler(int n) {
        if (n == 0) {
            return this.getCppCompilerSun();
        }
        if (n == 1) {
            return this.getCppCompilerGNU();
        }
        return null;
    }

    public String getCppCompilerSun() {
        if (this.cppCompilerSun == null) {
            this.cppCompilerSun = "CC";
        }
        return this.cppCompilerSun;
    }

    public String getCppCompilerGNU() {
        if (this.cppCompilerGNU == null) {
            this.cppCompilerGNU = "g++";
        }
        return this.cppCompilerGNU;
    }

    public void setCppCompiler(int n, String string) {
        if (n == 0) {
            this.setCppCompilerSun(string);
        } else if (n == 1) {
            this.setCppCompilerGNU(string);
        }
    }

    public void setCppCompilerSun(String string) {
        this.cppCompilerSun = string;
    }

    public void setCppCompilerGNU(String string) {
        this.cppCompilerGNU = string;
    }

    public String getFCompiler(int n) {
        if (n == 0) {
            return this.getFCompilerSun();
        }
        if (n == 1) {
            return this.getFCompilerGNU();
        }
        return null;
    }

    public String getFCompilerSun() {
        if (this.fCompilerSun == null) {
            this.fCompilerSun = "f95";
        }
        return this.fCompilerSun;
    }

    public String getFCompilerGNU() {
        if (this.fCompilerGNU == null) {
            this.fCompilerGNU = "g77";
        }
        return this.fCompilerGNU;
    }

    public void setFCompiler(int n, String string) {
        if (n == 0) {
            this.setFCompilerSun(string);
        } else if (n == 1) {
            this.setFCompilerGNU(string);
        }
    }

    public void setFCompilerSun(String string) {
        this.fCompilerSun = string;
    }

    public void setFCompilerGNU(String string) {
        this.fCompilerGNU = string;
    }

    public String getAsmPath() {
        if (this.asmPath == null) {
            this.asmPath = "as";
        }
        return this.asmPath;
    }

    public void setAsmPath(String string) {
        this.asmPath = string;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileWizardPanel.class);
        }
        return this.bundle.getString(string);
    }

    public final boolean isModuleEnabled() {
        return this.moduleEnabled;
    }

    public void setModuleEnabled(boolean bl) {
        this.moduleEnabled = bl;
    }

    public void dump() {
        this.setIndent("");
        this.println("\n\nDumping Makefile:");
        this.println("    makefileType     = " + this.makefileType);
        this.println("    toolset " + this.toolset);
        this.println("    makefileOS     = " + this.makefileOS);
        this.println("    baseDirectory = \"" + this.baseDirectory + "\"");
        this.println("    makefileName     = \"" + this.makefileName + "\"");
        this.println("    makefileDirName  = \"" + this.makefileDirName + "\"");
        this.compilerFlags.dump(this.indent + "    ");
        this.println("    targetList.size  = " + this.targetList.size());
        for (int i = 0; i < this.targetList.size(); ++i) {
            this.println("    targetList[" + i + "]    = {");
            ((TargetData)this.targetList.get(i)).dump(new StringBuffer(this.indent).append("    ").toString());
            this.println("    }");
        }
    }

    public void dump(String string) {
        this.setIndent(string);
        this.dump();
    }

    private void println(String string) {
        System.out.println(this.indent + string);
    }

    private void setIndent(String string) {
        this.indent = string;
    }

    public boolean validateTargetName(String string, int n) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            bl = false;
        } else {
            switch (n) {
                case 5: 
                case 6: 
                case 7: {
                    bl = this.dontContainChar(string, ":#= \t()");
                    break;
                }
                case 8: 
                case 9: {
                    bl = this.dontContainChar(string, ":#= \t");
                    break;
                }
            }
        }
        return bl;
    }

    private boolean dontContainChar(String string, String string2) {
        boolean bl = true;
        if (string2 != null && string2.length() != 0) {
            for (int i = 0; i < string2.length(); ++i) {
                if (string.indexOf(string2.charAt(i)) < 0) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

