/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.editor.filecreation.CndExtensionList;
import org.netbeans.modules.cnd.editor.filecreation.CndHandlableExtensions;
import org.netbeans.modules.cnd.editor.filecreation.ExtensionsSettings;
import org.netbeans.modules.cnd.ui.options.StringArrayCustomEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CndOtherOptionsPanel
extends JPanel
implements ActionListener {
    private final Collection<? extends CndHandlableExtensions> res;
    private boolean isChanged = false;
    private final List<ExtensionsElements> eeList = new ArrayList<ExtensionsElements>();
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CndOtherOptionsPanel() {
        this.res = Lookup.getDefault().lookupResult(CndHandlableExtensions.class).allInstances();
        this.setName("TAB_CndOtherOptionsTab");
        this.initComponents();
        this.initGeneratedComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        for (ExtensionsElements extensionsElements : this.eeList) {
            extensionsElements.apply();
        }
        this.isChanged = false;
    }

    void update() {
        for (ExtensionsElements extensionsElements : this.eeList) {
            extensionsElements.update();
        }
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.isChanged = true;
    }

    private void editExtensionsButtonActionPerformed(ExtensionsElements extensionsElements) {
        StringArrayCustomEditor stringArrayCustomEditor = new StringArrayCustomEditor(extensionsElements.getValues(), extensionsElements.defaultValue, CndOtherOptionsPanel.getMessage("EE_ItemLabel"), CndOtherOptionsPanel.getMessage("EE_ItemLabel_Mnemonic").charAt(0), CndOtherOptionsPanel.getMessage("EE_ItemListLabel"), CndOtherOptionsPanel.getMessage("EE_ItemListLabel_Mnemonic").charAt(0), false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)stringArrayCustomEditor, gridBagConstraints);
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle"), true, objectArray, NotifyDescriptor.OK_OPTION, 0, null, null);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        Dialog dialog = dialogDisplayer.createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(CndOtherOptionsPanel.getMessage("ExtensionsListEditorTitle_AD"));
        dialog.pack();
        dialog.setSize(new Dimension(300, (int)dialog.getPreferredSize().getHeight()));
        dialog.setVisible(true);
        extensionsElements.defaultValue = stringArrayCustomEditor.getDefaultValue();
        extensionsElements.setValues(stringArrayCustomEditor.getItemList());
    }

    private void initGeneratedComponents() {
        ExtensionsSettings extensionsSettings;
        for (CndHandlableExtensions cndHandlableExtensions2 : this.res) {
            extensionsSettings = ExtensionsSettings.getInstance(cndHandlableExtensions2);
            final ExtensionsElements i = new ExtensionsElements(extensionsSettings);
            i.label.setText(NbBundle.getMessage(CndOtherOptionsPanel.class, (String)"EE_ExtensionListTitle", (Object)cndHandlableExtensions2.getDisplayNameForExtensionList()));
            i.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CndOtherOptionsPanel.this.editExtensionsButtonActionPerformed(i);
                }
            });
            this.eeList.add(i);
        }
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        sequentialGroup.add(12, 12, 12);
        extensionsSettings = groupLayout.createParallelGroup(1);
        for (int parallelGroup = 0; parallelGroup < this.eeList.size(); ++parallelGroup) {
            extensionsSettings.add(this.eeList.get((int)parallelGroup).label);
        }
        sequentialGroup.add((GroupLayout.Group)extensionsSettings);
        sequentialGroup.add(4, 4, 4);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(1, false);
        for (int parallelGroup2 = 0; parallelGroup2 < this.eeList.size(); ++parallelGroup2) {
            parallelGroup.add((Component)this.eeList.get((int)parallelGroup2).textfield, -1, 274, Short.MAX_VALUE);
        }
        sequentialGroup.add((GroupLayout.Group)parallelGroup);
        sequentialGroup.add(6, 6, 6);
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup(1);
        for (int sequentialGroup2 = 0; sequentialGroup2 < this.eeList.size(); ++sequentialGroup2) {
            parallelGroup2.add((Component)this.eeList.get((int)sequentialGroup2).button);
        }
        sequentialGroup.add((GroupLayout.Group)parallelGroup2);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)sequentialGroup).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout.SequentialGroup sequentialGroup3 = groupLayout.createSequentialGroup().addContainerGap();
        for (int i = 0; i < this.eeList.size(); ++i) {
            ExtensionsElements extensionsElements = this.eeList.get(i);
            sequentialGroup3.add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)extensionsElements.label).add((Component)extensionsElements.textfield, -2, 23, -2).add((Component)extensionsElements.button, -2, 23, -2));
            if (i != this.eeList.size() - 1) {
                sequentialGroup3.addPreferredGap(0);
                continue;
            }
            sequentialGroup3.addContainerGap(20, Short.MAX_VALUE);
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)sequentialGroup3));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 399, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.jPanel2.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 399, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 276, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CndOtherOptionsPanel.class, (String)string);
    }

    private static class ExtensionsElements {
        private final String DELIMITER = ", ";
        private final ExtensionsSettings es;
        public final JLabel label = new JLabel();
        public final JEditorPane textfield = new JEditorPane();
        public final JButton button = new JButton();
        public List<String> list;
        public String defaultValue;

        public ExtensionsElements(ExtensionsSettings extensionsSettings) {
            this.es = extensionsSettings;
            this.update();
            this.textfield.setContentType("text/html");
            this.textfield.setEditable(false);
            this.updateTextField();
            this.button.setText(CndOtherOptionsPanel.getMessage("CndOtherOptionsPanel.Extensions.EditButton"));
        }

        public void updateTextField() {
            String string = "";
            for (String string2 : this.list) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                if (string2.equals(this.defaultValue)) {
                    string2 = "<b>" + string2 + "</b>";
                }
                string = string + string2;
            }
            this.textfield.setText(string);
        }

        String[] getValues() {
            return this.list.toArray(new String[this.list.size()]);
        }

        void setValues(String[] stringArray) {
            this.list = Arrays.asList(stringArray);
            this.updateTextField();
        }

        public void apply() {
            CndExtensionList cndExtensionList = new CndExtensionList(this.getValues());
            this.es.setExtensionList(cndExtensionList);
            this.es.setDefaultExtension(this.defaultValue);
        }

        public void update() {
            this.list = new ArrayList<String>();
            this.defaultValue = this.es.getDefaultExtension();
            Enumeration<String> enumeration = this.es.getExtensionList().extensions();
            while (enumeration != null && enumeration.hasMoreElements()) {
                this.list.add(enumeration.nextElement());
            }
            this.updateTextField();
        }
    }
}

